/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.init;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.lying.init.WHCItems;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class WHCItemsClient {
    private static final List<ExtraModelHandler> EXTRA_MODELS = Lists.newArrayList();

    private static void addExtraCrutchModel(RegistrySupplier<class_1792> item) {
        EXTRA_MODELS.add(new ExtraModelHandler(item, "_in_hand", (Predicate<class_811>)((Predicate)WHCItemsClient::onPerson)));
    }

    private static void addExtraCaneModel(RegistrySupplier<class_1792> item) {
        EXTRA_MODELS.add(new ExtraModelHandler(item, "_in_gui", (Predicate<class_811>)((Predicate)WHCItemsClient::inGUI)));
    }

    private static boolean onPerson(class_811 mode) {
        return mode == class_811.field_4323 || mode == class_811.field_4320;
    }

    private static boolean inGUI(class_811 mode) {
        return mode == class_811.field_4319 || mode == class_811.field_4317 || mode == class_811.field_4318 || mode == class_811.field_4315;
    }

    public static List<class_2960> getExtraModelsToRegister() {
        return EXTRA_MODELS.stream().filter(ExtraModelHandler::needsRegistration).map(ExtraModelHandler::model).toList();
    }

    @Nullable
    public static class_2960 getExtraModelIfAny(class_1792 item, class_811 mode) {
        for (ExtraModelHandler handler : EXTRA_MODELS) {
            if (!handler.shouldApply(item, mode)) continue;
            return handler.model();
        }
        return null;
    }

    static {
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_ACACIA);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_BAMBOO);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_BIRCH);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_CHERRY);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_CRIMSON);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_DARK_OAK);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_JUNGLE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_MANGROVE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_OAK);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_SPRUCE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_WARPED);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_ACACIA);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_BAMBOO);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_BIRCH);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_CHERRY);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_CRIMSON);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_DARK_OAK);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_JUNGLE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_MANGROVE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_OAK);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_SPRUCE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_WARPED);
    }

    public static class ExtraModelHandler {
        private final RegistrySupplier<class_1792> item;
        private final Predicate<class_811> qualifier;
        private final String suffix;
        private Optional<class_2960> model = Optional.empty();
        private final boolean shouldRegister;

        public ExtraModelHandler(RegistrySupplier<class_1792> itemIn, String suffixIn, Predicate<class_811> qualifierIn) {
            this(itemIn, suffixIn, qualifierIn, true);
        }

        public ExtraModelHandler(RegistrySupplier<class_1792> itemIn, String suffixIn, Predicate<class_811> qualifierIn, boolean shouldRegisterIn) {
            this.item = itemIn;
            this.qualifier = qualifierIn;
            this.suffix = suffixIn;
            this.shouldRegister = shouldRegisterIn;
        }

        public boolean needsRegistration() {
            return this.shouldRegister;
        }

        public boolean shouldApply(class_1792 itemIn, class_811 mode) {
            return itemIn == this.item.get() && this.qualifier.apply((Object)mode);
        }

        public class_2960 model() {
            if (this.model.isPresent()) {
                return this.model.get();
            }
            class_2960 itemID = this.item.getId();
            class_2960 id = class_2960.method_60655((String)itemID.method_12836(), (String)(itemID.method_12832() + this.suffix));
            this.model = Optional.of(id);
            return id;
        }
    }
}

