/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.google.common.collect.Lists;
import com.lying.client.renderer.entity.feature.EntityFeatureRenderer;
import com.lying.client.renderer.entity.state.WalkerEntityRenderState;
import com.lying.entity.WalkerEntity;
import com.lying.item.WalkerItem;
import com.lying.reference.Reference;
import java.util.List;
import net.minecraft.class_10017;
import net.minecraft.class_1059;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;

public class WalkerEntityRenderer
extends class_897<WalkerEntity, WalkerEntityRenderState> {
    protected static final class_310 mc = class_310.method_1551();
    private static final class_1091 CHEST_MODEL = new class_1091(Reference.ModInfo.prefix("walker_chest"), "");
    private static final double xOffset = 0.325;
    protected final class_918 renderItem = class_310.method_1551().method_1480();
    protected final class_776 blockRenderManager;
    private final List<EntityFeatureRenderer<WalkerEntityRenderState>> featureRenderers = Lists.newArrayList();

    public WalkerEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.blockRenderManager = context.method_43337();
    }

    public WalkerEntityRenderState createRenderState() {
        return new WalkerEntityRenderState();
    }

    public class_2960 getTexture(WalkerEntity entity) {
        return class_1059.field_5275;
    }

    public void updateRenderState(WalkerEntity entity, WalkerEntityRenderState state, float tickDelta) {
        super.method_62354((class_1297)entity, (class_10017)state, tickDelta);
        state.field_53446 = class_3532.method_17821((float)tickDelta, (float)entity.field_6220, (float)entity.field_6283);
        state.frame = entity.getFrame();
        state.leftWheel = entity.getLeftWheel();
        state.rightWheel = entity.getRightWheel();
        state.spinLeft = entity.spinLeft;
        state.spinRight = entity.spinRight;
        state.hasInventory = entity.hasInventory();
        state.hasParent = entity.hasParent();
        state.velocity = entity.method_18798();
        state.casterWheelYaw = entity::casterWheelYaw;
    }

    public void render(WalkerEntityRenderState state, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_1799 frame;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - state.field_53446));
        class_1092 bakedModelManager = this.blockRenderManager.method_3351().method_3333();
        class_778 modelRenderer = this.blockRenderManager.method_3350();
        if (state.hasInventory) {
            matrices.method_22903();
            matrices.method_46416(-0.5f, 0.0f, -0.5f);
            modelRenderer.method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_4722.method_24074()), null, bakedModelManager.method_4742(CHEST_MODEL), 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
            matrices.method_22909();
        }
        if ((frame = state.frame).method_7909() instanceof WalkerItem) {
            matrices.method_22903();
            matrices.method_46416(-0.5f, 0.0f, -0.5f);
            modelRenderer.method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_4722.method_24074()), null, bakedModelManager.method_4742(WalkerEntityRenderer.walkerModel(frame.method_7909())), 1.0f, 1.0f, 1.0f, light, class_4608.field_21444);
            matrices.method_22909();
        }
        this.renderWheels(matrices, vertexConsumers, light, state.leftWheel, state.spinLeft, state.rightWheel, state.spinRight, state.field_53446, state.casterWheelYaw.apply(Float.valueOf(state.partialTick)).floatValue(), state.world, state.entityId);
        this.featureRenderers.stream().filter(f -> f.shouldRender(state)).forEach(feature -> feature.render(matrices, vertexConsumers, light, state, state.partialTick));
        matrices.method_22909();
    }

    private void renderWheels(class_4587 matrices, class_4597 renderTypeBuffer, int light, class_1799 left, float leftSpin, class_1799 right, float rightSpin, float frameYaw, float casterYaw, class_1937 world, int seed) {
        this.renderFrontWheels(matrices, renderTypeBuffer, light, frameYaw, casterYaw, left, right, leftSpin, rightSpin, 0.325, -0.15, 0.25, world, seed);
        this.renderRearWheels(matrices, renderTypeBuffer, light, left, right, leftSpin, rightSpin, 0.325, -0.1, -0.325, world, seed);
    }

    private void renderFrontWheels(class_4587 matrices, class_4597 renderTypeBuffer, int light, float frameYaw, float yaw, class_1799 left, class_1799 right, float leftSpin, float rightSpin, double xOffset, double yOffset, double zOffset, class_1937 world, int seed) {
        float scale = 0.3f;
        float thickness = 3.0f;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(xOffset, yOffset, zOffset);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(frameYaw));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(yaw));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-rightSpin));
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale * thickness);
        this.renderItem.method_23178(right, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(-xOffset, yOffset, zOffset);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(frameYaw));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(yaw));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-leftSpin));
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale * thickness);
        this.renderItem.method_23178(left, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22909();
    }

    private void renderRearWheels(class_4587 matrices, class_4597 renderTypeBuffer, int light, class_1799 left, class_1799 right, float leftSpin, float rightSpin, double xOffset, double yOffset, double zOffset, class_1937 world, int seed) {
        float scale = 0.2f;
        float thickness = 3.0f;
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(xOffset, yOffset, zOffset);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-rightSpin));
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale * thickness);
        this.renderItem.method_23178(right, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(-xOffset, yOffset, zOffset);
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-leftSpin));
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale * thickness);
        this.renderItem.method_23178(left, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22909();
    }

    public static class_1091 walkerModel(class_1792 chairIn) {
        return new class_1091(class_7923.field_41178.method_10221((Object)chairIn), "");
    }
}

