/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.lying.client.renderer.entity.WheelchairsRideableEntityRenderer;
import com.lying.client.renderer.entity.feature.WheelchairElytraFeatureRenderer;
import com.lying.client.renderer.entity.state.WheelchairEntityRenderState;
import com.lying.entity.WheelchairEntity;
import com.lying.item.WheelchairItem;
import com.lying.reference.Reference;
import java.util.Optional;
import net.minecraft.class_1059;
import net.minecraft.class_1091;
import net.minecraft.class_1092;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;

public class WheelchairEntityRenderer
extends WheelchairsRideableEntityRenderer<WheelchairEntity, WheelchairEntityRenderState> {
    public WheelchairEntityRenderer(class_5617.class_5618 context) {
        super(context);
        this.addFeature(new WheelchairElytraFeatureRenderer(context));
    }

    public WheelchairEntityRenderState createRenderState() {
        return new WheelchairEntityRenderState();
    }

    public class_2960 getTexture(WheelchairEntity entity) {
        return class_1059.field_5275;
    }

    @Override
    public void updateRenderState(WheelchairEntity entity, WheelchairEntityRenderState state, float tickDelta) {
        super.updateRenderState(entity, state, tickDelta);
        state.chair = entity.getChair();
        state.leftWheel = entity.getLeftWheel();
        state.rightWheel = entity.getRightWheel();
        state.color = entity.getColor();
        state.spinLeft = entity.spinLeft;
        state.spinRight = entity.spinRight;
        state.upgrades = entity.getUpgrades();
        state.hasParent = entity.hasParent();
        state.isFlying = entity.isFlying();
        state.isGliding = entity.method_6128();
        state.velocity = entity.method_18798();
        state.rider = entity.method_5782() && entity.method_31483() instanceof class_1309 ? Optional.of((class_1309)entity.method_31483()) : Optional.empty();
    }

    public void render(WheelchairEntityRenderState state, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        float h = 0.0f;
        h = state.hasParent ? state.field_53447 : state.field_53446;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f - h));
        int color = state.color;
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        class_1092 bakedModelManager = this.blockRenderManager.method_3351().method_3333();
        class_778 modelRenderer = this.blockRenderManager.method_3350();
        state.upgrades.forEach(upgrade -> {
            if (!upgrade.hasModel()) {
                return;
            }
            matrices.method_22903();
            matrices.method_46416(-0.5f, 0.0f, -0.5f);
            modelRenderer.method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_4722.method_24074()), null, bakedModelManager.method_4742(WheelchairEntityRenderer.upgradeModel(upgrade.registryName())), r, g, b, light, class_4608.field_21444);
            matrices.method_22909();
        });
        class_1799 chair = state.chair;
        if (chair.method_7909() instanceof WheelchairItem) {
            matrices.method_22903();
            matrices.method_46416(-0.5f, 0.0f, -0.5f);
            modelRenderer.method_3367(matrices.method_23760(), vertexConsumers.getBuffer(class_4722.method_24074()), null, bakedModelManager.method_4742(WheelchairEntityRenderer.seatModel(chair.method_7909())), r, g, b, light, class_4608.field_21444);
            matrices.method_22909();
        }
        this.renderWheels(matrices, vertexConsumers, light, state.leftWheel, state.spinLeft, state.rightWheel, state.spinRight, state.world, state.entityId);
        this.renderFeatures(state, matrices, vertexConsumers, light);
        matrices.method_22909();
    }

    private void renderWheels(class_4587 matrices, class_4597 renderTypeBuffer, int light, class_1799 left, float leftSpin, class_1799 right, float rightSpin, class_1937 world, int seed) {
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(0.4, -0.5, 0.0);
        matrices.method_22903();
        matrices.method_22905(1.0f, 1.0f, 1.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(10.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-rightSpin));
        this.renderItem.method_23178(right, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_22904(-0.4, -0.5, 0.0);
        matrices.method_22903();
        matrices.method_22905(1.0f, 1.0f, 1.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-10.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(-leftSpin));
        this.renderItem.method_23178(left, class_811.field_4319, light, class_4608.field_21444, matrices, renderTypeBuffer, world, seed);
        matrices.method_22909();
        matrices.method_22909();
    }

    public static class_1091 seatModel(class_1792 chairIn) {
        class_2960 registry = class_7923.field_41178.method_10221((Object)chairIn);
        return new class_1091(registry, "");
    }

    public static class_1091 upgradeModel(class_2960 upgrade) {
        return new class_1091(Reference.ModInfo.prefix("upgrade_" + upgrade.method_12832()), "");
    }
}

