/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.lying.client.utility.AACLibrary;
import com.lying.network.AACMessagePacket;
import com.lying.reference.Reference;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class AACScreen
extends class_437 {
    private static final class_310 mc = class_310.method_1551();
    public static final class_2960 TEXTURE = Reference.ModInfo.prefix("textures/gui/speech_tablet.png");
    private static AACLibrary.PhraseSet[] SETS = AACLibrary.ALL_SETS;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BUTTON_WIDTH = 80;
    private static final int SPACING = 5;
    private static final int ROW_COUNT = 5;
    private static final int COL_COUNT = 5;
    private Mode messageMode = Mode.SINGLE;
    private class_5250 messageToSend = null;
    private int currentSet = 0;
    private class_4185[] setButtons = new class_4185[SETS.length];
    private AACButton[] phraseButtons = new AACButton[25];
    private class_4185 sendButton;

    public AACScreen(class_2561 title) {
        super(title);
    }

    public void method_25426() {
        super.method_25426();
        int gridWidth = 420;
        int left = (this.field_22789 - gridWidth) / 2;
        int right = (this.field_22789 + gridWidth) / 2;
        this.generateSetButtons();
        this.generatePhraseButtonGrid();
        this.method_37063((class_364)new ModeButtonWidget(this, left, 220, button -> this.setMode(this.messageMode == Mode.SINGLE ? Mode.COMPOUND : Mode.SINGLE), this));
        this.sendButton = class_4185.method_46430((class_2561)Reference.ModInfo.translate("gui", "send_aac_message"), button -> this.send(this.messageToSend)).method_46434(right - 35, 220, 35, 20).method_46431();
        this.method_37063((class_364)this.sendButton);
        this.setMode(Mode.SINGLE);
        this.setPhraseSet(0);
    }

    private void generateSetButtons() {
        int gridWidth = 420;
        int setShift = 85;
        int left = (this.field_22789 - gridWidth) / 2;
        for (int i = 0; i < SETS.length; ++i) {
            int index = i;
            AACLibrary.PhraseSet set = SETS[i];
            this.setButtons[i] = class_4185.method_46430((class_2561)set.displayName(), button -> this.setPhraseSet(index)).method_46434(left + setShift * i, 25, 80, 20).method_46431();
            this.method_37063((class_364)this.setButtons[i]);
        }
    }

    private void generatePhraseButtonGrid() {
        int gridWidth = 420;
        int left = (this.field_22789 - gridWidth) / 2;
        int shiftX = 85;
        int shiftY = 35;
        for (int i = 0; i < this.phraseButtons.length; ++i) {
            int col = i % 5;
            int row = Math.floorDiv(i, 5);
            this.phraseButtons[i] = new AACButton(this, left + shiftX * col, 48 + shiftY * row, this);
            this.method_37063((class_364)this.phraseButtons[i]);
        }
    }

    private void setPhraseSet(int index) {
        this.currentSet = Math.abs(index) % SETS.length;
        this.updateButtons();
    }

    private void updateButtons() {
        this.sendButton.field_22764 = this.messageMode == Mode.COMPOUND;
        this.sendButton.field_22763 = this.messageToSend != null;
        for (int i = 0; i < this.setButtons.length; ++i) {
            this.setButtons[i].field_22763 = i != this.currentSet;
        }
        AACLibrary.PhraseSet set = SETS[this.currentSet];
        for (int i = 0; i < this.phraseButtons.length; ++i) {
            AACButton phrase = this.phraseButtons[i];
            boolean bl = phrase.field_22763 = i < set.size();
            if (i >= set.size()) {
                phrase.clear();
                continue;
            }
            class_3545<class_2561, Supplier<class_5250>> entry = set.get(i);
            phrase.setPhrase((class_2561)entry.method_15442(), (Supplier)entry.method_15441());
        }
        this.method_25395(null);
    }

    public boolean method_25421() {
        return false;
    }

    public void setMode(Mode modeIn) {
        if (this.messageMode == modeIn) {
            return;
        }
        this.messageToSend = null;
        this.messageMode = modeIn;
        this.updateButtons();
    }

    public void append(class_5250 text) {
        switch (this.messageMode.ordinal()) {
            case 0: {
                this.send(text);
                break;
            }
            case 1: {
                if (this.messageToSend == null) {
                    this.messageToSend = text;
                    break;
                }
                this.messageToSend.method_27693(" ").method_10852((class_2561)text);
            }
        }
        this.sendButton.field_22763 = this.messageToSend != null;
    }

    public void send(@Nullable class_5250 message) {
        if (message != null) {
            AACMessagePacket.sendToServer((class_2561)message, (class_1657)AACScreen.mc.field_1724);
        }
        this.method_25419();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderForeground(context, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        int i = (this.field_22789 - 430) / 2;
        context.method_25291(class_1921::method_62277, TEXTURE, i, 10, 0.0f, 0.0f, 0, 430, 235, 512, 512);
    }

    private void renderForeground(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_51439(this.field_22793, this.field_22785, (this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, 15, 0x404040, false);
        if (this.messageToSend != null) {
            class_5250 message = class_2561.method_43469((String)"aac.wheelchairs.message", (Object[])new Object[]{AACScreen.mc.field_1724.method_5476(), this.messageToSend});
            context.method_51439(this.field_22793, (class_2561)message, (this.field_22789 - this.field_22793.method_27525((class_5348)message)) / 2, 226, 0xFFFFFF, false);
        }
    }

    private static enum Mode {
        SINGLE,
        COMPOUND;


        public class_2561 translate() {
            return Reference.ModInfo.translate("aac_mode", this.name().toLowerCase());
        }
    }

    private class AACButton
    extends class_4185 {
        private final AACScreen parentScreen;
        private Supplier<class_5250> message = () -> null;

        protected AACButton(AACScreen aACScreen, int x, int y, AACScreen parent) {
            super(x, y, 80, 30, (class_2561)class_2561.method_43473(), button -> {
                if (!(button instanceof AACButton)) {
                    return;
                }
                AACButton phrase = (AACButton)button;
                class_5250 message = phrase.message.get();
                if (message != null) {
                    phrase.parentScreen.append(message);
                }
                phrase.parentScreen.method_25395(null);
            }, class_4185.field_40754);
            this.parentScreen = parent;
        }

        public void setPhrase(class_2561 title, Supplier<class_5250> messageIn) {
            this.method_25355(title);
            this.message = messageIn;
        }

        public void clear() {
            this.method_25355((class_2561)class_2561.method_43473());
            this.message = () -> null;
        }
    }

    private class ModeButtonWidget
    extends class_4185 {
        private final AACScreen parentScreen;

        public ModeButtonWidget(AACScreen aACScreen, int x, int y, class_4185.class_4241 onPress, AACScreen parent) {
            super(x, y, 20, 20, class_5244.field_39003, onPress, field_40754);
            this.parentScreen = parent;
            this.method_47400(class_7919.method_47407((class_2561)this.parentScreen.messageMode.translate()));
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25291(class_1921::method_62277, TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 235 + (this.method_49606() ? 20 : 0), 20, 20, 512, 512);
            context.method_25291(class_1921::method_62277, TEXTURE, this.method_46426(), this.method_46427(), 0.0f, 20.0f, 235 + this.parentScreen.messageMode.ordinal() * 20, 20, 20, 512, 512);
        }

        public void method_25306() {
            super.method_25306();
            this.method_47400(class_7919.method_47407((class_2561)this.parentScreen.messageMode.translate()));
        }
    }
}

