/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.utility;

import com.lying.Wheelchairs;
import com.lying.client.WheelchairsClient;
import com.lying.reference.Reference;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_5250;

public class AACLibrary {
    private static final class_310 mc = class_310.method_1551();
    public static PhraseSet BASIC;
    public static PhraseSet FEELINGS;
    public static PhraseSet PLACES;
    public static PhraseSet ACTIONS;
    public static PhraseSet THINGS;
    public static PhraseSet[] ALL_SETS;

    public static void init() {
        BASIC = new PhraseSet("basic", List.of(AACLibrary.entrySimple("hello"), AACLibrary.entrySimple("goodbye"), AACLibrary.entrySimple("yes"), AACLibrary.entrySimple("no"), AACLibrary.entrySimple("okay"), AACLibrary.entryDynamic((class_2561)AACLibrary.translate("my_coords_title"), () -> AACLibrary.translate("my_coords", AACLibrary.mc.field_1724.method_24515().method_23854())), AACLibrary.entryDynamic((class_2561)AACLibrary.translate("my_health_title"), () -> AACLibrary.translate("my_health", String.valueOf((int)AACLibrary.mc.field_1724.method_6032()))), AACLibrary.entryDynamic((class_2561)AACLibrary.translate("held_item_title"), () -> AACLibrary.translate("held_item", AACLibrary.mc.field_1724.method_6079().method_7964())), AACLibrary.entrySimple("come_here"), AACLibrary.entrySimple("stay_away"), AACLibrary.entrySimple("on_my_way"), AACLibrary.entrySimple("how_are_you"), AACLibrary.entrySimple("you"), AACLibrary.entrySimple("me"), AACLibrary.entrySimple("need"), AACLibrary.entrySimple("have"), AACLibrary.entrySimple("please"), AACLibrary.entrySimple("thank_you"), AACLibrary.entrySimple("more"), AACLibrary.entrySimple("less")));
        FEELINGS = new PhraseSet("feelings", List.of(AACLibrary.entrySimple("good"), AACLibrary.entrySimple("bad"), AACLibrary.entrySimple("scared"), AACLibrary.entrySimple("happy"), AACLibrary.entrySimple("fun"), AACLibrary.entrySimple("excited"), AACLibrary.entrySimple("bored"), AACLibrary.entrySimple("sad"), AACLibrary.entrySimple("alone"), AACLibrary.entrySimple("tired"), AACLibrary.entrySimple("nervous"), AACLibrary.entrySimple("confused"), AACLibrary.entrySimple("understand"), AACLibrary.entrySimple("hurt"), AACLibrary.entrySimple("hungry"), AACLibrary.entrySimple("danger"), AACLibrary.entrySimple("safe")));
        PLACES = new PhraseSet("places", List.of(AACLibrary.entrySimple("here"), AACLibrary.entrySimple("there"), AACLibrary.entrySimple("world_spawn"), AACLibrary.entrySimple("base"), AACLibrary.entrySimple("overworld"), AACLibrary.entrySimple("the_end"), AACLibrary.entrySimple("the_nether"), AACLibrary.entrySimple("stronghold"), AACLibrary.entrySimple("dungeon"), AACLibrary.entrySimple("ocean"), AACLibrary.entrySimple("desert"), AACLibrary.entrySimple("forest"), AACLibrary.entrySimple("field"), AACLibrary.entrySimple("quarry"), AACLibrary.entrySimple("caves"), AACLibrary.entrySimple("ravine"), AACLibrary.entrySimple("village"), AACLibrary.entrySimple("farm"), AACLibrary.entrySimple("spawner")));
        ACTIONS = new PhraseSet("actions", List.of(AACLibrary.entrySimple("explore"), AACLibrary.entrySimple("dig"), AACLibrary.entrySimple("craft"), AACLibrary.entrySimple("build"), AACLibrary.entrySimple("cook"), AACLibrary.entrySimple("enchant"), AACLibrary.entrySimple("look"), AACLibrary.entrySimple("going"), AACLibrary.entrySimple("help"), AACLibrary.entrySimple("eat"), AACLibrary.entrySimple("find"), AACLibrary.entrySimple("fight"), AACLibrary.entrySimple("swim"), AACLibrary.entrySimple("sail"), AACLibrary.entrySimple("fly"), AACLibrary.entrySimple("sleep"), AACLibrary.entrySimple("follow"), AACLibrary.entrySimple("stay"), AACLibrary.entrySimple("defeat"), AACLibrary.entrySimple("lost")));
        THINGS = new PhraseSet("things", List.of(AACLibrary.entrySimple("food"), AACLibrary.entrySimple("potion"), AACLibrary.entrySimple("fish"), AACLibrary.entrySimple("water"), AACLibrary.entrySimple("lava"), AACLibrary.entrySimple("bucket"), AACLibrary.entrySimple("pickaxe"), AACLibrary.entrySimple("axe"), AACLibrary.entrySimple("shovel"), AACLibrary.entrySimple("sword"), AACLibrary.entrySimple("leather"), AACLibrary.entrySimple("iron"), AACLibrary.entrySimple("gold"), AACLibrary.entrySimple("diamond"), AACLibrary.entrySimple("armor"), AACLibrary.entrySimple("helmet"), AACLibrary.entrySimple("chestplate"), AACLibrary.entrySimple("leggings"), AACLibrary.entrySimple("boots"), AACLibrary.entrySimple("monster"), AACLibrary.entrySimple("animal"), AACLibrary.entrySimple("trader"), AACLibrary.entrySimple("pet"), AACLibrary.entrySimple("boss"), AACLibrary.entrySimple("dragon")));
        ALL_SETS = new PhraseSet[]{BASIC, FEELINGS, PLACES, ACTIONS, THINGS};
        int total = 0;
        for (PhraseSet set : ALL_SETS) {
            total += set.size();
        }
        Wheelchairs.LOGGER.info("Initialised AAC library with " + total + " phrases across " + ALL_SETS.length + " sets");
        Wheelchairs.LOGGER.info("AAC narration setting: " + WheelchairsClient.config.shouldNarrateAAC());
    }

    private static class_5250 translate(String name) {
        return Reference.ModInfo.translate("aac", name.toLowerCase()).method_27661();
    }

    private static class_5250 translate(String name, Object ... args) {
        return Reference.ModInfo.translate("aac", name.toLowerCase(), args).method_27661();
    }

    private static class_3545<class_2561, Supplier<class_5250>> entrySimple(String name) {
        return AACLibrary.entrySimple(() -> AACLibrary.translate(name.toLowerCase()));
    }

    private static class_3545<class_2561, Supplier<class_5250>> entrySimple(Supplier<class_5250> name) {
        return AACLibrary.entryDynamic((class_2561)name.get(), name);
    }

    private static class_3545<class_2561, Supplier<class_5250>> entryDynamic(class_2561 name, Supplier<class_5250> supplier) {
        return new class_3545((Object)name, supplier);
    }

    public static class PhraseSet {
        public final String setName;
        private final class_2561 displayName;
        private final List<class_3545<class_2561, Supplier<class_5250>>> phrases;

        public PhraseSet(String setNameIn, List<class_3545<class_2561, Supplier<class_5250>>> phrasesIn) {
            this(setNameIn, (class_2561)AACLibrary.translate("set_" + setNameIn), phrasesIn);
        }

        public PhraseSet(String setNameIn, class_2561 name, List<class_3545<class_2561, Supplier<class_5250>>> phrasesIn) {
            this.setName = setNameIn;
            this.displayName = name;
            this.phrases = phrasesIn;
            if (this.phrases.size() > 25) {
                Wheelchairs.LOGGER.warn("# AAC phrase set [{}] has more phrases than the AAC screen can display! {}", (Object)this.setName, (Object)this.phrases.size());
            }
        }

        public class_2561 displayName() {
            return this.displayName;
        }

        public int size() {
            return this.phrases.size();
        }

        public class_3545<class_2561, Supplier<class_5250>> get(int index) {
            return this.phrases.get(index);
        }
    }
}

