/*
 * Decompiled with CFR 0.152.
 */
package com.lying.config;

import com.lying.Wheelchairs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public abstract class Config {
    private String fileName;

    protected Config(String fileIn) {
        this.fileName = fileIn;
    }

    protected abstract Properties getDefaults();

    protected void readValues(Properties valuesIn) {
    }

    public void read() {
        Properties values = new Properties(this.getDefaults());
        try {
            FileReader reader = new FileReader(this.fileName);
            values.load(reader);
            reader.close();
        }
        catch (FileNotFoundException e) {
            Wheelchairs.LOGGER.error("Generated new config file " + this.fileName);
            this.save();
            return;
        }
        catch (IOException e) {
            Wheelchairs.LOGGER.error("Couldn't read config file " + this.fileName);
            e.printStackTrace();
        }
        this.readValues(values);
    }

    protected void writeValues(FileWriter writer) {
    }

    public void save() {
        try {
            File file = new File(this.fileName);
            boolean fileExists = file.exists();
            File directory = file.getParentFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            FileWriter writer = new FileWriter(file);
            this.writeValues(writer);
            writer.close();
            if (!fileExists) {
                Wheelchairs.LOGGER.info("Generated new config file " + this.fileName);
            }
        }
        catch (IOException e) {
            Wheelchairs.LOGGER.error("Couldn't read config file " + this.fileName);
            e.printStackTrace();
        }
    }

    protected static void writeBool(FileWriter writer, String name, boolean value) {
        try {
            writer.write(name + "=" + (value ? "true" : "false") + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static boolean parseBoolOr(String name, boolean val) {
        try {
            return name.equalsIgnoreCase("true");
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    protected static void writeInt(FileWriter writer, String name, int value) {
        try {
            writer.write(name + "=" + Integer.valueOf(value) + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static int parseIntOr(String name, int val) {
        try {
            return Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return val;
        }
    }

    protected static void writeString(FileWriter writer, String name, String value) {
        try {
            writer.write(name + "=" + value + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String parseStringOr(String name, String val) {
        try {
            return name;
        }
        catch (Exception e) {
            return val;
        }
    }
}

