/*
 * Decompiled with CFR 0.152.
 */
package com.lying.config;

import com.lying.config.Config;
import com.lying.data.WHCTags;
import com.lying.init.WHCEnchantmentComponentTypes;
import java.io.FileWriter;
import java.util.Properties;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_3542;
import net.minecraft.class_9331;

public class ServerConfig
extends Config {
    private static final Properties DEFAULT_SETTINGS = new Properties();
    private SwordCaneFilter swordCanes = SwordCaneFilter.ENCHANT;
    private boolean handsyWalkers = false;

    public ServerConfig(String fileIn) {
        super(fileIn);
    }

    @Override
    protected Properties getDefaults() {
        return DEFAULT_SETTINGS;
    }

    public SwordCaneFilter swordCaneFilter() {
        return this.swordCanes;
    }

    public boolean handsyWalkers() {
        return this.handsyWalkers;
    }

    @Override
    protected void readValues(Properties valuesIn) {
        this.swordCanes = SwordCaneFilter.get(ServerConfig.parseStringOr(valuesIn.getProperty("SwordCaneFilter"), null));
        this.handsyWalkers = ServerConfig.parseBoolOr(valuesIn.getProperty("HandsyWalkers"), false);
    }

    @Override
    protected void writeValues(FileWriter writer) {
        ServerConfig.writeString(writer, "SwordCaneFilter", this.swordCanes.method_15434());
        ServerConfig.writeBool(writer, "HandsyWalkers", this.handsyWalkers);
    }

    static {
        DEFAULT_SETTINGS.put("SwordCaneFilter", SwordCaneFilter.ENCHANT.method_15434());
        DEFAULT_SETTINGS.put("HandsyWalkers", "FALSE");
    }

    public static enum SwordCaneFilter implements class_3542
    {
        ENCHANT(stack -> class_1890.method_60142((class_1799)stack, (class_9331)((class_9331)WHCEnchantmentComponentTypes.CANE_STOREABLE.get()))),
        ALLOW_LIST(stack -> stack.method_31573(WHCTags.FILTER_SWORD_CANE)),
        DENY_LIST(stack -> !ALLOW_LIST.test((class_1799)stack));

        private final Predicate<class_1799> condition;

        private SwordCaneFilter(Predicate<class_1799> conditionIn) {
            this.condition = conditionIn;
        }

        public String method_15434() {
            return this.name().toLowerCase();
        }

        public final boolean test(class_1799 stack) {
            return !stack.method_7960() && this.condition.test(stack);
        }

        public static SwordCaneFilter get(String name) {
            if (name != null) {
                for (SwordCaneFilter value : SwordCaneFilter.values()) {
                    if (!value.method_15434().equalsIgnoreCase(name)) continue;
                    return value;
                }
            }
            return ENCHANT;
        }
    }
}

