/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.init.WHCSpecialRecipes;
import com.lying.item.WalkerItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class RecipeWalker
implements class_3955 {
    public static final class_2960 ID = Reference.ModInfo.prefix("walker");
    private final class_1799 result;
    private final class_1856 strut;
    private final class_1856 platform;
    private final class_1856 handle;
    private final class_1856 wheelLeft;
    private final class_1856 wheelRight;
    private final Map<Vector2i, class_1856> recipeGrid = new HashMap<Vector2i, class_1856>();
    private class_9887 placement = null;

    public RecipeWalker(class_1799 result, class_1856 strut, class_1856 platform, class_1856 handle, class_1856 wheelL, class_1856 wheelR) {
        this.result = result;
        this.strut = strut;
        this.platform = platform;
        this.handle = handle;
        this.wheelLeft = wheelL;
        this.wheelRight = wheelR;
        this.recipeGrid.put(new Vector2i(0, 0), handle);
        this.recipeGrid.put(new Vector2i(2, 0), handle);
        this.recipeGrid.put(new Vector2i(0, 1), strut);
        this.recipeGrid.put(new Vector2i(1, 1), platform);
        this.recipeGrid.put(new Vector2i(2, 1), strut);
        this.recipeGrid.put(new Vector2i(0, 2), wheelL);
        this.recipeGrid.put(new Vector2i(2, 2), wheelR);
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public class_9887 method_61671() {
        if (this.placement == null) {
            this.placement = class_9887.method_61683(List.of(Optional.of(this.handle), Optional.empty(), Optional.of(this.handle), Optional.of(this.strut), Optional.of(this.platform), Optional.of(this.strut), Optional.of(this.wheelLeft), Optional.empty(), Optional.of(this.wheelRight)));
        }
        return this.placement;
    }

    public boolean fits(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean matches(class_9694 inv, class_1937 var2) {
        for (int x = 0; x < inv.method_59991() - 2; ++x) {
            for (int y = 0; y < inv.method_59992() - 2; ++y) {
                if (!this.checkFrom(inv, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public class_1799 getResult(class_5455 var2) {
        return this.result.method_7972();
    }

    public class_1799 craft(class_9694 inv, class_7225.class_7874 registries) {
        for (int x = 0; x < inv.method_59991() - 2; ++x) {
            for (int y = 0; y < inv.method_59992() - 2; ++y) {
                class_2371<class_1799> components;
                if (!this.checkFrom(inv, x, y) || (components = this.getDataComps(inv, x, y)) == null) continue;
                class_1799 walker = this.result.method_7972();
                WalkerItem.setWheels(walker, (class_1799)components.get(0), (class_1799)components.get(1));
                return walker;
            }
        }
        return class_1799.field_8037;
    }

    private boolean checkFrom(class_9694 inv, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                class_1799 stackInSlot = inv.method_59984(this.coordsToIndex(i + x, j + y, inv.method_59991()));
                Vector2i gridSlot = new Vector2i(i, j);
                if (!(this.recipeGrid.containsKey(gridSlot) ? !this.recipeGrid.get(gridSlot).method_8093(stackInSlot) : !stackInSlot.method_7960())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private class_2371<class_1799> getDataComps(class_9694 inv, int x, int y) {
        class_2371 wheels = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        int leftWheelSlot = this.coordsToIndex(0 + x, 2 + y, inv.method_59991());
        int rightWheelSlot = this.coordsToIndex(2 + x, 2 + y, inv.method_59991());
        if (inv.method_59984(leftWheelSlot).method_7960() || !this.wheelLeft.method_8093(inv.method_59984(leftWheelSlot))) {
            return null;
        }
        wheels.set(0, (Object)inv.method_59984(leftWheelSlot));
        if (inv.method_59984(rightWheelSlot).method_7960() || !this.wheelLeft.method_8093(inv.method_59984(rightWheelSlot))) {
            return null;
        }
        wheels.set(1, (Object)inv.method_59984(rightWheelSlot));
        return wheels;
    }

    private int coordsToIndex(int x, int y, int width) {
        return x + y * width;
    }

    public class_1865<? extends class_3955> method_8119() {
        return (class_1865)WHCSpecialRecipes.WALKER_SERIALIZER.get();
    }

    public static class Serializer
    implements class_1865<RecipeWalker> {
        private static final MapCodec<RecipeWalker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.fieldOf("result").forGetter(r -> r.result), (App)class_1856.field_46095.fieldOf("strut").forGetter(r -> r.strut), (App)class_1856.field_46095.fieldOf("platform").forGetter(r -> r.platform), (App)class_1856.field_46095.fieldOf("handle").forGetter(r -> r.handle), (App)class_1856.field_46095.fieldOf("left_wheel").forGetter(r -> r.wheelLeft), (App)class_1856.field_46095.fieldOf("right_wheel").forGetter(r -> r.wheelRight)).apply((Applicative)instance, RecipeWalker::new));
        private static final class_9139<class_9129, RecipeWalker> PACKET_CODEC = class_9139.method_56438((r, buf) -> {
            class_1799.field_48349.encode(buf, (Object)r.result);
            class_1856.field_48355.encode(buf, (Object)r.strut);
            class_1856.field_48355.encode(buf, (Object)r.platform);
            class_1856.field_48355.encode(buf, (Object)r.handle);
            class_1856.field_48355.encode(buf, (Object)r.wheelLeft);
            class_1856.field_48355.encode(buf, (Object)r.wheelRight);
        }, buf -> new RecipeWalker((class_1799)class_1799.field_48349.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (class_1856)class_1856.field_48355.decode(buf)));

        public MapCodec<RecipeWalker> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, RecipeWalker> method_56104() {
            return PACKET_CODEC;
        }
    }
}

