/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.init.WHCSpecialRecipes;
import com.lying.item.WheelchairItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1747;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import net.minecraft.class_9887;
import org.jetbrains.annotations.Nullable;

public class RecipeWheelchair
implements class_3955 {
    public static final class_2960 ID = Reference.ModInfo.prefix("wheelchair");
    private final class_1799 result;
    private final class_1856 backing;
    private final class_1856 cushion;
    private final class_1856 wheelLeft;
    private final class_1856 wheelRight;
    private class_9887 placement = null;

    public RecipeWheelchair(class_1799 result, class_1856 backing, class_1856 cushion, Optional<class_1856> wheelL, Optional<class_1856> wheelR) {
        this.result = result;
        this.backing = backing;
        this.cushion = cushion;
        this.wheelLeft = wheelL.get();
        this.wheelRight = wheelR.get();
    }

    public RecipeWheelchair(class_1799 result, class_1856 backing, class_1856 cushion, class_1856 wheelL, class_1856 wheelR) {
        this.result = result;
        this.backing = backing;
        this.cushion = cushion;
        this.wheelLeft = wheelL;
        this.wheelRight = wheelR;
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public class_9887 method_61671() {
        if (this.placement == null) {
            this.placement = class_9887.method_61683(List.of(Optional.empty(), Optional.of(this.backing), Optional.empty(), Optional.of(this.wheelLeft), Optional.of(this.cushion), Optional.of(this.wheelRight)));
        }
        return this.placement;
    }

    public boolean fits(int width, int height) {
        return width >= 3 && height >= 2;
    }

    public boolean matches(class_9694 inv, class_1937 var2) {
        for (int x = 0; x < inv.method_59991() - 2; ++x) {
            for (int y = 0; y < inv.method_59992() - 1; ++y) {
                if (this.checkFrom(inv, x, y) == null) continue;
                return true;
            }
        }
        return false;
    }

    public class_1799 getResult(class_5455 var2) {
        return this.result.method_7972();
    }

    public class_1799 craft(class_9694 inv, class_7225.class_7874 var2) {
        for (int x = 0; x < inv.method_59991() - 2; ++x) {
            for (int y = 0; y < inv.method_59992() - 1; ++y) {
                class_2371<class_1799> contents = this.checkFrom(inv, x, y);
                if (contents == null) continue;
                class_1799 chair = this.result.method_7972();
                WheelchairItem.setWheels(chair, (class_1799)contents.get(2), (class_1799)contents.get(3));
                class_1799 dye = (class_1799)contents.get(1);
                int colour = 0xF9FFFE;
                if (dye.method_7909() instanceof class_1747) {
                    colour = ((class_1747)dye.method_7909()).method_7711().method_26403().field_16011;
                } else if (dye.method_7909() instanceof class_1769) {
                    colour = ((class_1769)dye.method_7909()).method_7802().method_7794().field_16011;
                } else if (dye.method_57826(class_9334.field_49644)) {
                    colour = ((class_9282)dye.method_57824(class_9334.field_49644)).comp_2384();
                }
                chair.method_57379(class_9334.field_49644, (Object)new class_9282(colour, true));
                return chair;
            }
        }
        return class_1799.field_8037;
    }

    @Nullable
    private class_2371<class_1799> checkFrom(class_9694 inv, int x, int y) {
        class_2371 entries = class_2371.method_10213((int)4, (Object)class_1799.field_8037);
        int emptyA = this.coordsToIndex(x, y, inv.method_59991());
        int emptyB = this.coordsToIndex(x + 2, y, inv.method_59991());
        if (!inv.method_59984(emptyA).method_7960() || !inv.method_59984(emptyB).method_7960()) {
            return null;
        }
        int backing = this.coordsToIndex(x + 1, y, inv.method_59991());
        if (!this.backing.method_8093(inv.method_59984(backing))) {
            return null;
        }
        entries.set(0, (Object)inv.method_59984(backing));
        int cushion = this.coordsToIndex(x + 1, y + 1, inv.method_59991());
        if (!this.cushion.method_8093(inv.method_59984(cushion))) {
            return null;
        }
        entries.set(1, (Object)inv.method_59984(cushion));
        int leftWheel = this.coordsToIndex(x, y + 1, inv.method_59991());
        if (!this.wheelLeft.method_8093(inv.method_59984(leftWheel))) {
            return null;
        }
        entries.set(2, (Object)inv.method_59984(leftWheel));
        int rightWheel = this.coordsToIndex(x + 2, y + 1, inv.method_59991());
        if (!this.wheelRight.method_8093(inv.method_59984(rightWheel))) {
            return null;
        }
        entries.set(3, (Object)inv.method_59984(rightWheel));
        List<Integer> usedIndices = List.of(Integer.valueOf(emptyA), Integer.valueOf(backing), Integer.valueOf(emptyB), Integer.valueOf(leftWheel), Integer.valueOf(cushion), Integer.valueOf(rightWheel));
        for (int i = 0; i < inv.method_59983(); ++i) {
            if (usedIndices.contains(i) || inv.method_59984(i).method_7960()) continue;
            return null;
        }
        return entries.stream().anyMatch(class_1799::method_7960) ? null : entries;
    }

    private int coordsToIndex(int x, int y, int width) {
        return x + y * width;
    }

    public class_1865<? extends class_3955> method_8119() {
        return (class_1865)WHCSpecialRecipes.WHEELCHAIR_SERIALIZER.get();
    }

    public static int componentsToColor(float[] comp) {
        int r = (int)(comp[0] * 255.0f);
        int g = (int)(comp[1] * 255.0f);
        int b = (int)(comp[2] * 255.0f);
        int col = r;
        col = (col << 8) + g;
        col = (col << 8) + b;
        return col;
    }

    public static class Serializer
    implements class_1865<RecipeWheelchair> {
        private static final MapCodec<RecipeWheelchair> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1799.field_24671.fieldOf("result").forGetter(r -> r.result), (App)class_1856.field_46095.fieldOf("backing").forGetter(r -> r.backing), (App)class_1856.field_46095.fieldOf("cushion").forGetter(r -> r.cushion), (App)class_1856.field_46095.optionalFieldOf("left_wheel").forGetter(r -> Optional.of(r.wheelLeft)), (App)class_1856.field_46095.optionalFieldOf("right_wheel").forGetter(r -> Optional.of(r.wheelRight))).apply((Applicative)instance, RecipeWheelchair::new));
        public static final class_9139<class_9129, RecipeWheelchair> PACKET_CODEC = class_9139.method_56438((r, buf) -> {
            class_1799.field_48349.encode(buf, (Object)r.result);
            class_1856.field_48355.encode(buf, (Object)r.backing);
            class_1856.field_48355.encode(buf, (Object)r.cushion);
            class_1856.field_52595.encode(buf, Optional.of(r.wheelLeft));
            class_1856.field_52595.encode(buf, Optional.of(r.wheelRight));
        }, buf -> new RecipeWheelchair((class_1799)class_1799.field_48349.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (class_1856)class_1856.field_48355.decode(buf), (Optional)class_1856.field_52595.decode(buf), (Optional)class_1856.field_52595.decode(buf)));

        public MapCodec<RecipeWheelchair> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, RecipeWheelchair> method_56104() {
            return PACKET_CODEC;
        }
    }
}

