/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lying.Wheelchairs;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.reference.Reference;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.function.Consumers;
import org.slf4j.Logger;

public class ChairUpgrade {
    public static final Codec<ChairUpgrade> CODEC = Codec.of(ChairUpgrade::encodeToOps, ChairUpgrade::decodeFromOps);
    public static final class_9139<class_9129, ChairUpgrade> PACKET_CODEC = class_9139.method_56434((class_9139)class_2960.field_48267, ChairUpgrade::registryName, WHCChairUpgrades::get);
    private final class_2960 name;
    private final Predicate<class_1799> isKeyItem;
    private final class_1792 dropItem;
    private final boolean hasModel;
    private final boolean enablesScreen;
    private final Consumer<WheelchairEntity> onApplied;
    private final Consumer<WheelchairEntity> onRemoved;
    private final Map<class_6880<class_1320>, class_1322> attributeModifiers = Maps.newHashMap();
    private final Predicate<WheelchairEntity> isValid;
    private final Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith;

    private static <T> DataResult<T> encodeToOps(ChairUpgrade upg, DynamicOps<T> ops, T prefix) {
        return DataResult.success((Object)ops.createString(upg.registryName().toString()));
    }

    private static <T> DataResult<Pair<ChairUpgrade, T>> decodeFromOps(DynamicOps<T> ops, T input) {
        ChairUpgrade condition = WHCChairUpgrades.get(class_2960.method_60654((String)((String)ops.getStringValue(input).getOrThrow())));
        return condition == null ? DataResult.error(() -> "Error reading wheelchair upgrade from data") : DataResult.success((Object)Pair.of((Object)condition, input));
    }

    protected ChairUpgrade(class_2960 nameIn, boolean modelled, boolean screenEnabler, Predicate<class_1799> keyItem, class_1792 dropItem, Predicate<WheelchairEntity> valid, Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith, Consumer<WheelchairEntity> applied, Consumer<WheelchairEntity> removed, Map<class_6880<class_1320>, class_1322> modifiers) {
        this.name = nameIn;
        this.hasModel = modelled;
        this.enablesScreen = screenEnabler;
        this.isKeyItem = keyItem;
        this.dropItem = dropItem;
        this.isValid = valid;
        this.incompatibleWith = incompatibleWith;
        this.onApplied = applied;
        this.onRemoved = removed;
        modifiers.entrySet().forEach(entry -> this.attributeModifiers.put((class_6880<class_1320>)((class_6880)entry.getKey()), (class_1322)entry.getValue()));
    }

    public final class_2960 registryName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof ChairUpgrade && ((ChairUpgrade)obj).registryName().equals((Object)this.name);
    }

    public <T> T encode(DynamicOps<T> ops) {
        return CODEC.encodeStart(ops, (Object)this).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> ChairUpgrade decode(DynamicOps<T> ops, T input) {
        return (ChairUpgrade)CODEC.parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> T encodeList(DynamicOps<T> ops, List<ChairUpgrade> list) {
        return CODEC.listOf().encodeStart(ops, list).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> List<ChairUpgrade> decodeList(DynamicOps<T> ops, T input) {
        return (List)CODEC.listOf().parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public class_2561 translate() {
        return class_2561.method_43471((String)("upgrade." + this.name.method_12836() + "." + this.name.method_12832()));
    }

    public class_1792 dropItem() {
        return this.dropItem;
    }

    public boolean matches(class_1799 stack) {
        return this.isKeyItem.apply((Object)stack);
    }

    public boolean canApplyTo(WheelchairEntity chair) {
        return !chair.hasUpgrade(this) && this.isValid.apply((Object)chair);
    }

    public final boolean compatibleWith(ChairUpgrade upgrade) {
        return this.incompatibleWith.get().isEmpty() ? true : this.incompatibleWith.get().stream().noneMatch(upg -> upg == upgrade);
    }

    public static boolean canCombineWith(ChairUpgrade upgradeA, ChairUpgrade upgradeB) {
        return upgradeA.compatibleWith(upgradeB) && upgradeB.compatibleWith(upgradeA);
    }

    public void applyTo(WheelchairEntity chair) {
        this.onApplied.accept(chair);
    }

    public void removeFrom(WheelchairEntity chair) {
        this.onRemoved.accept(chair);
    }

    public void onStartRiding(class_1309 rider) {
        if (!this.attributeModifiers.isEmpty()) {
            this.attributeModifiers.entrySet().forEach(entry -> {
                class_1324 instance = rider.method_6127().method_45329((class_6880)entry.getKey());
                if (instance == null || instance.method_6196(((class_1322)entry.getValue()).comp_2447())) {
                    return;
                }
                instance.method_26835((class_1322)entry.getValue());
            });
        }
    }

    public void onStopRiding(class_1309 rider) {
        if (!this.attributeModifiers.isEmpty()) {
            this.attributeModifiers.entrySet().forEach(entry -> {
                class_1324 instance = rider.method_6127().method_45329((class_6880)entry.getKey());
                if (instance != null) {
                    instance.method_6202((class_1322)entry.getValue());
                }
            });
        }
    }

    public boolean hasModel() {
        return this.hasModel;
    }

    public boolean enablesScreen() {
        return this.enablesScreen;
    }

    public static class Builder {
        private final class_2960 name;
        private Predicate<class_1799> isKeyItem = Predicates.alwaysFalse();
        private class_1792 dropItem = class_1802.field_8600;
        private Predicate<WheelchairEntity> isValid = Predicates.alwaysTrue();
        private Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith = () -> Lists.newArrayList();
        private boolean hasModel = false;
        private Consumer<WheelchairEntity> onApplied = Consumers.nop();
        private Consumer<WheelchairEntity> onRemoved = Consumers.nop();
        private final Map<class_6880<class_1320>, class_1322> attributeModifiers = new HashMap<class_6880<class_1320>, class_1322>();
        private boolean enablesScreen = false;

        protected Builder(class_2960 nameIn) {
            this.name = nameIn;
        }

        public static Builder of(String nameIn) {
            return new Builder(Reference.ModInfo.prefix(nameIn));
        }

        public final Builder keyItem(class_1792 itemIn) {
            this.dropItem = itemIn;
            this.keyItem((Predicate<class_1799>)((Predicate)stack -> stack.method_7909() == itemIn));
            return this;
        }

        public final Builder keyItem(Predicate<class_1799> itemIn) {
            this.isKeyItem = itemIn;
            return this;
        }

        public final Builder dropItem(class_1792 itemIn) {
            this.dropItem = itemIn;
            return this;
        }

        public final Builder isValid(Predicate<WheelchairEntity> validIn) {
            this.isValid = validIn;
            return this;
        }

        public final Builder incompatible(Supplier<List<Supplier<ChairUpgrade>>> upgrades) {
            this.incompatibleWith = upgrades;
            return this;
        }

        public final Builder applied(Consumer<WheelchairEntity> func) {
            this.onApplied = func;
            return this;
        }

        public final Builder removed(Consumer<WheelchairEntity> func) {
            this.onRemoved = func;
            return this;
        }

        public final Builder attribute(class_6880<class_1320> attribute, String uuid, double amount, class_1322.class_1323 operation) {
            this.attributeModifiers.put(attribute, new class_1322(this.name, amount, operation));
            return this;
        }

        public final Builder modelled() {
            this.hasModel = true;
            return this;
        }

        public final Builder enablesScreen() {
            this.enablesScreen = true;
            return this;
        }

        public ChairUpgrade build() {
            return new ChairUpgrade(this.name, this.hasModel, this.enablesScreen, this.isKeyItem, this.dropItem, this.isValid, this.incompatibleWith, this.onApplied, this.onRemoved, this.attributeModifiers);
        }
    }
}

