/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.init.WHCSoundEvents;
import com.lying.utility.ServerEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IParentedEntity {
    public static final double SEARCH_RANGE = 8.0;

    public static Predicate<class_1297> isChildOf(class_1309 entity) {
        return ent -> ent.method_5805() && ent instanceof IParentedEntity && ((IParentedEntity)ent).isParent((class_1297)entity);
    }

    public boolean hasParent();

    public boolean isParent(class_1297 var1);

    @Nullable
    public class_1309 getParent();

    public void parentTo(@Nullable class_1309 var1);

    default public void clearParent() {
        this.parentTo(null);
    }

    default public class_243 getParentOffset(class_1309 parent, float yaw, float pitch) {
        return class_243.field_1353;
    }

    default public void tickParented(@NotNull class_1309 parent, float yaw, float pitch) {
    }

    @Nullable
    default public <T extends class_1309> class_1309 tryGetParent() {
        return this instanceof class_1309 ? IParentedEntity.getParentOf((class_1309)this) : null;
    }

    @Nullable
    public static <T extends class_1309> class_1309 getParentOf(T entity) {
        Optional bestGuess = entity.method_37908().method_8390(class_1309.class, entity.method_5829().method_1014(8.0), ent -> ent.method_5805() && ((IParentedEntity)entity).isParent((class_1297)ent)).stream().findFirst();
        return bestGuess.orElseGet(() -> null);
    }

    public static <T extends class_1309> List<T> getParentedEntitiesOf(class_1309 ent) {
        ArrayList list = Lists.newArrayList();
        for (class_1309 living : ent.method_37908().method_8390(class_1309.class, ent.method_5829().method_1014(8.0), wal -> wal instanceof IParentedEntity && ((IParentedEntity)wal).isParent((class_1297)ent))) {
            list.add(living);
        }
        return list;
    }

    public static boolean hasParentedEntities(class_1309 ent) {
        return IParentedEntity.getParentedEntitiesOf(ent).isEmpty();
    }

    public static class_243 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    default public <T extends class_1309> boolean canParentToChild(class_1309 parent, T child) {
        return !parent.method_5765() && (double)parent.method_5739(child) < 5.0 && (!Wheelchairs.config.handsyWalkers() || child.method_6047().method_7960() || child.method_6079().method_7960());
    }

    public static <T extends class_1309> void updateParentingBond(T child, class_1309 parent, class_1297.class_4738 positionUpdater) {
        if (child == null || parent == null || parent == child || !((IParentedEntity)child).isParent((class_1297)parent)) {
            return;
        }
        child.method_18799(class_243.field_1353);
        child.method_5773();
        float yaw = parent.field_6283;
        float pitch = parent.method_36455();
        ((IParentedEntity)child).tickParented(parent, yaw, pitch);
        if (!((IParentedEntity)child).hasParent()) {
            return;
        }
        class_243 dest = parent.method_19538().method_1019(((IParentedEntity)child).getParentOffset(parent, yaw, pitch));
        positionUpdater.accept(child, dest.field_1352, dest.field_1351, dest.field_1350);
    }

    public static class_243 rotateOffset(class_243 offset, float parentYaw) {
        return offset.method_1024(-parentYaw * ((float)Math.PI / 180));
    }

    public static <T extends class_1309> boolean bindToPlayer(class_1657 player, T walker) {
        if (walker.method_37908().method_8608()) {
            return false;
        }
        if (((IParentedEntity)walker).isParent((class_1297)player)) {
            ((IParentedEntity)walker).parentTo(null);
            walker.method_5783((class_3414)WHCSoundEvents.SEATBELT_OFF.get(), 1.0f, 1.0f);
            return true;
        }
        if ((!((IParentedEntity)walker).hasParent() || player.method_7337()) && ((IParentedEntity)walker).canParentToChild((class_1309)player, walker)) {
            ((IParentedEntity)walker).parentTo((class_1309)player);
            walker.method_5783((class_3414)WHCSoundEvents.SEATBELT_ON.get(), 1.0f, 1.0f);
            ((ServerEvents.WalkerBindEvent)ServerEvents.ON_ENTITY_PARENT.invoker()).onParentToEntity((class_1309)player, walker);
            return true;
        }
        return false;
    }

    public static void clearParentedEntities(class_1309 parent, @Nullable class_1309 ignore) {
        parent.method_37908().method_8390(class_1309.class, parent.method_5829().method_1014(8.0), IParentedEntity.isChildOf(parent).and(entity -> entity != ignore)).forEach(ent -> ((IParentedEntity)ent).clearParent());
    }
}

