/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.lying.entity.WheelchairsRideable;
import com.lying.init.WHCItems;
import com.lying.utility.WHCUtils;
import java.util.OptionalInt;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_6026;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class StoolEntity
extends WheelchairsRideable
implements class_6026 {
    public static final int DEFAULT_COLOR = 0x1D1D21;
    public static final class_2940<OptionalInt> COLOR = class_2945.method_12791(StoolEntity.class, (class_2941)class_2943.field_17910);
    public float spin = 0.0f;
    private Vector2d prevCaster;
    private Vector2d caster;

    public StoolEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        double randX = (this.method_59922().method_43058() - 0.5) * 2.0;
        double randY = (this.method_59922().method_43058() - 0.5) * 2.0;
        this.prevCaster = this.caster = new Vector2d(randX, randY);
    }

    public void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, (Object)OptionalInt.empty());
    }

    public static class_5132.class_5133 createStoolAttributes() {
        return StoolEntity.createMountAttributes().method_26868(class_5134.field_47761, (double)0.6f);
    }

    public void method_5749(class_2487 data) {
        super.method_5749(data);
        if (data.method_10573("Color", 3)) {
            this.method_5841().method_12778(COLOR, (Object)OptionalInt.of(data.method_10550("Color")));
        }
    }

    public void method_5652(class_2487 data) {
        super.method_5652(data);
        if (this.hasColor()) {
            data.method_10569("Color", this.getColor());
        }
    }

    @Override
    public <T extends WheelchairsRideable> class_1799 entityToItem(T chair) {
        StoolEntity stool = (StoolEntity)chair;
        class_1799 stack = ((class_1792)WHCItems.STOOL.get()).method_7854().method_7972();
        if (stool.hasColor() && stack.method_57826(class_9334.field_49644)) {
            stack.method_57379(class_9334.field_49644, (Object)new class_9282(stool.getColor(), true));
        }
        return stack;
    }

    @Override
    public void copyFromItem(class_1799 stack) {
        this.method_5841().method_12778(COLOR, (Object)(stack.method_57826(class_9334.field_49644) ? OptionalInt.of(class_9282.method_57470((class_1799)stack, (int)-1)) : OptionalInt.empty()));
    }

    public class_1309 method_5642() {
        return this.method_31483() instanceof class_1309 ? (class_1309)this.method_31483() : null;
    }

    protected float method_49485(class_1657 controllingPlayer) {
        return (float)controllingPlayer.method_45325(class_5134.field_23719);
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        return new class_243((double)controllingPlayer.field_6212, 0.0, (double)controllingPlayer.field_6250);
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        return new class_243(0.0, (double)(dimensions.comp_2186() * 0.85f * scaleFactor), 0.0);
    }

    @Override
    protected void clampPassengerYaw(class_1297 passenger) {
        passenger.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        passenger.field_5982 += g - f;
        passenger.method_36456(passenger.method_36454() + g - f);
        passenger.method_5847(passenger.method_36454());
    }

    public boolean hasColor() {
        return ((OptionalInt)this.method_5841().method_12789(COLOR)).isPresent();
    }

    public int getColor() {
        return this.hasColor() ? ((OptionalInt)this.method_5841().method_12789(COLOR)).getAsInt() : 0x1D1D21;
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    }

    public boolean canEquip(class_1799 stack) {
        return false;
    }

    public void method_5673(class_1304 var1, class_1799 var2) {
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    @Override
    public float getActualStepHeight() {
        return 0.6f;
    }

    @Override
    protected void orientToRider(class_1309 controllingPlayer, class_243 movementInput) {
        if (movementInput.method_1033() > 0.0) {
            class_241 orientation = this.getControlledRotation(controllingPlayer);
            this.method_5710(orientation.field_1342, orientation.field_1343);
        } else {
            this.method_5710(controllingPlayer.field_6283, 0.0f);
        }
        this.field_5982 = this.field_6241;
        this.field_6283 = this.field_6241 = this.method_36454();
    }

    public void method_6091(class_243 movementInput) {
        super.method_6091(movementInput);
        Vector2d lateral = new Vector2d(movementInput.field_1352, movementInput.field_1350);
        if (lateral.length() == 0.0) {
            return;
        }
        double speed = WHCUtils.calculateSpin((float)(movementInput.method_1033() * (double)this.method_6029()), 0.3125f);
        this.spin = WHCUtils.wrapDegrees(this.spin + (float)speed);
        class_243 global = WHCUtils.localToGlobal(movementInput, this.method_36454());
        lateral = new Vector2d(global.field_1352, global.field_1350).mul(0.5);
        this.caster.get(this.prevCaster);
        this.caster.add((Vector2dc)lateral).normalize();
    }

    public float casterWheelYaw(float tickDelta) {
        Vector2d origin = this.prevCaster.get(new Vector2d());
        Vector2d current = this.caster.get(new Vector2d());
        origin.add((Vector2dc)current.sub((Vector2dc)origin).mul((double)tickDelta));
        return (float)Math.toDegrees(Math.atan2(origin.y, origin.x));
    }
}

