/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.lying.component.type.WheelComponent;
import com.lying.entity.IParentedEntity;
import com.lying.init.WHCItems;
import com.lying.item.WalkerItem;
import com.lying.utility.WHCUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import net.minecraft.class_8109;
import net.minecraft.class_9288;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class WalkerEntity
extends class_1309
implements IParentedEntity {
    private static final class_2940<class_1799> ITEM = class_2945.method_12791(WalkerEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<class_1799> LEFT_WHEEL = class_2945.method_12791(WalkerEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<class_1799> RIGHT_WHEEL = class_2945.method_12791(WalkerEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Optional<UUID>> USER_ID = class_2945.method_12791(WalkerEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> HAS_INV = class_2945.method_12791(WalkerEntity.class, (class_2941)class_2943.field_13323);
    private class_1309 user = null;
    private Vector2d prevCaster;
    private Vector2d caster;
    public float spinLeft = 0.0f;
    public float spinRight = 0.0f;
    protected class_1277 items;

    public WalkerEntity(class_1299<? extends WalkerEntity> entityType, class_1937 world) {
        super(entityType, world);
        double randX = (this.method_59922().method_43058() - 0.5) * 2.0;
        double randY = (this.method_59922().method_43058() - 0.5) * 2.0;
        this.prevCaster = this.caster = new Vector2d(randX, randY);
    }

    public void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ITEM, (Object)((class_1792)WHCItems.WALKER_OAK.get()).method_7854());
        builder.method_56912(LEFT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.method_56912(RIGHT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.method_56912(USER_ID, Optional.empty());
        builder.method_56912(HAS_INV, (Object)false);
    }

    public static class_5132.class_5133 createWalkerAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_47761, 0.5);
    }

    public void method_5749(class_2487 data) {
        super.method_5749(data);
        if (data.method_10573("Item", 10)) {
            this.method_5841().method_12778(ITEM, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)data.method_10562("Item")).get()));
        } else if (data.method_10573("Chair", 10)) {
            this.method_5841().method_12778(ITEM, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)data.method_10562("Chair")).get()));
        }
        if (data.method_10573("Wheels", 10)) {
            class_2487 wheels = data.method_10562("Wheels");
            this.method_5841().method_12778(LEFT_WHEEL, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)wheels.method_10562("Left")).get()));
            this.method_5841().method_12778(RIGHT_WHEEL, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)wheels.method_10562("Right")).get()));
        }
        this.setHasInventory(data.method_10577("Chested"));
        if (data.method_10573("Items", 9)) {
            class_2499 items = data.method_10554("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                class_2487 nbt = items.method_10602(i);
                int j = nbt.method_10571("Slot") & 0xFF;
                if (j >= this.items.method_5439()) continue;
                this.items.method_5447(j, (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt).get());
            }
        }
    }

    public void method_5652(class_2487 data) {
        super.method_5652(data);
        data.method_10566("Item", ((class_1799)this.method_5841().method_12789(ITEM)).method_57358((class_7225.class_7874)this.method_56673()));
        class_2487 wheels = new class_2487();
        wheels.method_10566("Left", this.getLeftWheel().method_57358((class_7225.class_7874)this.method_56673()));
        wheels.method_10566("Right", this.getRightWheel().method_57358((class_7225.class_7874)this.method_56673()));
        data.method_10566("Wheels", (class_2520)wheels);
        data.method_10556("Chested", this.hasInventory());
        if (this.hasInventory()) {
            class_2499 items = new class_2499();
            for (int i = 0; i < this.items.method_5439(); ++i) {
                class_1799 stack = this.items.method_5438(i);
                if (stack.method_7960()) continue;
                class_2487 nbt = (class_2487)stack.method_57358((class_7225.class_7874)this.method_56673());
                nbt.method_10567("Slot", (byte)i);
                items.add((Object)nbt);
            }
            data.method_10566("Items", (class_2520)items);
        }
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        boolean shouldRespond = !this.hasParent() || this.isParent((class_1297)player);
        boolean isServer = !this.method_37908().method_8608();
        class_1799 heldStack = player.method_5998(hand);
        if (player.method_21823()) {
            boolean hasInv = this.hasInventory();
            if (!hasInv && (heldStack.method_31574(class_1802.field_8106) || heldStack.method_31574(class_1802.field_8247))) {
                this.addInventory();
                if (!player.method_31549().field_7477) {
                    heldStack.method_7934(1);
                }
            } else if (hasInv && heldStack.method_31573(class_3489.field_42612)) {
                if (isServer) {
                    this.method_5706((class_3218)this.method_37908(), (class_1935)class_1802.field_8106);
                }
                this.setHasInventory(false);
                if (!player.method_7337()) {
                    heldStack.method_61653(1, player);
                }
                this.method_5783(class_3417.field_14675, this.method_6107(), this.method_6017());
            } else if (shouldRespond) {
                this.convertToItem(null);
            }
            return class_1269.field_21466;
        }
        if (!this.method_37908().method_8608()) {
            return shouldRespond && IParentedEntity.bindToPlayer(player, this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    public static class_1799 chairToItem(WalkerEntity chair) {
        class_1799 stack = chair.getFrame();
        WalkerItem.setWheels(stack, chair.getLeftWheel(), chair.getRightWheel());
        WalkerItem.setHasChest(stack, chair.hasInventory());
        return stack;
    }

    public void copyFromItem(class_1799 stack) {
        this.method_5841().method_12778(ITEM, (Object)stack.method_7972());
        this.method_5841().method_12778(LEFT_WHEEL, (Object)WalkerItem.getWheel(stack, class_1306.field_6182));
        this.method_5841().method_12778(RIGHT_WHEEL, (Object)WalkerItem.getWheel(stack, class_1306.field_6183));
        if (WalkerItem.hasChest(stack)) {
            this.setHasInventory(true);
            List storedItems = ((class_9288)stack.method_57824(class_9334.field_49622)).method_57489().toList();
            for (int i = 0; i < storedItems.size(); ++i) {
                this.items.method_5447(i, (class_1799)storedItems.get(i));
            }
        }
    }

    @Override
    @Nullable
    public class_1309 getParent() {
        if (!this.hasParent()) {
            return null;
        }
        return this.user == null ? (this.user = IParentedEntity.getParentOf(this)) : this.user;
    }

    public void convertToItem(@Nullable class_1657 player) {
        if (!this.method_37908().method_8608()) {
            class_1799 stack = WalkerEntity.chairToItem(this);
            class_1542 item = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
            this.method_16078((class_3218)this.method_37908());
            if (player == null || !player.method_31548().method_7394(stack)) {
                this.method_37908().method_8649((class_1297)item);
            }
            this.method_31472();
        }
    }

    public void method_6087(class_1297 entity) {
        if (!this.isParent(entity)) {
            super.method_6087(entity);
        }
    }

    public void method_5697(class_1297 entity) {
        if (!this.isParent(entity)) {
            super.method_5697(entity);
        }
    }

    public boolean method_5679(class_3218 world, class_1282 damageSource) {
        class_8109 sources = world.method_48963();
        return damageSource != sources.method_48829() && damageSource != sources.method_51847();
    }

    public boolean method_6049(class_1293 effect) {
        return false;
    }

    public int method_5669() {
        return 20;
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    }

    public boolean canEquip(class_1799 stack) {
        return false;
    }

    public class_1799 method_6118(class_1304 slot) {
        return slot == class_1304.field_6166 ? WalkerEntity.getEnchantments(this.getFrame()) : class_1799.field_8037;
    }

    public static class_1799 getEnchantments(class_1799 chair) {
        class_1799 spoof = class_1802.field_20391.method_7854();
        spoof.method_57379(class_9334.field_49633, (Object)((class_9304)chair.method_57824(class_9334.field_49633)));
        return spoof;
    }

    public void method_5673(class_1304 var1, class_1799 var2) {
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public class_1799 getFrame() {
        class_1799 stack = (class_1799)this.method_5841().method_12789(ITEM);
        return stack.method_7909() instanceof WalkerItem ? stack : new class_1799(WHCItems.WHEELCHAIR_OAK);
    }

    public class_1799 getWheel(class_1306 arm) {
        return arm == class_1306.field_6182 ? this.getLeftWheel() : this.getRightWheel();
    }

    protected class_1799 getWheel(class_1799 actualWheel) {
        class_1799 wheel = actualWheel.method_7909().method_7854().method_7972();
        wheel.method_57379(class_9334.field_49633, (Object)((class_9304)this.getFrame().method_57824(class_9334.field_49633)));
        return wheel;
    }

    public class_1799 getLeftWheel() {
        return this.getWheel((class_1799)this.method_5841().method_12789(LEFT_WHEEL));
    }

    public class_1799 getRightWheel() {
        return this.getWheel((class_1799)this.method_5841().method_12789(RIGHT_WHEEL));
    }

    @Override
    public boolean hasParent() {
        return ((Optional)this.method_5841().method_12789(USER_ID)).isPresent();
    }

    @Override
    public boolean isParent(class_1297 entity) {
        return this.hasParent() && entity.method_5667().equals(((Optional)this.method_5841().method_12789(USER_ID)).get());
    }

    @Override
    public void parentTo(@Nullable class_1309 entity) {
        if (this.method_37908().method_8608()) {
            return;
        }
        this.method_5841().method_12778(USER_ID, entity == null ? Optional.empty() : Optional.of(entity.method_5667()));
    }

    @Override
    public class_243 getParentOffset(class_1309 parent, float yaw, float pitch) {
        return IParentedEntity.rotateOffset(new class_243(0.0, 0.0, 0.5), yaw);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.serverTick();
        }
    }

    private void serverTick() {
        if (this.hasParent() && this.getParent() == null) {
            this.clearParent();
        }
    }

    @Override
    public void tickParented(@NotNull class_1309 parent, float yaw, float pitch) {
        this.field_5982 = yaw;
        this.field_6283 = yaw;
        this.field_6004 = 0.0f;
        this.method_36457(0.0f);
        if (!this.canParentToChild(parent, this)) {
            this.clearParent();
        }
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
        super.method_5784(movementType, movement);
        Vector2d delta = new Vector2d(movement.field_1352, movement.field_1350);
        if (delta.length() == 0.0 || !this.method_37908().method_8608()) {
            return;
        }
        float spin = WHCUtils.calculateSpin((float)delta.length(), 0.3125f);
        this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + spin);
        this.spinRight = WHCUtils.wrapDegrees(this.spinRight + spin);
        this.caster.get(this.prevCaster);
        this.caster.add((Vector2dc)delta.mul(0.5)).normalize();
    }

    public float casterWheelYaw(float tickDelta) {
        Vector2d origin = this.prevCaster.get(new Vector2d());
        Vector2d current = this.caster.get(new Vector2d());
        origin.add((Vector2dc)current.sub((Vector2dc)origin).mul((double)tickDelta));
        return (float)Math.toDegrees(Math.atan2(origin.y, origin.x));
    }

    public boolean hasInventory() {
        return (Boolean)this.method_5841().method_12789(HAS_INV);
    }

    public void addInventory() {
        if (this.hasInventory()) {
            return;
        }
        this.setHasInventory(true);
        this.method_5783((class_3414)class_3417.field_14862.comp_349(), this.method_6107(), this.method_6017());
    }

    public void setHasInventory(boolean bool) {
        this.method_5841().method_12778(HAS_INV, (Object)bool);
        this.onChestedStatusChanged();
    }

    public class_1263 getInventory() {
        return this.items;
    }

    protected void onChestedStatusChanged() {
        if (!this.hasInventory() && !this.method_37908().method_8608()) {
            this.method_16078((class_3218)this.method_37908());
        }
        class_1277 inv = this.items;
        this.items = new class_1277(15);
        if (inv != null) {
            for (int j = 0; j < Math.min(inv.method_5439(), this.items.method_5439()); ++j) {
                class_1799 stack = inv.method_5438(j);
                if (stack.method_7960()) continue;
                this.items.method_5447(j, stack.method_7972());
            }
        }
    }

    public void method_16078(class_3218 world) {
        super.method_16078(world);
        if (this.items != null) {
            for (int i = 0; i < this.items.method_5439(); ++i) {
                class_1799 stack = this.items.method_5438(i);
                if (stack.method_7960() || class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655)) continue;
                this.method_5775(world, stack);
                this.items.method_5447(i, class_1799.field_8037);
            }
        }
    }
}

