/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.lying.block.FrostedLavaBlock;
import com.lying.component.type.UpgradesComponent;
import com.lying.component.type.WheelComponent;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.IFlyingMount;
import com.lying.entity.IParentedEntity;
import com.lying.entity.WheelchairsRideable;
import com.lying.init.WHCBlocks;
import com.lying.init.WHCChairUpgrades;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCEnchantments;
import com.lying.init.WHCItems;
import com.lying.item.WheelchairItem;
import com.lying.mixin.AccessorEntity;
import com.lying.utility.ServerEvents;
import com.lying.utility.WHCUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1316;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4048;
import net.minecraft.class_4538;
import net.minecraft.class_4980;
import net.minecraft.class_4981;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9282;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.class_9730;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WheelchairEntity
extends WheelchairsRideable
implements class_1316,
class_4981,
IFlyingMount,
IParentedEntity {
    private static final int REBIND_COOLDOWN = 60;
    public static final class_2941<List<ChairUpgrade>> UPGRADE_LIST = class_2941.method_56031((class_9139)ChairUpgrade.PACKET_CODEC.method_56433(class_9135.method_56363()));
    public static final class_2940<class_1799> CHAIR = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<OptionalInt> COLOR = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_17910);
    public static final class_2940<class_1799> LEFT_WHEEL = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<class_1799> RIGHT_WHEEL = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<List<ChairUpgrade>> UPGRADES = class_2945.method_12791(WheelchairEntity.class, UPGRADE_LIST);
    public static final class_2940<Boolean> POWERED = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Optional<UUID>> USER_ID = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13313);
    public static final class_2940<Integer> REBIND = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Boolean> FLYING = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Integer> BOOST_TIME = class_2945.method_12791(WheelchairEntity.class, (class_2941)class_2943.field_13327);
    private final class_4980 saddledComponent = new class_4980(this.field_6011, BOOST_TIME, POWERED);
    protected class_1277 items;
    protected float jumpStrength = 0.0f;
    private class_1309 user = null;
    public float spinLeft;
    public float spinRight;

    public WheelchairEntity(class_1299<? extends WheelchairEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.onChestedStatusChanged();
    }

    public void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHAIR, (Object)((class_1792)WHCItems.WHEELCHAIR_OAK.get()).method_7854());
        builder.method_56912(COLOR, (Object)OptionalInt.of(-6265536));
        builder.method_56912(LEFT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.method_56912(RIGHT_WHEEL, (Object)WheelComponent.DEFAULT_WHEEL.get());
        builder.method_56912(UPGRADES, (Object)Lists.newArrayList());
        builder.method_56912(POWERED, (Object)false);
        builder.method_56912(USER_ID, Optional.empty());
        builder.method_56912(REBIND, (Object)0);
        builder.method_56912(FLYING, (Object)false);
        builder.method_56912(BOOST_TIME, (Object)0);
    }

    public static class_5132.class_5133 createWheelchairAttributes() {
        return WheelchairEntity.createMountAttributes().method_26868(class_5134.field_47761, 1.0);
    }

    public void method_5674(class_2940<?> data) {
        if (BOOST_TIME.equals(data) && this.method_37908().method_8608()) {
            this.saddledComponent.method_26307();
        }
        super.method_5674(data);
    }

    public void method_5749(class_2487 data) {
        super.method_5749(data);
        if (data.method_10573("Chair", 10)) {
            this.method_5841().method_12778(CHAIR, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)data.method_10562("Chair")).get()));
        }
        if (data.method_10573("Color", 3)) {
            this.method_5841().method_12778(COLOR, (Object)OptionalInt.of(data.method_10550("Color")));
        }
        if (data.method_10573("Wheels", 10)) {
            class_2487 wheels = data.method_10562("Wheels");
            this.method_5841().method_12778(LEFT_WHEEL, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)wheels.method_10562("Left")).get()));
            this.method_5841().method_12778(RIGHT_WHEEL, (Object)((class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)wheels.method_10562("Right")).get()));
        }
        if (data.method_10545("Upgrades")) {
            this.setUpgrades(ChairUpgrade.decodeList(class_2509.field_11560, data.method_10580("Upgrades")));
        }
        this.onChestedStatusChanged();
        if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
            class_2499 items = data.method_10554("Items", 10);
            for (int i = 0; i < items.size(); ++i) {
                class_2487 nbt = items.method_10602(i);
                int j = nbt.method_10571("Slot") & 0xFF;
                if (j >= this.items.method_5439()) continue;
                this.items.method_5447(j, class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt).orElse(class_1799.field_8037));
            }
        }
    }

    public void method_5652(class_2487 data) {
        super.method_5652(data);
        data.method_10566("Chair", ((class_1799)this.method_5841().method_12789(CHAIR)).method_57358((class_7225.class_7874)this.method_56673()));
        if (((OptionalInt)this.method_5841().method_12789(COLOR)).isPresent()) {
            data.method_10569("Color", this.getColor());
        }
        class_2487 wheels = new class_2487();
        wheels.method_10566("Left", this.getLeftWheel().method_57358((class_7225.class_7874)this.method_56673()));
        wheels.method_10566("Right", this.getRightWheel().method_57358((class_7225.class_7874)this.method_56673()));
        data.method_10566("Wheels", (class_2520)wheels);
        if (!this.getUpgrades().isEmpty()) {
            data.method_10566("Upgrades", (class_2520)ChairUpgrade.encodeList(class_2509.field_11560, this.getUpgrades()));
            if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
                class_2499 items = new class_2499();
                for (int i = 0; i < this.items.method_5439(); ++i) {
                    class_1799 stack = this.items.method_5438(i);
                    if (stack.method_7960()) continue;
                    class_2487 nbt = new class_2487();
                    nbt.method_10567("Slot", (byte)i);
                    items.add((Object)stack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)nbt));
                }
                data.method_10566("Items", (class_2520)items);
            }
        }
    }

    public List<ChairUpgrade> getUpgrades() {
        return Lists.newArrayList((Iterable)((Iterable)this.method_5841().method_12789(UPGRADES)));
    }

    public boolean hasUpgrade(ChairUpgrade upgrade) {
        return this.getUpgrades().stream().anyMatch(u -> u.equals(upgrade));
    }

    protected void setUpgrades(List<ChairUpgrade> newSet) {
        List<ChairUpgrade> oldSet = this.getUpgrades();
        List upgrades = newSet.stream().filter(Predicates.notNull()).toList();
        oldSet.stream().filter(u -> !upgrades.contains(u)).forEach(u -> u.removeFrom(this));
        upgrades.stream().filter(u -> !oldSet.contains(u)).forEach(u -> u.applyTo(this));
        this.method_5841().method_12778(UPGRADES, upgrades);
    }

    public void addUpgrade(ChairUpgrade upgrade) {
        if (this.hasUpgrade(upgrade)) {
            return;
        }
        List<ChairUpgrade> upgrades = this.getUpgrades();
        upgrades.add(upgrade);
        this.setUpgrades(upgrades);
        this.onChestedStatusChanged();
        this.method_5783((class_3414)class_3417.field_14862.comp_349(), this.method_6107(), this.method_6017());
    }

    public void removeUpgrade(ChairUpgrade upgrade) {
        if (!this.hasUpgrade(upgrade) || this.method_5782()) {
            return;
        }
        List<ChairUpgrade> upgrades = this.getUpgrades();
        upgrades.removeIf(u -> u.equals(upgrade));
        this.setUpgrades(upgrades);
        this.onChestedStatusChanged();
        this.dropItem((class_1935)upgrade.dropItem());
        this.method_5783(class_3417.field_14675, this.method_6107(), this.method_6017());
    }

    public boolean hasInventory() {
        return this.hasUpgrade(WHCChairUpgrades.STORAGE.get()) || this.hasUpgrade(WHCChairUpgrades.PLACER.get());
    }

    public class_1263 getInventory() {
        return this.items;
    }

    protected void onChestedStatusChanged() {
        if (!this.hasInventory() && !this.method_37908().method_8608()) {
            this.method_16078((class_3218)this.method_37908());
        }
        class_1277 inv = this.items;
        this.items = new class_1277(16);
        if (inv != null) {
            class_1799 stackInPlacer = inv.method_5438(0);
            if (!stackInPlacer.method_7960()) {
                if (this.hasUpgrade(WHCChairUpgrades.PLACER.get())) {
                    this.items.method_5447(0, stackInPlacer.method_7972());
                } else if (!class_1890.method_60142((class_1799)stackInPlacer, (class_9331)class_9701.field_51655)) {
                    this.dropStack(stackInPlacer);
                }
            }
            for (int i = 1; i < inv.method_5439(); ++i) {
                class_1799 stack = inv.method_5438(i);
                if (stack.method_7960()) continue;
                if (this.hasUpgrade(WHCChairUpgrades.STORAGE.get())) {
                    this.items.method_5447(i, stack.method_7972());
                    continue;
                }
                if (class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655)) continue;
                this.dropStack(stack);
            }
        }
    }

    public void method_16078(class_3218 world) {
        super.method_16078(world);
        if (this.items != null) {
            for (int i = 0; i < this.items.method_5439(); ++i) {
                class_1799 stack = this.items.method_5438(i);
                if (stack.method_7960() || class_1890.method_60142((class_1799)stack, (class_9331)class_9701.field_51655)) continue;
                this.method_5775(world, stack);
                this.items.method_5447(i, class_1799.field_8037);
            }
        }
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 heldStack = player.method_5998(hand);
        if (player.method_21823() && !this.method_5782() && !this.hasParent()) {
            if (heldStack.method_31573(class_3489.field_42612)) {
                List<ChairUpgrade> upgrades = this.getUpgrades();
                if (upgrades.isEmpty()) {
                    return class_1269.field_5814;
                }
                this.removeUpgrade(upgrades.get(upgrades.size() - 1));
                if (!player.method_7337()) {
                    heldStack.method_61653(1, player);
                }
                return class_1269.field_52422.method_61393(heldStack);
            }
            ArrayList possibleUpgrades = Lists.newArrayList();
            possibleUpgrades.addAll(WHCChairUpgrades.fromItem(heldStack, this));
            if (!possibleUpgrades.isEmpty()) {
                this.addUpgrade((ChairUpgrade)possibleUpgrades.stream().findFirst().get());
                if (!player.method_31549().field_7477) {
                    heldStack.method_7934(1);
                }
                return class_1269.field_52422.method_61393(heldStack);
            }
        }
        if (player.method_21823() && !this.method_5782() && !this.hasParent()) {
            this.convertToItem(null);
            return class_1269.field_21466;
        }
        if (!this.method_37908().method_8608()) {
            if (this.method_5782() && !this.method_5626((class_1297)player) && this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) && this.rebindCooldown() <= 0) {
                return IParentedEntity.bindToPlayer(player, this) ? class_1269.field_21466 : class_1269.field_5811;
            }
            if (!this.method_5782()) {
                return this.putPlayerInSaddle(player) ? class_1269.field_21466 : class_1269.field_5811;
            }
        }
        return class_1269.field_5812;
    }

    @Override
    public <T extends WheelchairsRideable> class_1799 entityToItem(T entity) {
        WheelchairEntity chair = (WheelchairEntity)entity;
        class_1799 stack = chair.getChair();
        WheelchairItem.setWheels(stack, chair.getLeftWheel(), chair.getRightWheel());
        if (chair.hasColor() && stack.method_7909() instanceof WheelchairItem) {
            stack.method_57379(class_9334.field_49644, (Object)new class_9282(chair.getColor(), true));
        }
        stack.method_57379((class_9331)WHCDataComponentTypes.UPGRADES.get(), (Object)UpgradesComponent.fromList(chair.getUpgrades()));
        return stack;
    }

    @Override
    public void copyFromItem(class_1799 stack) {
        List<ChairUpgrade> upgrades;
        stack.method_57353().method_57832(class_9334.field_49644);
        this.method_5841().method_12778(CHAIR, (Object)stack.method_7972());
        this.method_5841().method_12778(COLOR, (Object)(stack.method_57353().method_57832(class_9334.field_49644) ? OptionalInt.of(class_9282.method_57470((class_1799)stack, (int)-1)) : OptionalInt.empty()));
        this.method_5841().method_12778(LEFT_WHEEL, (Object)WheelchairItem.getWheel(stack, class_1306.field_6182));
        this.method_5841().method_12778(RIGHT_WHEEL, (Object)WheelchairItem.getWheel(stack, class_1306.field_6183));
        if (stack.method_57826((class_9331)WHCDataComponentTypes.UPGRADES.get()) && !(upgrades = ((UpgradesComponent)stack.method_57824((class_9331)WHCDataComponentTypes.UPGRADES.get())).asList()).isEmpty()) {
            this.setUpgrades(upgrades);
        }
    }

    @Override
    public void convertToItem(@Nullable class_1657 player) {
        if (!this.method_37908().method_8608()) {
            class_1799 stack = this.entityToItem(this);
            class_1542 item = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
            this.method_16078((class_3218)this.method_37908());
            if (player == null || !player.method_31548().method_7394(stack)) {
                this.method_37908().method_8649((class_1297)item);
            }
            this.method_31472();
        }
    }

    public class_1309 method_5642() {
        return !this.hasParent() && this.method_31483() instanceof class_1309 ? (class_1309)this.method_31483() : null;
    }

    protected float method_49484() {
        return this.method_6029() * 0.1f;
    }

    public void method_6007() {
        class_1309 rider = null;
        if (this.method_6128() && (rider = (class_1309)this.method_31483()) != null) {
            this.orientToRider(rider, class_243.field_1353);
        }
        super.method_6007();
    }

    public boolean isManual(class_1657 controllingPlayer) {
        return !this.isAutomatic(controllingPlayer);
    }

    public boolean isAutomatic(class_1657 controllingPlayer) {
        return this.hasUpgrade(WHCChairUpgrades.POWERED.get()) && controllingPlayer.method_24518((class_1792)WHCItems.CONTROLLER.get());
    }

    public boolean method_5715() {
        return super.method_5715() || this.method_5782() && this.method_31483() instanceof class_1309 && this.method_31483().method_5715();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.clientTick();
        } else {
            this.serverTick();
        }
    }

    private void clientTick() {
        if (this.saddledComponent.method_49479() > 1.0f) {
            this.method_37908().method_8406((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
        }
        if (this.hasUpgrade(WHCChairUpgrades.DIVING.get()) && this.method_5777(class_3486.field_15517)) {
            this.method_37908().method_8406((class_2394)class_2398.field_11247, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 0.0, 0.0, 0.0);
        }
    }

    private void serverTick() {
        if (this.method_42148() && this.method_24828() && !this.method_6128() && this.field_6012 % 5 == 0 && this.hasUpgrade(WHCChairUpgrades.PLACER.get())) {
            class_1263 inv = this.getInventory();
            class_1799 stack = inv.method_5438(0);
            this.tryPlaceBlock(stack);
        }
        if (this.hasParent() && this.getParent() == null) {
            this.parentTo(null);
        }
        if (this.rebindCooldown() > 0) {
            this.method_5841().method_12778(REBIND, (Object)(this.rebindCooldown() - 1));
        }
    }

    private boolean tryPlaceBlock(class_1799 stack) {
        if (stack.method_7960() || !(stack.method_7909() instanceof class_1747) || this.method_37908().method_8608()) {
            return false;
        }
        class_1747 item = (class_1747)stack.method_7909();
        class_3218 world = (class_3218)this.method_37908();
        class_2350 direction = class_2350.field_11033;
        class_2338 blockPos = this.method_24515().method_10093(direction);
        if (world.method_8320(blockPos).method_26204() == item.method_7711()) {
            return false;
        }
        return item.method_7712((class_1750)new class_2968((class_1937)world, blockPos, direction, stack, direction)).method_23665();
    }

    @Override
    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, this.field_17046);
        if (!this.isManual(controllingPlayer) && this.method_5624()) {
            this.method_5728(false);
            controllingPlayer.method_5728(false);
        }
        this.orientToRider((class_1309)controllingPlayer, movementInput);
        this.saddledComponent.method_49478();
        class_1799 chair = this.getChair();
        class_9304 comp = (class_9304)chair.method_57824(class_9334.field_49633);
        if (comp != null && !comp.method_57543()) {
            if (!controllingPlayer.method_5809()) {
                WHCEnchantments.getFireProtection(this.method_56673()).ifPresent(f -> {
                    int fireProtectionLevel = comp.method_57536((class_6880)f);
                    if (fireProtectionLevel > 0) {
                        controllingPlayer.method_6092(new class_1293(class_1294.field_5918, 100 * fireProtectionLevel, 0, false, false, true));
                    }
                });
            }
            if (!this.method_5777(class_3486.field_15517)) {
                WHCEnchantments.getRespiration(this.method_56673()).ifPresent(r -> {
                    int respirationLevel = comp.method_57536((class_6880)r);
                    if (respirationLevel > 0) {
                        controllingPlayer.method_6092(new class_1293(class_1294.field_5923, 100 * respirationLevel, 0, false, false, true));
                    }
                });
            }
        }
        if (this.jumpStrength > 0.0f) {
            if (!this.method_24828() && this.canStartFlying()) {
                ((ServerEvents.DoubleJumpEvent)ServerEvents.ON_DOUBLE_JUMP.invoker()).onDoubleJump(this);
                this.startFlying();
            } else {
                this.method_6043();
            }
        }
        this.jumpStrength = 0.0f;
    }

    @Override
    protected void orientToRider(class_1309 controllingPlayer, class_243 movementInput) {
        if (movementInput.method_1033() > 0.0 || !this.hasUpgrade(WHCChairUpgrades.POWERED.get())) {
            super.orientToRider(controllingPlayer, movementInput);
        }
    }

    public boolean method_18276() {
        return super.method_18276() || this.method_5715();
    }

    protected class_243 method_18796(class_243 movement, class_1313 type) {
        if (movement.field_1351 <= 0.0 && (type == class_1313.field_6308 || type == class_1313.field_6305) && this.method_5715() && this.shouldClipMovement()) {
            double deltaX = movement.field_1352;
            double deltaZ = movement.field_1350;
            while (deltaX != 0.0 && this.method_37908().method_8587((class_1297)this, this.method_5829().method_989(deltaX, (double)(-this.method_49476()), 0.0))) {
                if (deltaX < 0.05 && deltaX >= -0.05) {
                    deltaX = 0.0;
                    continue;
                }
                if (deltaX > 0.0) {
                    deltaX -= 0.05;
                    continue;
                }
                deltaX += 0.05;
            }
            while (deltaZ != 0.0 && this.method_37908().method_8587((class_1297)this, this.method_5829().method_989(0.0, (double)(-this.method_49476()), deltaZ))) {
                if (deltaZ < 0.05 && deltaZ >= -0.05) {
                    deltaZ = 0.0;
                    continue;
                }
                if (deltaZ > 0.0) {
                    deltaZ -= 0.05;
                    continue;
                }
                deltaZ += 0.05;
            }
            while (deltaX != 0.0 && deltaZ != 0.0 && this.method_37908().method_8587((class_1297)this, this.method_5829().method_989(deltaX, (double)(-this.method_49476()), deltaZ))) {
                double d = deltaX < 0.05 && deltaX >= -0.05 ? 0.0 : (deltaX = deltaX > 0.0 ? (deltaX = deltaX - 0.05) : (deltaX = deltaX + 0.05));
                if (deltaZ < 0.05 && deltaZ >= -0.05) {
                    deltaZ = 0.0;
                    continue;
                }
                if (deltaZ > 0.0) {
                    deltaZ -= 0.05;
                    continue;
                }
                deltaZ += 0.05;
            }
            movement = new class_243(deltaX, movement.field_1351, deltaZ);
        }
        return movement;
    }

    public boolean shouldClipMovement() {
        return this.method_24828() || this.field_6017 < this.method_49476() && !this.method_37908().method_8587((class_1297)this, this.method_5829().method_989(0.0, (double)(this.field_6017 - this.method_49476()), 0.0));
    }

    @Override
    protected void method_5865(class_1297 passenger, class_1297.class_4738 positionUpdater) {
        super.method_5865(passenger, positionUpdater);
        if (passenger instanceof class_1309) {
            this.clampPassengerYaw(passenger);
        }
    }

    @Override
    protected void clampPassengerYaw(class_1297 passenger) {
        passenger.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(passenger.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        passenger.field_5982 += g - f;
        passenger.method_36456(passenger.method_36454() + g - f);
        passenger.method_5847(passenger.method_36454());
    }

    public void method_5710(float yaw, float pitch) {
        float prevYaw = this.method_36454();
        super.method_5710(yaw, pitch);
        float amount = this.method_36454() - prevYaw;
        if (amount == 0.0f || amount == 360.0f) {
            return;
        }
        if (this.method_6128()) {
            return;
        }
        this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + amount);
        this.spinRight = WHCUtils.wrapDegrees(this.spinRight - amount);
    }

    public boolean method_6101() {
        return super.method_6101() && !this.hasUpgrade(WHCChairUpgrades.POWERED.get());
    }

    @Override
    public boolean isSaddled() {
        return true;
    }

    @Override
    protected class_241 getControlledRotation(class_1309 controllingPassenger) {
        return new class_241(controllingPassenger.method_36455(), controllingPassenger.method_36454());
    }

    protected class_243 method_49482(class_1657 controllingPlayer, class_243 movementInput) {
        if (this.method_6128()) {
            return this.method_18798();
        }
        double modifier = 1.0;
        if (!this.method_24828() && !this.hasUpgrade(WHCChairUpgrades.GLIDING.get())) {
            modifier = this.shouldBobUp() ? 0.9 : 0.7;
        }
        class_243 speed = this.isAutomatic(controllingPlayer) ? new class_243(0.0, 0.0, 1.0) : new class_243(0.0, 0.0, (double)controllingPlayer.field_6250);
        return speed.method_1021(modifier);
    }

    protected float method_49485(class_1657 controllingPlayer) {
        return (float)controllingPlayer.method_45325(class_5134.field_23719) * (this.isManual(controllingPlayer) ? 1.0f : this.saddledComponent.method_49479());
    }

    @Override
    public void method_5784(class_1313 type, class_243 movementInput) {
        double x = this.method_23317();
        double z = this.method_23321();
        for (class_1297 rider : this.method_5685()) {
            movementInput = ((AccessorEntity)rider).adjustToPreventCollision(movementInput);
        }
        super.method_5784(type, movementInput);
        this.tickExhaustion(this.method_23317() - x, this.method_23321() - z);
        if (this.method_37908().method_8608() && !this.method_6128()) {
            class_243 local = WHCUtils.globalToLocal(movementInput, this.method_36454());
            double speed = WHCUtils.calculateSpin((float)local.method_10215(), 1.0f);
            this.spinLeft = WHCUtils.wrapDegrees(this.spinLeft + (float)speed);
            this.spinRight = WHCUtils.wrapDegrees(this.spinRight + (float)speed);
        }
    }

    @Override
    public float getActualStepHeight() {
        return 1.0f;
    }

    public void travelControlled(class_1657 controllingPlayer, class_243 movementInput) {
        if (this.shouldBobUp()) {
            this.method_5762(0.0, 0.08, 0.0);
        }
        super.method_6091(movementInput);
    }

    protected boolean shouldBobUp() {
        double swimHeight = this.method_29241();
        return this.hasUpgrade(WHCChairUpgrades.FLOATING.get()) && (this.method_5861(class_3486.field_15517) > swimHeight || this.hasUpgrade(WHCChairUpgrades.NETHERITE.get()) && this.method_5861(class_3486.field_15518) > swimHeight);
    }

    public void method_6126(class_3218 world, class_2338 pos) {
        super.method_6126(world, pos);
        class_1799 chair = this.getChair();
        class_9304 comp = (class_9304)chair.method_57824(class_9334.field_49633);
        if (comp == null || comp.method_57543()) {
            return;
        }
        if (this.method_24828() && this.hasUpgrade(WHCChairUpgrades.NETHERITE.get())) {
            List<class_6880> frostWalkers = comp.method_57534().stream().filter(ench -> {
                class_9323 effects = ((class_1887)ench.comp_349()).comp_2689();
                if (!effects.method_57832(class_9701.field_51670)) {
                    return false;
                }
                return ((List)effects.method_57829(class_9701.field_51670)).stream().filter(e -> e.comp_2680() instanceof class_9730 && ((class_9730)e.comp_2680()).comp_2746().method_23455(this.method_59922(), this.method_24515()).method_27852(class_2246.field_10110)).findFirst().isPresent();
            }).toList();
            frostWalkers.stream().map(e -> class_1890.method_8225((class_6880)e, (class_1799)chair)).sorted().findFirst().ifPresent(level -> WheelchairEntity.freezeLava(this, this.method_37908(), this.method_24515(), level));
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        if (this.isFlying()) {
            if (!this.method_37908().method_8608()) {
                this.stopFlying();
            }
            return false;
        }
        return !this.isFlying() && super.method_5747(fallDistance, damageMultiplier, damageSource);
    }

    protected static void freezeLava(class_1309 entity, class_1937 world, class_2338 blockPos, int level) {
        class_2680 frosted = ((class_2248)WHCBlocks.FROSTED_LAVA.get()).method_9564();
        int range = Math.min(16, 2 + level);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2338 pos : class_2338.method_10097((class_2338)blockPos.method_10069(-range, -1, -range), (class_2338)blockPos.method_10069(range, -1, range))) {
            if (!pos.method_19769((class_2374)entity.method_19538(), (double)range)) continue;
            mutable.method_10103(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
            class_2680 stateAbove = world.method_8320((class_2338)mutable);
            if (!stateAbove.method_26215() || world.method_8320(pos) != FrostedLavaBlock.getMeltedState() || !frosted.method_26184((class_4538)world, pos) || !world.method_8628(frosted, pos, class_3726.method_16194())) continue;
            world.method_8501(pos, frosted);
            world.method_64310(pos, (class_2248)WHCBlocks.FROSTED_LAVA.get(), class_3532.method_15395((class_5819)entity.method_59922(), (int)60, (int)120));
        }
    }

    public boolean method_48155() {
        return !this.hasUpgrade(WHCChairUpgrades.POWERED.get()) && this.method_5642() != null && this.method_5642().method_5864() == class_1299.field_6097;
    }

    public int getEnchantmentLevel(class_6880<class_1887> ench) {
        return class_1890.method_57532((class_1799)((class_1799)this.method_5841().method_12789(CHAIR))).method_57536(ench);
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        return new class_243(0.0, (double)(dimensions.comp_2186() * 0.85f * scaleFactor), 0.0);
    }

    public boolean method_6059(class_6880<class_1291> effect) {
        if (this.method_5782() && this.method_5642() instanceof class_1309) {
            return this.method_5642().method_6059(effect);
        }
        return false;
    }

    public class_1293 method_6112(class_6880<class_1291> effect) {
        if (this.method_5782() && this.method_5642() instanceof class_1309) {
            return this.method_5642().method_6112(effect);
        }
        return null;
    }

    public Iterable<class_1799> method_5661() {
        return class_2371.method_10213((int)4, (Object)class_1799.field_8037);
    }

    public boolean canEquip(class_1799 stack) {
        return false;
    }

    public class_1799 method_6118(class_1304 slot) {
        return slot == class_1304.field_6166 ? WheelchairEntity.getEnchantments(this.getChair()) : class_1799.field_8037;
    }

    public static class_1799 getEnchantments(class_1799 chair) {
        class_1799 spoof = class_1802.field_20391.method_7854();
        spoof.method_57379(class_9334.field_49633, (Object)((class_9304)chair.method_57824(class_9334.field_49633)));
        return spoof;
    }

    public void method_5673(class_1304 var1, class_1799 var2) {
    }

    public class_1799 getChair() {
        class_1799 stack = (class_1799)this.method_5841().method_12789(CHAIR);
        return stack.method_7909() instanceof WheelchairItem ? stack : new class_1799(WHCItems.WHEELCHAIR_OAK);
    }

    public boolean hasColor() {
        return ((OptionalInt)this.method_5841().method_12789(COLOR)).isPresent();
    }

    public int getColor() {
        return ((OptionalInt)this.method_5841().method_12789(COLOR)).orElse(-1);
    }

    public class_1799 getWheel(class_1306 arm) {
        return arm == class_1306.field_6182 ? this.getLeftWheel() : this.getRightWheel();
    }

    protected class_1799 getWheel(class_1799 actualWheel) {
        class_1799 wheel = actualWheel.method_7909().method_7854().method_7972();
        wheel.method_57379(class_9334.field_49633, (Object)((class_9304)this.getChair().method_57824(class_9334.field_49633)));
        return wheel;
    }

    public class_1799 getLeftWheel() {
        return this.getWheel((class_1799)this.method_5841().method_12789(LEFT_WHEEL));
    }

    public class_1799 getRightWheel() {
        return this.getWheel((class_1799)this.method_5841().method_12789(RIGHT_WHEEL));
    }

    public boolean method_6577() {
        return this.saddledComponent.method_26308(this.method_59922());
    }

    public void method_6154(int strength) {
        if (strength < 0) {
            strength = 0;
        }
        this.jumpStrength = strength > 0 ? 1.0f : 0.0f;
    }

    public boolean method_6153() {
        return this.hasUpgrade(WHCChairUpgrades.DIVING.get()) && this.method_5777(class_3486.field_15517) || this.canStartFlying();
    }

    public void method_6155(int var1) {
    }

    public void method_6156() {
    }

    @Override
    public boolean canFly() {
        return this.hasUpgrade(WHCChairUpgrades.GLIDING.get());
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.method_5841().method_12789(FLYING);
    }

    public boolean method_6128() {
        return this.isFlying() || super.method_6128();
    }

    @Override
    public boolean canUseRocket() {
        return true;
    }

    @Override
    public void startFlying() {
        this.method_5841().method_12778(FLYING, (Object)true);
        this.method_5783((class_3414)class_3417.field_14581.comp_349(), this.method_6107(), this.method_6017());
    }

    @Override
    public void stopFlying() {
        this.method_5841().method_12778(FLYING, (Object)false);
        this.method_5783((class_3414)class_3417.field_14581.comp_349(), this.method_6107(), this.method_6017() * 0.5f);
    }

    @Override
    public boolean hasParent() {
        return this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) && ((Optional)this.method_5841().method_12789(USER_ID)).isPresent();
    }

    @Override
    public boolean isParent(class_1297 entity) {
        return this.hasParent() && ((UUID)((Optional)this.method_5841().method_12789(USER_ID)).get()).equals(entity.method_5667());
    }

    @Override
    @Nullable
    public class_1309 getParent() {
        if (!this.hasParent()) {
            return null;
        }
        return this.user == null ? (this.user = IParentedEntity.getParentOf(this)) : this.user;
    }

    @Override
    public void parentTo(@Nullable class_1309 parent) {
        if (!this.hasUpgrade(WHCChairUpgrades.HANDLES.get()) || this.method_5626((class_1297)parent)) {
            return;
        }
        this.method_5841().method_12778(USER_ID, parent == null ? Optional.empty() : Optional.of(parent.method_5667()));
    }

    @Override
    public class_243 getParentOffset(class_1309 parent, float yaw, float pitch) {
        return WHCUtils.localToGlobal(new class_243(0.0, 0.0, 0.75), parent.field_6283);
    }

    @Override
    public void tickParented(@NotNull class_1309 parent, float yaw, float pitch) {
        this.method_5710(parent.field_6283, 0.0f);
        if (!this.canParentToChild(parent, this)) {
            this.clearParent();
        }
    }

    public void method_6087(class_1297 entity) {
        if (!this.isParent(entity)) {
            super.method_6087(entity);
        }
    }

    public void method_5697(class_1297 entity) {
        if (!this.isParent(entity)) {
            super.method_5697(entity);
        }
    }

    public void forceUnbind() {
        if (!this.hasParent()) {
            return;
        }
        this.clearParent();
        this.resetRebindCooldown();
    }

    public int rebindCooldown() {
        return (Integer)this.method_5841().method_12789(REBIND);
    }

    public void resetRebindCooldown() {
        this.method_5841().method_12778(REBIND, (Object)60);
    }
}

