/*
 * Decompiled with CFR 0.152.
 */
package com.lying.fabric.data;

import com.lying.data.WHCTags;
import com.lying.data.recipe.RecipeCaneJsonBuilder;
import com.lying.data.recipe.RecipeCaneSword;
import com.lying.data.recipe.RecipeHandleJsonBuilder;
import com.lying.data.recipe.RecipeWalkerJsonBuilder;
import com.lying.data.recipe.RecipeWheelchairJsonBuilder;
import com.lying.init.WHCItems;
import com.lying.reference.Reference;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2447;
import net.minecraft.class_2456;
import net.minecraft.class_3489;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;

public class WHCRecipeProvider
extends FabricRecipeProvider {
    public static final String GROUP_WHEELS = "wheelchairs:wheels";
    public static final String GROUP_CHAIRS = "wheelchairs:wheelchairs";
    public static final String GROUP_CANES = "wheelchairs:canes";
    public static final String GROUP_CRUTCHES = "wheelchairs:crutches";
    private static final Map<Wood, WoodSet> WOOD_GUIDE = new HashMap<Wood, WoodSet>();

    public WHCRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> lookup) {
        super(output, lookup);
    }

    public String method_10321() {
        return "Wheelchairs recipes";
    }

    protected class_2446 method_62766(final class_7225.class_7874 wrapperLookup, class_8790 exporter) {
        return new class_2446(this, wrapperLookup, exporter){

            public void method_10419() {
                class_2456.method_10476(category -> new RecipeCaneSword()).method_53820(this.field_53721, "cane_sword");
                WOOD_GUIDE.entrySet().forEach(entry -> {
                    this.offerWoodWheelRecipe(this.field_53721, ((WoodSet)entry.getValue()).wheel, (Wood)((Object)((Object)entry.getKey())));
                    this.offerWheelchairRecipe(this.field_53721, (class_7871.class_7872)wrapperLookup, ((WoodSet)entry.getValue()).wheelchair, (Wood)((Object)((Object)entry.getKey())));
                    this.offerWalkerRecipe(this.field_53721, (class_7871.class_7872)wrapperLookup, ((WoodSet)entry.getValue()).walker, (Wood)((Object)((Object)entry.getKey())));
                    this.offerCrutchRecipe(this.field_53721, ((WoodSet)entry.getValue()).crutch, (Wood)((Object)((Object)entry.getKey())));
                    this.offerCaneRecipe(this.field_53721, ((WoodSet)entry.getValue()).cane, (Wood)((Object)((Object)entry.getKey())));
                    this.offerHandleRecipe(this.field_53721, ((WoodSet)entry.getValue()).handle, (Wood)((Object)((Object)entry.getKey())));
                });
                this.offerMetalWheelRecipe(this.field_53721, WHCItems.WHEEL_COPPER, Metal.COPPER);
                this.offerMetalWheelRecipe(this.field_53721, WHCItems.WHEEL_IRON, Metal.IRON);
                this.offerMetalWheelRecipe(this.field_53721, WHCItems.WHEEL_GOLD, Metal.GOLD);
                this.offerMetalWheelRecipe(this.field_53721, WHCItems.WHEEL_NETHERITE, Metal.NETHERITE);
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_BONE, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606}), "bone_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_COPPER, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_27022}), "copper_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_IRON, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620}), "iron_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_GOLD, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695}), "gold_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_SKULL, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8398}), "skull_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_WITHER, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8791}), "wither_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_BLACKSTONE, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_23834}), "blackstone_handle");
                this.offerHandleRecipe(this.field_53721, WHCItems.HANDLE_GILDED_BLACKSTONE, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_23847}), "gilded_blackstone_handle");
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40637, (class_1935)((class_1935)WHCItems.CONTROLLER.get())).method_10439("j").method_10439("b").method_10434(Character.valueOf('j'), (class_1935)class_1802.field_8530).method_10434(Character.valueOf('b'), (class_1935)class_2246.field_10282).method_10429(1.method_32807((class_1935)class_1802.field_8530), this.method_10426((class_1935)class_1802.field_8530)).method_10429(1.method_32807((class_1935)class_2246.field_10282), this.method_10426((class_1935)class_2246.field_10282)).method_10431(this.field_53721);
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40642, (class_1935)((class_1935)WHCItems.STOOL.get())).method_10439(" s ").method_10439(" i ").method_10439("wbw").method_10428(Character.valueOf('s'), this.method_62748(class_3489.field_15544)).method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8620).method_10434(Character.valueOf('b'), (class_1935)class_1802.field_8076).method_10428(Character.valueOf('w'), this.method_62748(WHCTags.WHEEL)).method_10429(1.method_32807((class_1935)((class_1935)WHCItems.WHEEL_OAK.get())), this.method_10420(WHCTags.WHEEL)).method_10429(1.method_32807((class_1935)class_1802.field_8076), this.method_10426((class_1935)class_1802.field_8076)).method_10431(this.field_53721);
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40642, (class_1935)((class_1935)WHCItems.VEST.get())).method_10439(" l ").method_10439("lil").method_10439(" s ").method_10434(Character.valueOf('l'), (class_1935)class_1802.field_8745).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8276).method_10434(Character.valueOf('i'), (class_1935)class_1802.field_8695).method_10429(1.method_32807((class_1935)class_1802.field_8745), this.method_10426((class_1935)class_1802.field_8745)).method_10429(1.method_32807((class_1935)class_1802.field_8276), this.method_10426((class_1935)class_1802.field_8276)).method_10431(this.field_53721);
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40642, (class_1935)((class_1935)WHCItems.TABLET.get())).method_10439("bb").method_10439("ns").method_10434(Character.valueOf('n'), (class_1935)class_2246.field_10179).method_10434(Character.valueOf('b'), (class_1935)class_2246.field_10494).method_10434(Character.valueOf('s'), (class_1935)class_2246.field_10136).method_10429(1.method_32807((class_1935)class_2246.field_10179), this.method_10426((class_1935)class_2246.field_10179)).method_10429(1.method_32807((class_1935)class_2246.field_10494), this.method_10426((class_1935)class_2246.field_10494)).method_10429(1.method_32807((class_1935)class_2246.field_10136), this.method_10426((class_1935)class_2246.field_10136)).method_10431(this.field_53721);
            }

            private void offerWoodWheelRecipe(class_8790 exporter, class_1792 wheel, Wood wood) {
                this.offerWheelRecipe(exporter, wheel, (class_1935)wood.slab);
            }

            private void offerMetalWheelRecipe(class_8790 exporter, RegistrySupplier<class_1792> wheel, Metal metal) {
                this.offerWheelRecipe(exporter, (class_1792)wheel.get(), (class_1935)metal.ingot);
            }

            private void offerWheelRecipe(class_8790 exporter, class_1792 wheel, class_1935 slab) {
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40637, (class_1935)wheel).method_10439(" S ").method_10439("SsS").method_10439(" S ").method_10434(Character.valueOf('S'), slab).method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8600).method_10435(WHCRecipeProvider.GROUP_WHEELS).method_10429(1.method_32807((class_1935)slab), this.method_10426(slab)).method_10429(1.method_32807((class_1935)class_1802.field_8600), this.method_10426((class_1935)class_1802.field_8600)).method_10431(exporter);
            }

            private void offerWheelchairRecipe(class_8790 exporter, class_7871.class_7872 lookup, class_1792 chair, Wood wood) {
                String name = wood.name().toLowerCase() + "_wheelchair";
                class_1856 backing = class_1856.method_8091((class_1935[])new class_1935[]{wood.log});
                class_1856 cushion = class_1856.method_8106((class_6885)lookup.method_46751(class_7924.field_41197).method_46735(class_3489.field_15544));
                class_1856 wheel = this.method_62748(WHCTags.WHEEL);
                RecipeWheelchairJsonBuilder builder = new RecipeWheelchairJsonBuilder(chair.method_7854(), backing, cushion, wheel, wheel, class_7800.field_40637);
                if (!backing.method_65799()) {
                    builder.criterion("has_backing", this.method_10426((class_1935)((class_6880)backing.method_8105().findFirst().get()).comp_349()));
                }
                builder.offerTo(exporter, Reference.ModInfo.prefix(name));
            }

            private void offerCaneRecipe(class_8790 exporter, class_1792 cane, Wood wood) {
                String name = wood.name().toLowerCase() + "_cane";
                class_1856 backing = class_1856.method_8091((class_1935[])new class_1935[]{wood.strippedLog});
                RecipeCaneJsonBuilder builder = new RecipeCaneJsonBuilder(cane.method_7854(), backing, class_7800.field_40637);
                if (!backing.method_65799()) {
                    builder.criterion("has_backing", this.method_10426((class_1935)((class_1792)((class_6880)backing.method_8105().findFirst().get()).comp_349()).method_8389()));
                }
                builder.offerTo(exporter, Reference.ModInfo.prefix(name));
            }

            private void offerHandleRecipe(class_8790 exporter, class_1792 handle, Wood wood) {
                class_1856 material = class_1856.method_8091((class_1935[])new class_1935[]{wood.button});
                RecipeHandleJsonBuilder builder = new RecipeHandleJsonBuilder(handle.method_7854(), material, class_7800.field_40637);
                if (!material.method_65799()) {
                    builder.criterion("has_backing", this.method_10426((class_1935)((class_1792)((class_6880)material.method_8105().findFirst().get()).comp_349()).method_8389()));
                }
                builder.offerTo(exporter, Reference.ModInfo.prefix(wood.name().toLowerCase() + "_handle"));
            }

            private void offerHandleRecipe(class_8790 exporter, RegistrySupplier<class_1792> handle, class_1856 material, String name) {
                RecipeHandleJsonBuilder builder = new RecipeHandleJsonBuilder(((class_1792)handle.get()).method_7854(), material, class_7800.field_40637);
                if (!material.method_65799()) {
                    builder.criterion("has_backing", this.method_10426((class_1935)((class_1792)((class_6880)material.method_8105().findFirst().get()).comp_349()).method_8389()));
                }
                builder.offerTo(exporter, Reference.ModInfo.prefix(name));
            }

            private void offerCrutchRecipe(class_8790 exporter, class_1792 crutch, Wood wood) {
                class_2447.method_10437((class_7871)class_7923.field_41178, (class_7800)class_7800.field_40637, (class_1935)crutch).method_10439("sWs").method_10439("s s").method_10439(" P ").method_10434(Character.valueOf('s'), (class_1935)class_1802.field_8600).method_10428(Character.valueOf('W'), class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_19044})).method_10428(Character.valueOf('P'), class_1856.method_8091((class_1935[])new class_1935[]{wood.planks})).method_10435(WHCRecipeProvider.GROUP_CRUTCHES).method_10429(1.method_32807((class_1935)class_1802.field_8600), this.method_10426((class_1935)class_1802.field_8600)).method_10429(1.method_32807((class_1935)class_1802.field_19044), this.method_10426((class_1935)class_1802.field_19044)).method_10429(1.method_32807((class_1935)wood.planks), this.method_10426((class_1935)wood.planks)).method_10431(exporter);
            }

            private void offerWalkerRecipe(class_8790 exporter, class_7871.class_7872 lookup, class_1792 walker, Wood wood) {
                String name = wood.name().toLowerCase() + "_walker";
                class_1856 strut = class_1856.method_8091((class_1935[])new class_1935[]{wood.log});
                class_1856 platform = class_1856.method_8091((class_1935[])new class_1935[]{wood.planks});
                class_1856 handle = class_1856.method_8101((class_1935)class_1802.field_8600);
                class_1856 wheel = this.method_62748(WHCTags.WHEEL);
                RecipeWalkerJsonBuilder builder = new RecipeWalkerJsonBuilder(walker.method_7854(), strut, platform, handle, wheel, wheel, class_7800.field_40637);
                if (!strut.method_65799()) {
                    builder.criterion("has_strut", this.method_10426((class_1935)((class_1792)((class_6880)strut.method_8105().findFirst().get()).comp_349()).method_8389()));
                }
                if (!platform.method_65799()) {
                    builder.criterion("has_platform", this.method_10426((class_1935)((class_1792)((class_6880)platform.method_8105().findFirst().get()).comp_349()).method_8389()));
                }
                builder.offerTo(exporter, Reference.ModInfo.prefix(name));
            }
        };
    }

    private static void putWoodSet(Wood wood, RegistrySupplier<class_1792> wheel, RegistrySupplier<class_1792> chair, RegistrySupplier<class_1792> walker, RegistrySupplier<class_1792> crutch, RegistrySupplier<class_1792> cane, RegistrySupplier<class_1792> handle) {
        WOOD_GUIDE.put(wood, new WoodSet((class_1792)wheel.get(), (class_1792)chair.get(), (class_1792)walker.get(), (class_1792)crutch.get(), (class_1792)cane.get(), (class_1792)handle.get()));
    }

    static {
        WHCRecipeProvider.putWoodSet(Wood.OAK, WHCItems.WHEEL_OAK, WHCItems.WHEELCHAIR_OAK, WHCItems.WALKER_OAK, WHCItems.CRUTCH_OAK, WHCItems.CANE_OAK, WHCItems.HANDLE_OAK);
        WHCRecipeProvider.putWoodSet(Wood.SPRUCE, WHCItems.WHEEL_SPRUCE, WHCItems.WHEELCHAIR_SPRUCE, WHCItems.WALKER_SPRUCE, WHCItems.CRUTCH_SPRUCE, WHCItems.CANE_SPRUCE, WHCItems.HANDLE_SPRUCE);
        WHCRecipeProvider.putWoodSet(Wood.BIRCH, WHCItems.WHEEL_BIRCH, WHCItems.WHEELCHAIR_BIRCH, WHCItems.WALKER_BIRCH, WHCItems.CRUTCH_BIRCH, WHCItems.CANE_BIRCH, WHCItems.HANDLE_BIRCH);
        WHCRecipeProvider.putWoodSet(Wood.DARK_OAK, WHCItems.WHEEL_DARK_OAK, WHCItems.WHEELCHAIR_DARK_OAK, WHCItems.WALKER_DARK_OAK, WHCItems.CRUTCH_DARK_OAK, WHCItems.CANE_DARK_OAK, WHCItems.HANDLE_DARK_OAK);
        WHCRecipeProvider.putWoodSet(Wood.JUNGLE, WHCItems.WHEEL_JUNGLE, WHCItems.WHEELCHAIR_JUNGLE, WHCItems.WALKER_JUNGLE, WHCItems.CRUTCH_JUNGLE, WHCItems.CANE_JUNGLE, WHCItems.HANDLE_JUNGLE);
        WHCRecipeProvider.putWoodSet(Wood.ACACIA, WHCItems.WHEEL_ACACIA, WHCItems.WHEELCHAIR_ACACIA, WHCItems.WALKER_ACACIA, WHCItems.CRUTCH_ACACIA, WHCItems.CANE_ACACIA, WHCItems.HANDLE_ACACIA);
        WHCRecipeProvider.putWoodSet(Wood.CRIMSON, WHCItems.WHEEL_CRIMSON, WHCItems.WHEELCHAIR_CRIMSON, WHCItems.WALKER_CRIMSON, WHCItems.CRUTCH_CRIMSON, WHCItems.CANE_CRIMSON, WHCItems.HANDLE_CRIMSON);
        WHCRecipeProvider.putWoodSet(Wood.WARPED, WHCItems.WHEEL_WARPED, WHCItems.WHEELCHAIR_WARPED, WHCItems.WALKER_WARPED, WHCItems.CRUTCH_WARPED, WHCItems.CANE_WARPED, WHCItems.HANDLE_WARPED);
        WHCRecipeProvider.putWoodSet(Wood.MANGROVE, WHCItems.WHEEL_MANGROVE, WHCItems.WHEELCHAIR_MANGROVE, WHCItems.WALKER_MANGROVE, WHCItems.CRUTCH_MANGROVE, WHCItems.CANE_MANGROVE, WHCItems.HANDLE_MANGROVE);
        WHCRecipeProvider.putWoodSet(Wood.CHERRY, WHCItems.WHEEL_CHERRY, WHCItems.WHEELCHAIR_CHERRY, WHCItems.WALKER_CHERRY, WHCItems.CRUTCH_CHERRY, WHCItems.CANE_CHERRY, WHCItems.HANDLE_CHERRY);
        WHCRecipeProvider.putWoodSet(Wood.BAMBOO, WHCItems.WHEEL_BAMBOO, WHCItems.WHEELCHAIR_BAMBOO, WHCItems.WALKER_BAMBOO, WHCItems.CRUTCH_BAMBOO, WHCItems.CANE_BAMBOO, WHCItems.HANDLE_BAMBOO);
        WHCRecipeProvider.putWoodSet(Wood.PALE_OAK, WHCItems.WHEEL_PALE_OAK, WHCItems.WHEELCHAIR_PALE_OAK, WHCItems.WALKER_PALE_OAK, WHCItems.CRUTCH_PALE_OAK, WHCItems.CANE_PALE_OAK, WHCItems.HANDLE_PALE_OAK);
    }

    public record WoodSet(class_1792 wheel, class_1792 wheelchair, class_1792 walker, class_1792 crutch, class_1792 cane, class_1792 handle) {
    }

    public static enum Wood {
        OAK(class_2246.field_10431, class_2246.field_10161, class_2246.field_10119, class_2246.field_10519, class_2246.field_10057),
        SPRUCE(class_2246.field_10037, class_2246.field_9975, class_2246.field_10071, class_2246.field_10436, class_2246.field_10066),
        BIRCH(class_2246.field_10511, class_2246.field_10148, class_2246.field_10257, class_2246.field_10366, class_2246.field_10417),
        DARK_OAK(class_2246.field_10010, class_2246.field_10075, class_2246.field_10500, class_2246.field_10244, class_2246.field_10493),
        PALE_OAK(class_2246.field_54715, class_2246.field_54735, class_2246.field_54727, class_2246.field_54716, class_2246.field_54724),
        JUNGLE(class_2246.field_10306, class_2246.field_10334, class_2246.field_10617, class_2246.field_10254, class_2246.field_10553),
        ACACIA(class_2246.field_10533, class_2246.field_10218, class_2246.field_10031, class_2246.field_10622, class_2246.field_10278),
        CRIMSON(class_2246.field_22118, class_2246.field_22126, class_2246.field_22128, class_2246.field_22119, class_2246.field_22100),
        WARPED(class_2246.field_22111, class_2246.field_22127, class_2246.field_22129, class_2246.field_22112, class_2246.field_22101),
        MANGROVE(class_2246.field_37545, class_2246.field_37577, class_2246.field_37564, class_2246.field_37548, class_2246.field_37559),
        CHERRY(class_2246.field_42729, class_2246.field_42751, class_2246.field_42746, class_2246.field_42732, class_2246.field_42743),
        BAMBOO(class_2246.field_41072, class_2246.field_40294, class_2246.field_40292, class_2246.field_41073, class_2246.field_40286);

        public final class_2248 log;
        public final class_2248 planks;
        public final class_2248 slab;
        public final class_2248 strippedLog;
        public final class_2248 button;

        private Wood(class_2248 logIn, class_2248 planksIn, class_2248 slabIn, class_2248 strippedLogIn, class_2248 buttonIn) {
            this.log = logIn;
            this.planks = planksIn;
            this.slab = slabIn;
            this.strippedLog = strippedLogIn;
            this.button = buttonIn;
        }
    }

    public static enum Metal {
        COPPER(class_1802.field_27022, class_2246.field_27119),
        IRON(class_1802.field_8620, class_2246.field_10085, class_1802.field_8675),
        GOLD(class_1802.field_8695, class_2246.field_10205, class_1802.field_8397),
        NETHERITE(class_1802.field_22020, class_2246.field_22108);

        public final class_1792 ingot;
        public final class_2248 block;
        public final Optional<class_1792> nugget;

        private Metal(class_1792 ingotIn, class_2248 blockIn) {
            this(ingotIn, blockIn, null);
        }

        private Metal(@Nullable class_1792 ingotIn, class_2248 blockIn, class_1792 nuggetIn) {
            this.ingot = ingotIn;
            this.block = blockIn;
            this.nugget = nuggetIn == null ? Optional.empty() : Optional.of(nuggetIn);
        }
    }
}

