/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCBlocks;
import com.lying.reference.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WHCChairUpgrades {
    private static final Map<class_2960, Supplier<ChairUpgrade>> UPGRADES = new HashMap<class_2960, Supplier<ChairUpgrade>>();
    public static final Supplier<ChairUpgrade> POWERED = WHCChairUpgrades.register("powered", b -> b.modelled().keyItem(class_1802.field_8063).applied(chair -> chair.method_5841().method_12778(WheelchairEntity.POWERED, (Object)true)).removed(chair -> chair.method_5841().method_12778(WheelchairEntity.POWERED, (Object)false)));
    public static final Supplier<ChairUpgrade> STORAGE = WHCChairUpgrades.register("storage", b -> b.modelled().enablesScreen().keyItem((Predicate<class_1799>)((Predicate)stack -> stack.method_31574(class_1802.field_8106) || stack.method_31574(class_1802.field_8247))).dropItem(class_1802.field_8106));
    public static final Supplier<ChairUpgrade> FLOATING = WHCChairUpgrades.register("floating", b -> b.modelled().keyItem(class_1802.field_17518));
    public static final Supplier<ChairUpgrade> NETHERITE = WHCChairUpgrades.register("netherite", b -> b.modelled().keyItem(class_1802.field_22020));
    public static final Supplier<ChairUpgrade> DIVING = WHCChairUpgrades.register("diving", b -> b.modelled().keyItem(class_1802.field_8745).incompatible(() -> List.of(FLOATING, POWERED)));
    public static final Supplier<ChairUpgrade> GLIDING = WHCChairUpgrades.register("gliding", b -> b.keyItem(class_1802.field_8833).incompatible(() -> List.of(POWERED)));
    public static final Supplier<ChairUpgrade> PLACER = WHCChairUpgrades.register("placer", b -> b.modelled().enablesScreen().keyItem(class_1802.field_8357));
    public static final Supplier<ChairUpgrade> HANDLES = WHCChairUpgrades.register("handles", b -> b.modelled().enablesScreen().keyItem(class_1802.field_8076));

    private static Supplier<ChairUpgrade> register(String nameIn, Consumer<ChairUpgrade.Builder> consumer) {
        ChairUpgrade.Builder builder = ChairUpgrade.Builder.of(nameIn);
        consumer.accept(builder);
        Supplier<ChairUpgrade> supplier = () -> builder.build();
        UPGRADES.put(Reference.ModInfo.prefix(nameIn), supplier);
        return supplier;
    }

    public static void init() {
        UPGRADES.values().stream().map(s -> (ChairUpgrade)s.get()).filter(ChairUpgrade::hasModel).forEach(acc -> WHCBlocks.registerFakeBlock("upgrade_" + acc.registryName().method_12832()));
        Wheelchairs.LOGGER.info(" # Registered {} wheelchair upgrades", (Object)UPGRADES.size());
    }

    @Nullable
    public static ChairUpgrade get(class_2960 nameIn) {
        return UPGRADES.getOrDefault(nameIn, () -> null).get();
    }

    @Nullable
    public static Set<ChairUpgrade> fromItem(class_1799 stack, WheelchairEntity chair) {
        List<ChairUpgrade> existing = chair.getUpgrades();
        ArrayList upgrades = Lists.newArrayList();
        for (class_2960 id : UPGRADES.keySet()) {
            ChairUpgrade upgrade = WHCChairUpgrades.get(id);
            if (!upgrade.matches(stack) || !existing.stream().allMatch(upg -> ChairUpgrade.canCombineWith(upg, upgrade)) || !upgrade.canApplyTo(chair)) continue;
            upgrades.add(upgrade);
        }
        return Set.of(upgrades.toArray(new ChairUpgrade[0]));
    }

    public static List<ChairUpgrade> idsToList(List<class_2960> list) {
        ArrayList upgrades = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ChairUpgrade upgrade = WHCChairUpgrades.get(list.get(i));
            if (upgrade == null) continue;
            upgrades.add(upgrade);
        }
        return upgrades;
    }

    public static List<class_2960> listToIds(List<ChairUpgrade> upgrades) {
        ArrayList list = Lists.newArrayList();
        upgrades.forEach(upg -> list.add(upg.registryName()));
        return list;
    }
}

