/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.lying.Wheelchairs;
import com.lying.chairspace.ChairspaceCondition;
import com.lying.reference.Reference;
import com.lying.utility.ServerEvents;
import dev.architectury.event.Event;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class WHCChairspaceConditions {
    private static final Map<class_2960, Supplier<ChairspaceCondition>> CONDITIONS = new HashMap<class_2960, Supplier<ChairspaceCondition>>();
    public static final Supplier<ChairspaceCondition> ON_RESPAWN = WHCChairspaceConditions.register("on_respawn", id -> ChairspaceCondition.Builder.of(id, PlayerEvent.PLAYER_RESPAWN));
    public static final Supplier<ChairspaceCondition> ON_LOGIN = WHCChairspaceConditions.register("on_login", id -> ChairspaceCondition.Builder.of(id, PlayerEvent.PLAYER_JOIN));
    public static final Supplier<ChairspaceCondition> ON_FINISH_TELEPORT = WHCChairspaceConditions.register("on_finish_teleport", id -> ChairspaceCondition.Builder.of(id, ServerEvents.AFTER_PLAYER_TELEPORT));
    public static final Supplier<ChairspaceCondition> ON_LEAVE_SPECTATOR = WHCChairspaceConditions.register("on_leave_spectator", id -> ChairspaceCondition.Builder.of(id, ServerEvents.AFTER_PLAYER_CHANGE_GAME_MODE).condition(player -> !player.method_7325()));
    public static final Supplier<ChairspaceCondition> ON_STOP_FLYING = WHCChairspaceConditions.register("on_stop_flying", id -> ChairspaceCondition.Builder.of(id, ServerEvents.ON_STOP_FLYING));
    public static final Supplier<ChairspaceCondition> ON_WAKE_UP = WHCChairspaceConditions.register("on_wake_up", id -> ChairspaceCondition.Builder.of(id, ServerEvents.ON_WAKE_UP).postEffect(ent -> ((class_1309)ent).method_6033(1.0f)));

    private static Supplier<ChairspaceCondition> register(String nameIn, Function<String, ChairspaceCondition.Builder> supplier) {
        Supplier<ChairspaceCondition> finalised = () -> ((ChairspaceCondition.Builder)supplier.apply(nameIn)).build();
        CONDITIONS.put(Reference.ModInfo.prefix(nameIn), finalised);
        return finalised;
    }

    public static void init() {
        Wheelchairs.LOGGER.info(" # Registered {} chairspace conditions", (Object)CONDITIONS.size());
    }

    @Nullable
    public static ChairspaceCondition get(class_2960 nameIn) {
        return CONDITIONS.getOrDefault(nameIn, () -> null).get();
    }

    public static Collection<ChairspaceCondition> getApplicable(Event<?> eventIn) {
        return CONDITIONS.values().stream().map(s -> (ChairspaceCondition)s.get()).filter(c -> c.isListeningTo(eventIn)).toList();
    }
}

