/*
 * Decompiled with CFR 0.152.
 */
package com.lying.init;

import com.google.common.collect.Lists;
import com.lying.data.WHCTags;
import com.lying.init.WHCEnchantmentComponentTypes;
import com.lying.reference.Reference;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import net.minecraft.class_9704;
import net.minecraft.class_9711;

public class WHCEnchantments {
    private static final List<class_5321<class_1887>> WHEELCHAIR_ENCHANTS = Lists.newArrayList();
    public static final class_5321<class_1887> HOLLOWED = WHCEnchantments.register("hollowed");
    public static final class_5321<class_1887> SLIM = WHCEnchantments.register("slim");

    private static class_5321<class_1887> register(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)Reference.ModInfo.prefix(name));
    }

    public static void markWheelchairCompatible(class_5321<class_1887> acc) {
        WHEELCHAIR_ENCHANTS.add(acc);
    }

    public static boolean isValidEnchantment(String translationKey) {
        return WHEELCHAIR_ENCHANTS.stream().anyMatch(a -> a.method_29177().toString().equalsIgnoreCase(translationKey));
    }

    public static void init() {
        WHCEnchantments.markWheelchairCompatible((class_5321<class_1887>)class_1893.field_9128);
        WHCEnchantments.markWheelchairCompatible((class_5321<class_1887>)class_1893.field_9122);
        WHCEnchantments.markWheelchairCompatible((class_5321<class_1887>)class_1893.field_9095);
        WHCEnchantments.markWheelchairCompatible((class_5321<class_1887>)class_1893.field_9127);
    }

    public static Optional<class_6880.class_6883<class_1887>> getFrostWalker(class_5455 world) {
        return world.method_30530(class_7924.field_41265).method_10223(class_1893.field_9122.method_41185());
    }

    public static Optional<class_6880.class_6883<class_1887>> getFireProtection(class_5455 world) {
        return world.method_30530(class_7924.field_41265).method_10223(class_1893.field_9095.method_41185());
    }

    public static Optional<class_6880.class_6883<class_1887>> getRespiration(class_5455 world) {
        return world.method_30530(class_7924.field_41265).method_10223(class_1893.field_9127.method_41185());
    }

    public static Optional<class_6880.class_6883<class_1887>> getDepthStrider(class_5455 world) {
        return world.method_30530(class_7924.field_41265).method_10223(class_1893.field_9128.method_41185());
    }

    public static class_1887 create(class_2960 regName, class_6885<class_1792> validItems, int maxLevel, class_9274 slot, Consumer<class_1887.class_9700> effects) {
        class_1887.class_9700 builder = class_1887.method_60030((class_1887.class_9427)class_1887.method_58442(validItems, (int)5, (int)maxLevel, (class_1887.class_9426)class_1887.method_58441((int)5, (int)6), (class_1887.class_9426)class_1887.method_58441((int)20, (int)6), (int)2, (class_9274[])new class_9274[]{slot}));
        effects.accept(builder);
        return builder.method_60060(regName);
    }

    public static void bootstrap(class_7891<class_1887> registerable) {
        class_7871 itemLookup = registerable.method_46799(class_7924.field_41197);
        class_7871 enchLookup = registerable.method_46799(class_7924.field_41265);
        registerable.method_46838(HOLLOWED, (Object)WHCEnchantments.create(HOLLOWED.method_29177(), (class_6885<class_1792>)itemLookup.method_46735(WHCTags.CANE), 1, class_9274.field_49219, b -> {
            b.method_60062((class_9331)WHCEnchantmentComponentTypes.CANE_INVENTORY.get());
            b.method_60061((class_6885)enchLookup.method_46735(WHCTags.CANE_INTERACT_SET));
        }));
        registerable.method_46838(SLIM, (Object)WHCEnchantments.create(SLIM.method_29177(), (class_6885<class_1792>)itemLookup.method_46735(class_3489.field_42611), 1, class_9274.field_49219, b -> {
            b.method_60066(class_9701.field_51661, (Object)new class_9711((class_9704)class_9704.method_60186((float)-2.0f)));
            b.method_60062((class_9331)WHCEnchantmentComponentTypes.CANE_STOREABLE.get());
            b.method_60061((class_6885)enchLookup.method_46735(WHCTags.CANE_INTERACT_SET));
        }));
    }
}

