/*
 * Decompiled with CFR 0.152.
 */
package com.lying.item;

import com.lying.component.type.UpgradesComponent;
import com.lying.component.type.WheelComponent;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.init.WHCDataComponentTypes;
import com.lying.init.WHCEntityTypes;
import com.lying.item.EntityPlacerItem;
import com.lying.item.IBonusBlockItem;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_9288;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class WheelchairItem
extends EntityPlacerItem<WheelchairEntity>
implements IBonusBlockItem {
    public WheelchairItem(class_1792.class_1793 settings) {
        super(WHCEntityTypes.WHEELCHAIR, settings.method_57349(class_9334.field_49644, null).method_57349((class_9331)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)WheelComponent.empty(class_1306.field_6182)).method_57349((class_9331)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)WheelComponent.empty(class_1306.field_6183)).method_57349((class_9331)WHCDataComponentTypes.UPGRADES.get(), (Object)UpgradesComponent.blank()).method_57349(class_9334.field_49622, (Object)class_9288.field_49334));
    }

    public static class_1799 withWheels(class_1792 chair, class_1792 wheels) {
        class_1799 defaultStack = chair.method_7854();
        WheelchairItem.setWheels(defaultStack, wheels.method_7854(), wheels.method_7854());
        return defaultStack;
    }

    public boolean isEnchantable(class_1799 stack) {
        return this.method_7882() == 1;
    }

    public int getEnchantability() {
        return 5;
    }

    @Override
    protected WheelchairEntity makeEntity(class_3218 serverWorld, class_1799 stack, @Nullable class_1657 player, class_2338 pos) {
        WheelchairEntity wheelchair = (WheelchairEntity)((class_1299)WHCEntityTypes.WHEELCHAIR.get()).method_5894(serverWorld, stack, player, pos, class_3730.field_16465, true, true);
        if (wheelchair != null) {
            wheelchair.copyFromItem(stack);
        }
        return wheelchair;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        ((WheelComponent)stack.method_57824((class_9331)WHCDataComponentTypes.LEFT_WHEEL.get())).method_57409(context, tooltip::add, type);
        ((WheelComponent)stack.method_57824((class_9331)WHCDataComponentTypes.RIGHT_WHEEL.get())).method_57409(context, tooltip::add, type);
        ((UpgradesComponent)stack.method_57824((class_9331)WHCDataComponentTypes.UPGRADES.get())).method_57409(context, tooltip::add, type);
    }

    public void appendTooltip(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1792.class_9635 context) {
        tooltip.add((class_2561)class_2561.method_43469((String)"gui.wheelchairs.wheelchair.wheel_left", (Object[])new Object[]{WheelchairItem.getWheel(stack, class_1306.field_6182).method_7964()}));
        tooltip.add((class_2561)class_2561.method_43469((String)"gui.wheelchairs.wheelchair.wheel_right", (Object[])new Object[]{WheelchairItem.getWheel(stack, class_1306.field_6183).method_7964()}));
        List<class_2960> upgrades = ((UpgradesComponent)stack.method_57824((class_9331)WHCDataComponentTypes.UPGRADES.get())).upgrades();
        if (upgrades.size() > 0) {
            tooltip.add((class_2561)class_2561.method_43471((String)"gui.wheelchairs.upgrades"));
            for (class_2960 id : upgrades) {
                ChairUpgrade upgrade = WHCChairUpgrades.get(id);
                if (upgrade == null) continue;
                tooltip.add((class_2561)class_2561.method_43470((String)" * ").method_10852(upgrade.translate()));
            }
        }
    }

    public static Iterable<class_1799> getWheels(class_1799 stack) {
        class_2371 wheels = class_2371.method_10213((int)2, (Object)WheelComponent.DEFAULT_WHEEL.get());
        wheels.set(0, (Object)WheelchairItem.getWheel(stack, class_1306.field_6182));
        wheels.set(1, (Object)WheelchairItem.getWheel(stack, class_1306.field_6183));
        return wheels;
    }

    public static void setWheels(class_1799 stack, class_1799 left, class_1799 right) {
        if (!left.method_7960()) {
            stack.method_57379((class_9331)WHCDataComponentTypes.LEFT_WHEEL.get(), (Object)((WheelComponent)stack.method_57824((class_9331)WHCDataComponentTypes.LEFT_WHEEL.get())).with(left));
        }
        if (!right.method_7960()) {
            stack.method_57379((class_9331)WHCDataComponentTypes.RIGHT_WHEEL.get(), (Object)((WheelComponent)stack.method_57824((class_9331)WHCDataComponentTypes.RIGHT_WHEEL.get())).with(right));
        }
    }

    public static class_1799 getWheel(class_1799 stack, class_1306 arm) {
        class_9331 entry = arm == class_1306.field_6182 ? (class_9331)WHCDataComponentTypes.LEFT_WHEEL.get() : (class_9331)WHCDataComponentTypes.RIGHT_WHEEL.get();
        return stack.method_57826(entry) ? ((WheelComponent)stack.method_57824(entry)).item() : WheelComponent.DEFAULT_WHEEL.get();
    }

    public static boolean hasUpgrade(class_1799 stack, ChairUpgrade upgrade) {
        return ((UpgradesComponent)stack.method_57824((class_9331)WHCDataComponentTypes.UPGRADES.get())).upgrades().stream().anyMatch(up -> up.equals((Object)upgrade.registryName()));
    }
}

