/*
 * Decompiled with CFR 0.152.
 */
package com.lying.network;

import com.lying.Wheelchairs;
import com.lying.entity.ChairUpgrade;
import com.lying.entity.IFlyingMount;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCEntityTypes;
import com.lying.network.AACMessagePacket;
import com.lying.network.FlyingMountRocketPacket;
import com.lying.network.ForceUnparentPacket;
import com.lying.network.OpenInventoryScreenPacket;
import com.lying.network.SetSeatbeltPacket;
import com.lying.network.StartFlyingPacket;
import com.lying.reference.Reference;
import com.lying.screen.ChairInventoryScreenHandler;
import com.lying.screen.WalkerInventoryScreenHandler;
import com.lying.utility.ServerBus;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1671;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_5575;
import net.minecraft.class_747;

public class WHCPacketHandler {
    public static final class_2960 OPEN_INVENTORY_ID = WHCPacketHandler.make("open_inventory_screen");
    public static final class_2960 FLYING_START_ID = WHCPacketHandler.make("flying_start");
    public static final class_2960 FLYING_ROCKET_ID = WHCPacketHandler.make("flying_rocket");
    public static final class_2960 FORCE_UNPARENT_ID = WHCPacketHandler.make("force_unparent");
    public static final class_2960 AAC_MESSAGE_ID = WHCPacketHandler.make("aac_message");
    public static final class_2960 SET_SEATBELT_ID = WHCPacketHandler.make("set_seatbelt");

    private static class_2960 make(String nameIn) {
        return Reference.ModInfo.prefix(nameIn);
    }

    public static void initServer() {
        Wheelchairs.LOGGER.info(" # Registered server-side packet receivers");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), AACMessagePacket.Payload.Send.PACKET_TYPE, AACMessagePacket.Payload.Send.PACKET_CODEC, (value, context) -> context.getPlayer().method_5682().method_3760().method_14571().forEach(p -> AACMessagePacket.sendToPlayer(p, value)));
        WHCPacketHandler.initKeyHandling();
        WHCPacketHandler.initUpgradeHandling();
    }

    private static void initKeyHandling() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), FlyingMountRocketPacket.PACKET_TYPE, FlyingMountRocketPacket.PACKET_CODEC, (value, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            class_1799 stack = player.method_5998(value.hand());
            if (stack.method_7909() != class_1802.field_8639) {
                return;
            }
            class_1297 vehicle = player.method_5854();
            if (vehicle == null) {
                return;
            }
            if (!(vehicle instanceof class_1309) || !(vehicle instanceof IFlyingMount)) {
                return;
            }
            player.method_5682().execute(() -> {
                class_1792 item = stack.method_7909();
                if (((IFlyingMount)vehicle).canUseRocketNow()) {
                    class_1937 world = player.method_37908();
                    class_1671 rocket = new class_1671(world, stack, (class_1309)vehicle);
                    world.method_8649((class_1297)rocket);
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    player.method_7259(class_3468.field_15372.method_14956((Object)item));
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), StartFlyingPacket.PACKET_TYPE, StartFlyingPacket.PACKET_CODEC, (value, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player.method_5765() && player.method_5854() instanceof IFlyingMount) {
                player.method_5682().execute(() -> ((IFlyingMount)player.method_5854()).startFlying());
            }
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), SetSeatbeltPacket.PACKET_TYPE, SetSeatbeltPacket.PACKET_CODEC, (value, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            UUID id = player.method_5667();
            boolean currentSetting = ServerBus.getSeatbelt(id);
            ServerBus.setSeatbelt(id, value.setting() && player.method_5765());
            if (ServerBus.getSeatbelt(id) != currentSetting) {
                player.method_64398((class_2561)class_2561.method_43471((String)("gui.wheelchairs.seatbelt_" + (!currentSetting ? "on" : "off"))));
            }
        });
    }

    private static void initUpgradeHandling() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), ForceUnparentPacket.PACKET_TYPE, ForceUnparentPacket.PACKET_CODEC, (value, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            player.method_5682().execute(() -> {
                if (player.method_5765() && player.method_5854().method_5864() == WHCEntityTypes.WHEELCHAIR.get() && ((WheelchairEntity)player.method_5854()).hasParent()) {
                    ((WheelchairEntity)player.method_5854()).forceUnbind();
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.c2s(), OpenInventoryScreenPacket.PACKET_TYPE, OpenInventoryScreenPacket.PACKET_CODEC, (value, context) -> {
            class_3222 player = (class_3222)context.getPlayer();
            if (player.method_5765() && player.method_5854().method_5864() == WHCEntityTypes.WHEELCHAIR.get() && ((WheelchairEntity)player.method_5854()).getUpgrades().stream().anyMatch(ChairUpgrade::enablesScreen)) {
                WheelchairEntity vehicle = (WheelchairEntity)player.method_5854();
                MenuRegistry.openMenu((class_3222)player, (class_3908)new class_747((id, playerInventory, custom) -> new ChairInventoryScreenHandler(id, playerInventory, vehicle), vehicle.method_5476()));
                return;
            }
            if (value.openTarget()) {
                UUID uuid = value.entityID();
                player.method_37908().method_18023((class_5575)WHCEntityTypes.WALKER.get(), player.method_5829().method_1014(4.0), WalkerEntity::hasInventory).stream().filter(e -> e.method_5667().equals(uuid)).findFirst().ifPresent(walker -> MenuRegistry.openMenu((class_3222)player, (class_3908)new class_747((id, playerInventory, custom) -> new WalkerInventoryScreenHandler(id, playerInventory, walker.getInventory(), (WalkerEntity)walker), walker.method_5476())));
            }
        });
    }
}

