/*
 * Decompiled with CFR 0.152.
 */
package com.lying.utility;

import com.lying.Wheelchairs;
import com.lying.chairspace.Chairspace;
import com.lying.data.WHCTags;
import com.lying.entity.IParentedEntity;
import com.lying.entity.WalkerEntity;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairspaceConditions;
import com.lying.init.WHCEntityTypes;
import com.lying.item.VestItem;
import com.lying.utility.ServerEvents;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class ServerBus {
    private static final Map<UUID, Boolean> SEATBELT_LOG = new HashMap<UUID, Boolean>();

    public static void toggleSeatbelt(UUID id) {
        ServerBus.setSeatbelt(id, !ServerBus.getSeatbelt(id));
    }

    public static boolean getSeatbelt(UUID id) {
        return SEATBELT_LOG.getOrDefault(id, false);
    }

    public static void setSeatbelt(UUID id, boolean bool) {
        SEATBELT_LOG.put(id, bool);
    }

    public static void registerEventCallbacks() {
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.register((living, next, last) -> Wheelchairs.LOGGER.info("Mount changed: {}, {} -> {}", new Object[]{living.method_5477().getString(), last == null ? "NULL" : last.method_5477().getString(), next == null ? "NULL" : next.method_5477().getString()}));
        ServerBus.registerChairspaceEvents();
        ServerBus.registerMountEvents();
        PlayerEvent.PLAYER_CLONE.register((oldPlayer, newPlayer, oldIsAlive) -> {
            class_1937 world = newPlayer.method_37908();
            if (!world.method_8608() && !((class_3218)world).method_64395().method_8355(class_1928.field_19389)) {
                class_1661 oldInv = oldPlayer.method_31548();
                class_1661 newInv = newPlayer.method_31548();
                for (int i = 0; i < oldInv.method_5439(); ++i) {
                    class_1799 stack = oldInv.method_5438(i);
                    if (stack.method_7960() || !stack.method_31573(WHCTags.PRESERVED)) continue;
                    newInv.method_5447(i, stack.method_7972());
                }
            }
        });
    }

    public static void invokeMountChange(class_1309 living, @Nullable class_1297 nextMount, @Nullable class_1297 lastMount) {
        ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.invoker()).afterChangeMount(living, nextMount, lastMount);
        ((ServerEvents.LivingChangeMount)ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.invoker()).afterChangeMount(living, nextMount, lastMount);
    }

    private static void registerChairspaceEvents() {
        Wheelchairs.LOGGER.info(" # Registered Chairspace event handlers");
        EntityEvent.LIVING_DEATH.register((entity, damage) -> {
            boolean shouldDropContents;
            if (entity.method_5864() != class_1299.field_6097 || entity.method_37908().method_8608()) {
                return EventResult.pass();
            }
            Chairspace chairs = Chairspace.getChairspace(entity.method_5682());
            boolean bl = shouldDropContents = !((class_3218)entity.method_37908()).method_64395().method_8355(class_1928.field_19389);
            if (entity.method_5765() && entity.method_5854().method_5864() == WHCEntityTypes.WHEELCHAIR.get()) {
                class_1297 vehicle = entity.method_5854();
                if (shouldDropContents) {
                    ((WheelchairEntity)vehicle).method_16078((class_3218)vehicle.method_37908());
                }
                chairs.storeEntityInChairspace(vehicle, entity.method_5667(), WHCChairspaceConditions.ON_RESPAWN.get(), Chairspace.Flag.MOUNT);
            }
            entity.method_37908().method_8390(class_1309.class, entity.method_5829().method_1014(6.0), IParentedEntity.isChildOf(entity)).forEach(ent -> {
                if (ent.method_5864() == WHCEntityTypes.WALKER && ((WalkerEntity)ent).hasInventory()) {
                    ((WalkerEntity)ent).method_16078((class_3218)entity.method_37908());
                }
                chairs.storeEntityInChairspace((class_1297)ent, entity.method_5667(), WHCChairspaceConditions.ON_RESPAWN.get(), Chairspace.Flag.PARENT);
            });
            return EventResult.pass();
        });
        PlayerEvent.PLAYER_RESPAWN.register((newPlayer, conqueredEnd, removalReason) -> {
            if (!newPlayer.method_37908().method_8608()) {
                Chairspace.getChairspace(newPlayer.method_5682()).reactToEvent(PlayerEvent.PLAYER_RESPAWN, (class_1297)newPlayer);
            }
        });
        PlayerEvent.PLAYER_QUIT.register(player -> {
            if (player == null || player.method_37908() == null) {
                return;
            }
            boolean isClient = player.method_37908().method_8608();
            Chairspace chairs = Chairspace.getChairspace(player.method_5682());
            IParentedEntity.getParentedEntitiesOf((class_1309)player).forEach(ent -> {
                ((IParentedEntity)ent).clearParent();
                if (ent.method_5782()) {
                    return;
                }
                if (isClient) {
                    ent.method_31472();
                } else {
                    chairs.storeEntityInChairspace((class_1297)ent, player.method_5667(), WHCChairspaceConditions.ON_LOGIN.get(), Chairspace.Flag.PARENT);
                }
            });
        });
        PlayerEvent.PLAYER_JOIN.register(player -> {
            if (player == null || player.method_37908() == null || player.method_37908().method_8608()) {
                return;
            }
            Chairspace.getChairspace(player.method_5682()).reactToEvent(PlayerEvent.PLAYER_JOIN, (class_1297)player);
        });
        ServerEvents.AFTER_PLAYER_CHANGE_GAME_MODE.register((player, mode) -> {
            if (player.method_37908().method_8608()) {
                return;
            }
            Chairspace chairs = Chairspace.getChairspace(player.method_5682());
            if (mode == class_1934.field_9219) {
                if (player.method_5765() && player.method_5854().method_5864() == WHCEntityTypes.WHEELCHAIR.get()) {
                    class_1297 vehicle = player.method_5854();
                    player.method_5848();
                    chairs.storeEntityInChairspace(vehicle, player.method_5667(), WHCChairspaceConditions.ON_LEAVE_SPECTATOR.get(), Chairspace.Flag.MOUNT);
                }
                player.method_37908().method_8390(class_1309.class, player.method_5829().method_1014(6.0), IParentedEntity.isChildOf((class_1309)player)).forEach(ent -> {
                    if (ent.method_5864() == WHCEntityTypes.WALKER.get() && ((WalkerEntity)ent).hasInventory()) {
                        ((WalkerEntity)ent).method_16078((class_3218)ent.method_37908());
                    }
                    chairs.storeEntityInChairspace((class_1297)ent, player.method_5667(), WHCChairspaceConditions.ON_LEAVE_SPECTATOR.get(), Chairspace.Flag.PARENT);
                });
            }
            chairs.reactToEvent(ServerEvents.AFTER_PLAYER_CHANGE_GAME_MODE, (class_1297)player);
        });
        ServerEvents.AFTER_PLAYER_TELEPORT.register(player -> {
            if (!player.method_37908().method_8608()) {
                Chairspace.getChairspace(player.method_5682()).reactToEvent(ServerEvents.AFTER_PLAYER_TELEPORT, (class_1297)player);
            }
        });
        ServerEvents.ON_START_FLYING.register(living -> {
            if (living.method_37908().method_8608()) {
                return;
            }
            Chairspace chairs = Chairspace.getChairspace(living.method_5682());
            living.method_37908().method_18023((class_5575)WHCEntityTypes.WALKER.get(), living.method_5829().method_1014(6.0), IParentedEntity.isChildOf(living)).forEach(ent -> chairs.storeEntityInChairspace((class_1297)ent, living.method_5667(), WHCChairspaceConditions.ON_STOP_FLYING.get(), Chairspace.Flag.PARENT));
        });
        ServerEvents.ON_STOP_FLYING.register(living -> {
            if (!living.method_37908().method_8608()) {
                Chairspace.getChairspace(living.method_5682()).reactToEvent(ServerEvents.ON_STOP_FLYING, (class_1297)living);
            }
        });
        EntityEvent.LIVING_DEATH.register((entity, damageSource) -> {
            if (VestItem.isValidMobForVest((class_1297)entity) && !VestItem.getVest(entity).method_7960()) {
                UUID ownerID = VestItem.getVestedMobOwner((class_1297)entity);
                if (ownerID == null) {
                    return EventResult.pass();
                }
                entity.method_6033(1.0f);
                Chairspace chairs = Chairspace.getChairspace(entity.method_5682());
                chairs.storeEntityInChairspace((class_1297)entity, ownerID, WHCChairspaceConditions.ON_WAKE_UP.get(), new Chairspace.Flag[0]);
                return EventResult.interruptFalse();
            }
            return EventResult.pass();
        });
        ServerEvents.ON_WAKE_UP.register(player -> {
            if (!player.method_37908().method_8608()) {
                Chairspace.getChairspace(player.method_5682()).reactToEvent(ServerEvents.ON_WAKE_UP, (class_1297)player);
            }
        });
    }

    private static void registerMountEvents() {
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_START.register((living, next, last) -> {
            if (last != null && last.method_5864() == WHCEntityTypes.WHEELCHAIR.get()) {
                ((WheelchairEntity)last).getUpgrades().forEach(upg -> upg.onStopRiding(living));
            }
            if (next != null && next.method_5864() == WHCEntityTypes.WHEELCHAIR.get()) {
                ((WheelchairEntity)next).getUpgrades().forEach(upg -> upg.onStartRiding(living));
            }
            IParentedEntity.clearParentedEntities(living, null);
        });
        ServerEvents.AFTER_LIVING_CHANGE_MOUNT_END.register((living, next, last) -> {
            if (last != null && last.method_5864() == WHCEntityTypes.WHEELCHAIR.get() && last.method_5805() && living.method_5864() == class_1299.field_6097) {
                WheelchairEntity chair = (WheelchairEntity)last;
                if (next != null && next.method_5864() != WHCEntityTypes.WHEELCHAIR.get() && (!chair.hasInventory() || chair.getInventory().method_5442())) {
                    chair.convertToItem((class_1657)living);
                }
            }
        });
        ServerEvents.ON_ENTITY_PARENT.register((living, walker) -> IParentedEntity.clearParentedEntities(living, walker));
    }
}

