/*
 * Decompiled with CFR 0.152.
 */
package com.lying.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FrostedLavaBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;

    public FrostedLavaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static BlockState getMeltedState() {
        return Blocks.LAVA.defaultBlockState();
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tick(state, world, pos, random);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if ((random.nextInt(3) == 0 || this.canMelt((BlockGetter)world, pos, 4)) && world.getMaxLocalRawBrightness(pos) > 11 - (Integer)state.getValue((Property)AGE) - state.getLightBlock() && this.increaseAge(state, (Level)world, pos)) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                mutable.setWithOffset((Vec3i)pos, direction);
                BlockState blockState = world.getBlockState((BlockPos)mutable);
                if (!blockState.is((Block)this) || this.increaseAge(blockState, (Level)world, (BlockPos)mutable)) continue;
                world.scheduleTick((BlockPos)mutable, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
            }
            return;
        }
        world.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)random, (int)20, (int)40));
    }

    protected boolean canMelt(BlockGetter world, BlockPos pos, int maxNeighbours) {
        int neighbours = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.values()) {
            mutable.setWithOffset((Vec3i)pos, direction);
            if (!world.getBlockState((BlockPos)mutable).is((Block)this) || ++neighbours < maxNeighbours) continue;
            return false;
        }
        return true;
    }

    protected boolean increaseAge(BlockState state, Level world, BlockPos pos) {
        int i = (Integer)state.getValue((Property)AGE);
        if (i < 3) {
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(++i)), 2);
            return false;
        }
        this.melt(state, world, pos);
        return true;
    }

    protected void melt(BlockState state, Level world, BlockPos pos) {
        world.setBlockAndUpdate(pos, FrostedLavaBlock.getMeltedState());
        world.neighborChanged(pos, FrostedLavaBlock.getMeltedState().getBlock(), null);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.playerDestroy(world, player, pos, state, blockEntity, tool);
        world.setBlockAndUpdate(pos, FrostedLavaBlock.getMeltedState());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }
}

