/*
 * Decompiled with CFR 0.152.
 */
package com.lying.chairspace;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.chairspace.ChairspaceCondition;
import com.lying.entity.IParentedEntity;
import com.lying.init.WHCChairspaceConditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.Event;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class Chairspace
extends SavedData {
    public static final String ID = "chairspace";
    public static final SavedData.Factory<Chairspace> TYPE = new SavedData.Factory(Chairspace::new, Chairspace::createFromNbt, null);
    private List<PlayerStorage> storage = Lists.newArrayList();

    public static Chairspace getChairspace(MinecraftServer server) {
        ServerLevel world = server.getLevel(Level.OVERWORLD);
        DimensionDataStorage manager = world.getDataStorage();
        Chairspace chairs = (Chairspace)manager.computeIfAbsent(TYPE, ID);
        chairs.setDirty();
        return chairs;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookup) {
        this.storage.removeIf(PlayerStorage::isEmpty);
        nbt.put("Data", (Tag)PlayerStorage.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.storage).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).get());
        return nbt;
    }

    public static Chairspace createFromNbt(CompoundTag nbt, HolderLookup.Provider lookup) {
        Chairspace chairs = new Chairspace();
        chairs.storage.clear();
        chairs.storage.addAll((Collection)PlayerStorage.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("Data")).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow());
        return chairs;
    }

    public boolean hasEntityFor(UUID ownerID) {
        return this.storage.stream().anyMatch(s -> s.playerID().equals(ownerID) && !s.isEmpty());
    }

    public void storeEntityInChairspace(Entity ent, UUID ownerID, ChairspaceCondition condition, Flag ... flags) {
        if (ent == null || ent.level().isClientSide()) {
            return;
        }
        RespawnData entry = RespawnData.of(ent, flags);
        Predicate<PlayerStorage> predicate = s -> s.playerID().equals(ownerID);
        if (this.storage.stream().anyMatch(predicate)) {
            this.storage.stream().filter(predicate).forEach(s -> s.add(condition, entry));
        } else {
            this.storage.add(new PlayerStorage(ownerID).add(condition, entry));
        }
        ent.discard();
        this.setDirty();
        Wheelchairs.LOGGER.info(" # Stored entity {} in Chairspace with condition {} by {}", new Object[]{ent.getName().getString(), condition.registryName().toString(), ownerID.toString()});
    }

    public void reactToEvent(Event<?> eventIn, Entity owner) {
        WHCChairspaceConditions.getApplicable(eventIn).forEach(condition -> this.respawnForCondition(owner.getUUID(), owner, (ChairspaceCondition)condition));
    }

    public void respawnForCondition(UUID ownerID, Entity owner, ChairspaceCondition condition) {
        if (owner == null || owner.isSpectator() || owner.level() == null || owner.level().isClientSide() || !this.hasEntityFor(owner.getUUID()) || !condition.isApplicable(owner)) {
            return;
        }
        ServerLevel world = (ServerLevel)owner.level();
        List<PlayerStorage> wares = this.storage.stream().filter(s -> s.playerID().equals(ownerID)).toList();
        for (PlayerStorage w : wares) {
            if (!w.respawnFor(condition, owner, world)) continue;
            this.setDirty();
        }
        this.storage.removeIf(PlayerStorage::isEmpty);
    }

    private static class PlayerStorage {
        public static final Codec<PlayerStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(p -> p.playerID().toString()), (App)ConditionEntry.CODEC.listOf().fieldOf("entries").forGetter(p -> p.entries)).apply((Applicative)instance, (id, entries) -> {
            PlayerStorage storage = new PlayerStorage(UUID.fromString(id));
            entries.forEach(storage::add);
            return storage;
        }));
        public static final Codec<List<PlayerStorage>> LIST_CODEC = CODEC.listOf();
        private final UUID playerID;
        private final List<ConditionEntry> entries = Lists.newArrayList();

        public PlayerStorage(UUID idIn) {
            this.playerID = idIn;
        }

        public boolean equals(Object obj) {
            return obj instanceof PlayerStorage && ((PlayerStorage)obj).playerID().equals(this.playerID);
        }

        public UUID playerID() {
            return this.playerID;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty() || this.entries.stream().allMatch(ConditionEntry::isEmpty);
        }

        public PlayerStorage add(ConditionEntry entry) {
            if (this.entries.stream().noneMatch(e -> e.equals(entry))) {
                this.entries.add(entry);
            } else {
                this.entries.stream().filter(e -> e.equals(entry)).findFirst().ifPresent(e -> e.add(entry));
            }
            return this;
        }

        public PlayerStorage add(ChairspaceCondition condition, RespawnData data) {
            Predicate<ConditionEntry> predicate = ConditionEntry.matching(condition);
            if (this.entries.stream().noneMatch(predicate)) {
                this.entries.add(new ConditionEntry(condition).add(data));
            } else {
                this.entries.stream().filter(predicate).findFirst().ifPresent(e -> e.add(data));
            }
            return this;
        }

        public boolean respawnFor(ChairspaceCondition condition, Entity owner, ServerLevel world) {
            Predicate<ConditionEntry> predicate = ConditionEntry.matching(condition);
            if (this.entries.stream().anyMatch(predicate)) {
                this.entries.stream().filter(predicate).forEach(entry -> entry.respawn(owner, world));
                this.entries.removeIf(e -> e.matches(condition));
                return true;
            }
            return false;
        }

        private static class ConditionEntry {
            public static final Codec<ConditionEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ChairspaceCondition.CODEC.fieldOf("condition").forGetter(ConditionEntry::condition), (App)RespawnData.CODEC.listOf().fieldOf("objects").forGetter(ConditionEntry::entries)).apply((Applicative)instance, (condition, entries) -> {
                ConditionEntry entry = new ConditionEntry((ChairspaceCondition)condition);
                entries.forEach(entry::add);
                return entry;
            }));
            private final ChairspaceCondition condition;
            private final List<RespawnData> entries = Lists.newArrayList();

            public static Predicate<ConditionEntry> matching(ChairspaceCondition c) {
                return a -> a.matches(c);
            }

            public ConditionEntry(ChairspaceCondition conditionIn) {
                this.condition = conditionIn;
            }

            public boolean equals(Object obj) {
                return obj instanceof ConditionEntry && this.matches(((ConditionEntry)obj).condition());
            }

            public boolean matches(ChairspaceCondition cond) {
                return cond.equals(this.condition);
            }

            public ChairspaceCondition condition() {
                return this.condition;
            }

            public List<RespawnData> entries() {
                return this.entries;
            }

            public boolean isEmpty() {
                return this.entries.isEmpty();
            }

            public ConditionEntry add(RespawnData data) {
                this.entries.add(data);
                return this;
            }

            public ConditionEntry add(ConditionEntry other) {
                if (other.condition().equals(this.condition)) {
                    this.entries.addAll(this.entries);
                }
                return this;
            }

            public void respawn(Entity owner, ServerLevel world) {
                Wheelchairs.LOGGER.info(" # Respawning {} entities from Chairspace for {} under condition {}", new Object[]{this.entries.size(), owner.getUUID().toString(), this.condition.registryName().toString()});
                this.entries.forEach(entry -> this.condition.applyPostEffects(entry.respawn(owner, world)));
                this.entries.clear();
            }
        }
    }

    public record RespawnData(CompoundTag entityData, EnumSet<Flag> flags) {
        public static final Codec<RespawnData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CompoundTag.CODEC.fieldOf("Entity").forGetter(r -> r.entityData()), (App)SerializedFlagSet.CODEC.fieldOf("Flags").forGetter(r -> r.flags)).apply((Applicative)instance, RespawnData::new));

        public static RespawnData of(Entity entity, Flag ... flagsIn) {
            CompoundTag data = new CompoundTag();
            entity.save(data);
            EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
            for (Flag flag : flagsIn) {
                flags.add(flag);
            }
            return new RespawnData(data, flags);
        }

        @Nullable
        public Entity respawn(Entity owner, ServerLevel world) {
            Entity storedEntity = EntityType.loadEntityRecursive((CompoundTag)this.entityData(), (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> {
                entity.moveTo(owner.getX(), owner.getY(), owner.getZ(), owner.getYRot(), owner.getXRot());
                return entity;
            });
            if (storedEntity != null) {
                Wheelchairs.LOGGER.info(" # - Restored entity {}", (Object)storedEntity.getName().getString());
                world.addFreshEntity(storedEntity);
                this.flags().stream().forEach(f -> f.postRespawnAction.accept(owner, storedEntity));
            }
            return storedEntity;
        }

        private static class SerializedFlagSet {
            private static final Codec<EnumSet<Flag>> CODEC = Codec.of(SerializedFlagSet::encode, SerializedFlagSet::decode);

            private SerializedFlagSet() {
            }

            private static <T> DataResult<T> encode(EnumSet<Flag> set, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createList(set.stream().map(d -> ops.createString(d.getSerializedName()))));
            }

            private static <T> DataResult<Pair<EnumSet<Flag>, T>> decode(DynamicOps<T> ops, T input) {
                EnumSet<Flag> set = EnumSet.noneOf(Flag.class);
                set.addAll(ops.getStream(input).result().orElse(Stream.empty()).map(e -> Flag.get((String)ops.getStringValue(e).getOrThrow())).toList());
                return DataResult.success((Object)Pair.of(set, input));
            }
        }
    }

    public static enum Flag implements StringRepresentable
    {
        MOUNT((owner, entity) -> {
            if (!owner.isPassenger()) {
                owner.startRiding(entity);
            }
        }),
        PARENT((owner, entity) -> {
            LivingEntity parent = (LivingEntity)owner;
            IParentedEntity child = (IParentedEntity)entity;
            Vec3 offset = child.getParentOffset(parent, parent.getYRot(), parent.getXRot());
            entity.absMoveTo(parent.getX() + offset.x(), parent.getY() + offset.y(), parent.getZ() + offset.y());
            child.parentTo(parent);
        });

        private final BiConsumer<Entity, Entity> postRespawnAction;

        private Flag(BiConsumer<Entity, Entity> consumerIn) {
            this.postRespawnAction = consumerIn;
        }

        public String getSerializedName() {
            return this.name().toString();
        }

        @Nullable
        public static Flag get(String nameIn) {
            for (Flag flag : Flag.values()) {
                if (!flag.name().equals(nameIn)) continue;
                return flag;
            }
            return null;
        }
    }
}

