/*
 * Decompiled with CFR 0.152.
 */
package com.lying.chairspace;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.init.WHCChairspaceConditions;
import com.lying.reference.Reference;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.event.Event;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.function.Consumers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChairspaceCondition {
    public static final Codec<ChairspaceCondition> CODEC = Codec.of(ChairspaceCondition::encodeToOps, ChairspaceCondition::decodeFromOps);
    private final ResourceLocation registryName;
    private final List<Event<?>> firedBy = Lists.newArrayList();
    private final Predicate<Entity> canApplyTo;
    private final Consumer<Entity> postEffect;

    private static <T> DataResult<T> encodeToOps(ChairspaceCondition func, DynamicOps<T> ops, T prefix) {
        return DataResult.success((Object)ops.createString(func.registryName.toString()));
    }

    private static <T> DataResult<Pair<ChairspaceCondition, T>> decodeFromOps(DynamicOps<T> ops, T input) {
        ChairspaceCondition condition = WHCChairspaceConditions.get(ResourceLocation.parse((String)((String)ops.getStringValue(input).getOrThrow())));
        return condition == null ? DataResult.error(() -> "Error reading Chairspace condition from data") : DataResult.success((Object)Pair.of((Object)condition, input));
    }

    private ChairspaceCondition(ResourceLocation nameIn, Predicate<Entity> qualifierIn, Consumer<Entity> postIn, Event<?> ... events) {
        this.registryName = nameIn;
        this.canApplyTo = qualifierIn;
        this.postEffect = postIn;
        for (Event<?> event : events) {
            this.firedBy.add(event);
        }
    }

    public <T> T encode(DynamicOps<T> ops) {
        return CODEC.encodeStart(ops, (Object)this).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> ChairspaceCondition decode(DynamicOps<T> ops, T input) {
        return (ChairspaceCondition)CODEC.parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public ResourceLocation registryName() {
        return this.registryName;
    }

    public boolean equals(Object obj) {
        return obj instanceof ChairspaceCondition && ((ChairspaceCondition)obj).registryName.equals((Object)this.registryName);
    }

    public boolean isListeningTo(Event<?> event) {
        return this.firedBy.contains(event);
    }

    public boolean isApplicable(@NotNull Entity entity) {
        return this.canApplyTo.test(entity);
    }

    public void applyPostEffects(@Nullable Entity entity) {
        if (entity != null) {
            this.postEffect.accept(entity);
        }
    }

    public static class Builder {
        private final ResourceLocation regName;
        private List<Event<?>> firedBy = Lists.newArrayList();
        private Predicate<Entity> canApplyTo = entity -> entity.isAlive();
        private Consumer<Entity> postEffect = Consumers.nop();

        private Builder(ResourceLocation regNameIn) {
            this.regName = regNameIn;
        }

        public static Builder of(String nameIn) {
            return new Builder(Reference.ModInfo.prefix(nameIn));
        }

        public static Builder of(String nameIn, Event<?> event) {
            return Builder.of(nameIn).listen(event);
        }

        public Builder condition(Predicate<Entity> conditionIn) {
            this.canApplyTo = conditionIn.and(this.canApplyTo);
            return this;
        }

        public Builder postEffect(Consumer<Entity> postIn) {
            this.postEffect = postIn;
            return this;
        }

        public Builder listen(Event<?> ... eventIn) {
            for (Event<?> event : eventIn) {
                this.firedBy.add(event);
            }
            return this;
        }

        public ChairspaceCondition build() {
            return new ChairspaceCondition(this.regName, this.canApplyTo, this.postEffect, this.firedBy.toArray(new Event[0]));
        }
    }
}

