/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client;

import com.lying.Wheelchairs;
import com.lying.client.config.ClientConfig;
import com.lying.client.init.WHCKeybinds;
import com.lying.client.init.WHCModelParts;
import com.lying.client.renderer.entity.feature.CatVestLayer;
import com.lying.client.renderer.entity.feature.FoxVestLayer;
import com.lying.client.renderer.entity.feature.ParrotVestLayer;
import com.lying.client.renderer.entity.feature.WolfVestLayer;
import com.lying.client.screen.AACScreen;
import com.lying.client.utility.AACLibrary;
import com.lying.client.utility.ClientBus;
import com.lying.init.WHCBlocks;
import com.lying.init.WHCSoundEvents;
import com.lying.network.AACMessagePacket;
import com.lying.network.OpenInventoryScreenPacket;
import com.lying.network.SetSeatbeltPacket;
import com.lying.reference.Reference;
import com.mojang.text2speech.Narrator;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.client.renderer.entity.state.FoxRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.ParrotRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;

public class WheelchairsClient {
    public static final Minecraft mc = Minecraft.getInstance();
    public static ClientConfig config;
    public static boolean SEATBELT_ON;
    public static boolean wasSeatbeltPressed;
    public static int loginState;

    public static void clientInit() {
        Wheelchairs.openAACScreen = (player, stack) -> mc.setScreen((Screen)new AACScreen(stack.getHoverName()));
        config = new ClientConfig(WheelchairsClient.mc.gameDirectory.getAbsolutePath() + "/config/WheelchairsClient.cfg");
        config.read();
        Wheelchairs.LOGGER.info("Reading Wheelchairs client config:");
        Wheelchairs.LOGGER.info(" * Seatbelt login setting: " + config.seatbeltAtBoot());
        Wheelchairs.LOGGER.info(" * AAC proximity narration: " + config.shouldNarrateAAC());
        AACLibrary.init();
        ClientBus.registerEventCallbacks();
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)WHCBlocks.FROSTED_LAVA.get()});
        WHCModelParts.init((layer, definition) -> EntityModelLayerRegistry.register((ModelLayerLocation)layer, (Supplier)definition));
        WheelchairsClient.registerEventCallbacks();
        WheelchairsClient.registerS2CPacketReceivers();
    }

    public static void registerEventCallbacks() {
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(player -> {
            loginState = -1;
        });
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(player -> ++loginState);
        ClientTickEvent.CLIENT_PRE.register(client -> {
            LocalPlayer player = WheelchairsClient.mc.player;
            if (loginState == 0 && WheelchairsClient.mc.player != null) {
                boolean bl = SEATBELT_ON = config.seatbeltAtBoot() && player.isPassenger();
                if (config.seatbeltAtBoot()) {
                    WheelchairsClient.mc.gui.getChat().addMessage((Component)Component.translatable((String)("gui.wheelchairs.seatbelt_" + (SEATBELT_ON ? "on" : "off"))));
                }
                ++loginState;
            }
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            LocalPlayer player = WheelchairsClient.mc.player;
            if (player != null) {
                while (WHCKeybinds.keyOpenChair.consumeClick()) {
                    OpenInventoryScreenPacket.send(WheelchairsClient.mc.crosshairPickEntity != null ? WheelchairsClient.mc.crosshairPickEntity.getUUID() : null);
                }
                if (WHCKeybinds.keySeatbelt.consumeClick() && !wasSeatbeltPressed && player.isPassenger()) {
                    SEATBELT_ON = !SEATBELT_ON;
                    SetSeatbeltPacket.send(SEATBELT_ON);
                    player.playSound(SEATBELT_ON ? (SoundEvent)WHCSoundEvents.SEATBELT_ON.get() : (SoundEvent)WHCSoundEvents.SEATBELT_OFF.get(), 1.0f, 0.5f + player.getRandom().nextFloat() * 0.5f);
                    wasSeatbeltPressed = true;
                } else {
                    wasSeatbeltPressed = false;
                }
            }
        });
    }

    private static void registerS2CPacketReceivers() {
        Wheelchairs.LOGGER.info(" # Registered client-side packet receivers");
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.s2c(), AACMessagePacket.Payload.Receive.PACKET_TYPE, AACMessagePacket.Payload.Receive.PACKET_CODEC, (value, context) -> {
            if (WheelchairsClient.mc.options.chatVisibility().get() != ChatVisiblity.FULL) {
                return;
            }
            MutableComponent text = value.message().copy().withStyle(style -> style.withClickEvent(null));
            Player sender = context.getPlayer().level().getPlayerByUUID(value.playerID());
            MutableComponent senderName = (sender == null ? value.playerName() : sender.getDisplayName()).copy();
            MutableComponent message = Reference.ModInfo.translate("aac", "message", senderName, text).copy();
            WheelchairsClient.mc.gui.getChat().addMessage((Component)message);
            if (config.shouldNarrateAAC() && sender != WheelchairsClient.mc.player && sender != null && (double)WheelchairsClient.mc.player.distanceTo((Entity)sender) < 16.0) {
                Narrator narrator = Narrator.getNarrator();
                narrator.clear();
                narrator.say(text.getString(), true);
            }
        });
    }

    public static <T extends LivingEntity, C extends LivingEntityRenderState, M extends EntityModel<C>> RenderLayer<C, M> getVestFeatureForType(EntityType<T> entityType, LivingEntityRenderer<T, C, M> renderer) {
        if (entityType == EntityType.WOLF) {
            return new WolfVestLayer((RenderLayerParent<WolfRenderState, WolfModel>)renderer);
        }
        if (entityType == EntityType.CAT) {
            return new CatVestLayer((RenderLayerParent<CatRenderState, CatModel>)renderer);
        }
        if (entityType == EntityType.PARROT) {
            return new ParrotVestLayer((RenderLayerParent<ParrotRenderState, ParrotModel>)renderer);
        }
        if (entityType == EntityType.FOX) {
            return new FoxVestLayer((RenderLayerParent<FoxRenderState, FoxModel>)renderer);
        }
        return null;
    }

    static {
        SEATBELT_ON = false;
        wasSeatbeltPressed = false;
        loginState = -1;
    }
}

