/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.init;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.lying.init.WHCItems;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.Nullable;

public class WHCItemsClient {
    private static final List<ExtraModelHandler> EXTRA_MODELS = Lists.newArrayList();

    private static void addExtraCrutchModel(RegistrySupplier<Item> item) {
        EXTRA_MODELS.add(new ExtraModelHandler(item, "_in_hand", (Predicate<ItemDisplayContext>)((Predicate)WHCItemsClient::onPerson)));
    }

    private static void addExtraCaneModel(RegistrySupplier<Item> item) {
        EXTRA_MODELS.add(new ExtraModelHandler(item, "_in_gui", (Predicate<ItemDisplayContext>)((Predicate)WHCItemsClient::inGUI)));
    }

    private static boolean onPerson(ItemDisplayContext mode) {
        return mode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || mode == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    private static boolean inGUI(ItemDisplayContext mode) {
        return mode == ItemDisplayContext.FIXED || mode == ItemDisplayContext.GUI || mode == ItemDisplayContext.GROUND || mode == ItemDisplayContext.NONE;
    }

    public static List<ResourceLocation> getExtraModelsToRegister() {
        return EXTRA_MODELS.stream().filter(ExtraModelHandler::needsRegistration).map(ExtraModelHandler::model).toList();
    }

    @Nullable
    public static ResourceLocation getExtraModelIfAny(Item item, ItemDisplayContext mode) {
        for (ExtraModelHandler handler : EXTRA_MODELS) {
            if (!handler.shouldApply(item, mode)) continue;
            return handler.model();
        }
        return null;
    }

    static {
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_ACACIA);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_BAMBOO);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_BIRCH);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_CHERRY);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_CRIMSON);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_DARK_OAK);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_JUNGLE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_MANGROVE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_OAK);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_SPRUCE);
        WHCItemsClient.addExtraCrutchModel(WHCItems.CRUTCH_WARPED);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_ACACIA);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_BAMBOO);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_BIRCH);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_CHERRY);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_CRIMSON);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_DARK_OAK);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_JUNGLE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_MANGROVE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_OAK);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_SPRUCE);
        WHCItemsClient.addExtraCaneModel(WHCItems.CANE_WARPED);
    }

    public static class ExtraModelHandler {
        private final RegistrySupplier<Item> item;
        private final Predicate<ItemDisplayContext> qualifier;
        private final String suffix;
        private Optional<ResourceLocation> model = Optional.empty();
        private final boolean shouldRegister;

        public ExtraModelHandler(RegistrySupplier<Item> itemIn, String suffixIn, Predicate<ItemDisplayContext> qualifierIn) {
            this(itemIn, suffixIn, qualifierIn, true);
        }

        public ExtraModelHandler(RegistrySupplier<Item> itemIn, String suffixIn, Predicate<ItemDisplayContext> qualifierIn, boolean shouldRegisterIn) {
            this.item = itemIn;
            this.qualifier = qualifierIn;
            this.suffix = suffixIn;
            this.shouldRegister = shouldRegisterIn;
        }

        public boolean needsRegistration() {
            return this.shouldRegister;
        }

        public boolean shouldApply(Item itemIn, ItemDisplayContext mode) {
            return itemIn == this.item.get() && this.qualifier.apply((Object)mode);
        }

        public ResourceLocation model() {
            if (this.model.isPresent()) {
                return this.model.get();
            }
            ResourceLocation itemID = this.item.getId();
            ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)itemID.getNamespace(), (String)(itemID.getPath() + this.suffix));
            this.model = Optional.of(id);
            return id;
        }
    }
}

