/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.lying.client.renderer.entity.state.StoolEntityRenderState;
import com.lying.entity.StoolEntity;
import com.lying.init.WHCItems;
import com.lying.reference.Reference;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;

public class StoolEntityRenderer
extends EntityRenderer<StoolEntity, StoolEntityRenderState> {
    private static final ModelResourceLocation MODEL = new ModelResourceLocation(Reference.ModInfo.prefix("wheeled_stool"), "");
    private final ItemRenderer renderItem = Minecraft.getInstance().getItemRenderer();
    private final BlockRenderDispatcher blockRenderManager;

    public StoolEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderManager = context.getBlockRenderDispatcher();
    }

    public StoolEntityRenderState createRenderState() {
        return new StoolEntityRenderState();
    }

    protected boolean hasLabel(StoolEntity entity, double squaredDistanceToCamera) {
        return false;
    }

    public void updateRenderState(StoolEntity entity, StoolEntityRenderState state, float tickDelta) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, tickDelta);
        state.world = entity.level();
        state.partialTick = tickDelta;
        state.entityId = entity.getId();
        state.bodyRot = Mth.rotLerp((float)tickDelta, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        state.color = entity.getColor();
        state.spin = entity.spin;
        state.casterWheelYaw = entity::casterWheelYaw;
    }

    public void render(StoolEntityRenderState state, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - state.bodyRot));
        int color = state.color;
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        ModelManager bakedModelManager = this.blockRenderManager.getBlockModelShaper().getModelManager();
        ModelBlockRenderer modelRenderer = this.blockRenderManager.getModelRenderer();
        matrices.pushPose();
        matrices.translate(-0.5f, 0.0f, -0.5f);
        modelRenderer.renderModel(matrices.last(), vertexConsumers.getBuffer(Sheets.cutoutBlockSheet()), null, bakedModelManager.getModel(MODEL), r, g, b, light, OverlayTexture.NO_OVERLAY);
        matrices.popPose();
        this.renderWheels(matrices, vertexConsumers, light, state.spin, state.casterWheelYaw.apply(Float.valueOf(state.partialTick)).floatValue(), state.bodyRot, state.world, state.entityId);
        matrices.popPose();
    }

    private void renderWheels(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, float spin, float yaw, float frameYaw, Level world, int seed) {
        matrices.pushPose();
        matrices.translate(0.0, 0.1, 0.0);
        matrices.pushPose();
        matrices.translate(0.275, 0.0, 0.0);
        this.renderWheel(matrices, renderTypeBuffer, light, spin, yaw, frameYaw, world, seed);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(-0.275, 0.0, 0.0);
        this.renderWheel(matrices, renderTypeBuffer, light, spin, yaw, frameYaw, world, seed);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0, 0.0, 0.275);
        this.renderWheel(matrices, renderTypeBuffer, light, spin, yaw, frameYaw, world, seed);
        matrices.popPose();
        matrices.pushPose();
        matrices.translate(0.0, 0.0, -0.275);
        this.renderWheel(matrices, renderTypeBuffer, light, spin, yaw, frameYaw, world, seed);
        matrices.popPose();
        matrices.popPose();
    }

    private void renderWheel(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, float spin, float yaw, float frameYaw, Level world, int seed) {
        float scale = 0.2f;
        float thickness = 3.0f;
        matrices.pushPose();
        matrices.mulPose(Axis.YN.rotationDegrees(frameYaw));
        matrices.mulPose(Axis.YP.rotationDegrees(yaw));
        matrices.mulPose(Axis.ZP.rotationDegrees(-spin));
        matrices.pushPose();
        matrices.scale(scale, scale, scale * thickness);
        this.renderItem.renderStatic(((Item)WHCItems.WHEEL_IRON.get()).getDefaultInstance(), ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
    }
}

