/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.google.common.collect.Lists;
import com.lying.client.renderer.entity.feature.EntityFeatureRenderer;
import com.lying.client.renderer.entity.state.WalkerEntityRenderState;
import com.lying.entity.WalkerEntity;
import com.lying.item.WalkerItem;
import com.lying.reference.Reference;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WalkerEntityRenderer
extends EntityRenderer<WalkerEntity, WalkerEntityRenderState> {
    protected static final Minecraft mc = Minecraft.getInstance();
    private static final ModelResourceLocation CHEST_MODEL = new ModelResourceLocation(Reference.ModInfo.prefix("walker_chest"), "");
    private static final double xOffset = 0.325;
    protected final ItemRenderer renderItem = Minecraft.getInstance().getItemRenderer();
    protected final BlockRenderDispatcher blockRenderManager;
    private final List<EntityFeatureRenderer<WalkerEntityRenderState>> featureRenderers = Lists.newArrayList();

    public WalkerEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderManager = context.getBlockRenderDispatcher();
    }

    public WalkerEntityRenderState createRenderState() {
        return new WalkerEntityRenderState();
    }

    public ResourceLocation getTexture(WalkerEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void updateRenderState(WalkerEntity entity, WalkerEntityRenderState state, float tickDelta) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, tickDelta);
        state.bodyRot = Mth.rotLerp((float)tickDelta, (float)entity.yBodyRotO, (float)entity.yBodyRot);
        state.frame = entity.getFrame();
        state.leftWheel = entity.getLeftWheel();
        state.rightWheel = entity.getRightWheel();
        state.spinLeft = entity.spinLeft;
        state.spinRight = entity.spinRight;
        state.hasInventory = entity.hasInventory();
        state.hasParent = entity.hasParent();
        state.velocity = entity.getDeltaMovement();
        state.casterWheelYaw = entity::casterWheelYaw;
    }

    public void render(WalkerEntityRenderState state, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        ItemStack frame;
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - state.bodyRot));
        ModelManager bakedModelManager = this.blockRenderManager.getBlockModelShaper().getModelManager();
        ModelBlockRenderer modelRenderer = this.blockRenderManager.getModelRenderer();
        if (state.hasInventory) {
            matrices.pushPose();
            matrices.translate(-0.5f, 0.0f, -0.5f);
            modelRenderer.renderModel(matrices.last(), vertexConsumers.getBuffer(Sheets.cutoutBlockSheet()), null, bakedModelManager.getModel(CHEST_MODEL), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
        if ((frame = state.frame).getItem() instanceof WalkerItem) {
            matrices.pushPose();
            matrices.translate(-0.5f, 0.0f, -0.5f);
            modelRenderer.renderModel(matrices.last(), vertexConsumers.getBuffer(Sheets.cutoutBlockSheet()), null, bakedModelManager.getModel(WalkerEntityRenderer.walkerModel(frame.getItem())), 1.0f, 1.0f, 1.0f, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
        this.renderWheels(matrices, vertexConsumers, light, state.leftWheel, state.spinLeft, state.rightWheel, state.spinRight, state.bodyRot, state.casterWheelYaw.apply(Float.valueOf(state.partialTick)).floatValue(), state.world, state.entityId);
        this.featureRenderers.stream().filter(f -> f.shouldRender(state)).forEach(feature -> feature.render(matrices, vertexConsumers, light, state, state.partialTick));
        matrices.popPose();
    }

    private void renderWheels(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, ItemStack left, float leftSpin, ItemStack right, float rightSpin, float frameYaw, float casterYaw, Level world, int seed) {
        this.renderFrontWheels(matrices, renderTypeBuffer, light, frameYaw, casterYaw, left, right, leftSpin, rightSpin, 0.325, -0.15, 0.25, world, seed);
        this.renderRearWheels(matrices, renderTypeBuffer, light, left, right, leftSpin, rightSpin, 0.325, -0.1, -0.325, world, seed);
    }

    private void renderFrontWheels(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, float frameYaw, float yaw, ItemStack left, ItemStack right, float leftSpin, float rightSpin, double xOffset, double yOffset, double zOffset, Level world, int seed) {
        float scale = 0.3f;
        float thickness = 3.0f;
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(xOffset, yOffset, zOffset);
        matrices.pushPose();
        matrices.mulPose(Axis.YN.rotationDegrees(frameYaw));
        matrices.mulPose(Axis.YP.rotationDegrees(yaw));
        matrices.mulPose(Axis.ZP.rotationDegrees(-rightSpin));
        matrices.pushPose();
        matrices.scale(scale, scale, scale * thickness);
        this.renderItem.renderStatic(right, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
        matrices.popPose();
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(-xOffset, yOffset, zOffset);
        matrices.pushPose();
        matrices.mulPose(Axis.YN.rotationDegrees(frameYaw));
        matrices.mulPose(Axis.YP.rotationDegrees(yaw));
        matrices.mulPose(Axis.ZP.rotationDegrees(-leftSpin));
        matrices.pushPose();
        matrices.scale(scale, scale, scale * thickness);
        this.renderItem.renderStatic(left, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
        matrices.popPose();
    }

    private void renderRearWheels(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, ItemStack left, ItemStack right, float leftSpin, float rightSpin, double xOffset, double yOffset, double zOffset, Level world, int seed) {
        float scale = 0.2f;
        float thickness = 3.0f;
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(xOffset, yOffset, zOffset);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(-rightSpin));
        matrices.pushPose();
        matrices.scale(scale, scale, scale * thickness);
        this.renderItem.renderStatic(right, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
        matrices.popPose();
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(-xOffset, yOffset, zOffset);
        matrices.pushPose();
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(-leftSpin));
        matrices.pushPose();
        matrices.scale(scale, scale, scale * thickness);
        this.renderItem.renderStatic(left, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
        matrices.popPose();
    }

    public static ModelResourceLocation walkerModel(Item chairIn) {
        return new ModelResourceLocation(BuiltInRegistries.ITEM.getKey((Object)chairIn), "");
    }
}

