/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.lying.client.renderer.entity.WheelchairsRideableEntityRenderer;
import com.lying.client.renderer.entity.feature.WheelchairElytraFeatureRenderer;
import com.lying.client.renderer.entity.state.WheelchairEntityRenderState;
import com.lying.entity.WheelchairEntity;
import com.lying.item.WheelchairItem;
import com.lying.reference.Reference;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class WheelchairEntityRenderer
extends WheelchairsRideableEntityRenderer<WheelchairEntity, WheelchairEntityRenderState> {
    public WheelchairEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.addFeature(new WheelchairElytraFeatureRenderer(context));
    }

    public WheelchairEntityRenderState createRenderState() {
        return new WheelchairEntityRenderState();
    }

    public ResourceLocation getTexture(WheelchairEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    @Override
    public void updateRenderState(WheelchairEntity entity, WheelchairEntityRenderState state, float tickDelta) {
        super.updateRenderState(entity, state, tickDelta);
        state.chair = entity.getChair();
        state.leftWheel = entity.getLeftWheel();
        state.rightWheel = entity.getRightWheel();
        state.color = entity.getColor();
        state.spinLeft = entity.spinLeft;
        state.spinRight = entity.spinRight;
        state.upgrades = entity.getUpgrades();
        state.hasParent = entity.hasParent();
        state.isFlying = entity.isFlying();
        state.isGliding = entity.isFallFlying();
        state.velocity = entity.getDeltaMovement();
        state.rider = entity.isVehicle() && entity.getFirstPassenger() instanceof LivingEntity ? Optional.of((LivingEntity)entity.getFirstPassenger()) : Optional.empty();
    }

    public void render(WheelchairEntityRenderState state, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.pushPose();
        float h = 0.0f;
        h = state.hasParent ? state.yRot : state.bodyRot;
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - h));
        int color = state.color;
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        ModelManager bakedModelManager = this.blockRenderManager.getBlockModelShaper().getModelManager();
        ModelBlockRenderer modelRenderer = this.blockRenderManager.getModelRenderer();
        state.upgrades.forEach(upgrade -> {
            if (!upgrade.hasModel()) {
                return;
            }
            matrices.pushPose();
            matrices.translate(-0.5f, 0.0f, -0.5f);
            modelRenderer.renderModel(matrices.last(), vertexConsumers.getBuffer(Sheets.cutoutBlockSheet()), null, bakedModelManager.getModel(WheelchairEntityRenderer.upgradeModel(upgrade.registryName())), r, g, b, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        });
        ItemStack chair = state.chair;
        if (chair.getItem() instanceof WheelchairItem) {
            matrices.pushPose();
            matrices.translate(-0.5f, 0.0f, -0.5f);
            modelRenderer.renderModel(matrices.last(), vertexConsumers.getBuffer(Sheets.cutoutBlockSheet()), null, bakedModelManager.getModel(WheelchairEntityRenderer.seatModel(chair.getItem())), r, g, b, light, OverlayTexture.NO_OVERLAY);
            matrices.popPose();
        }
        this.renderWheels(matrices, vertexConsumers, light, state.leftWheel, state.spinLeft, state.rightWheel, state.spinRight, state.world, state.entityId);
        this.renderFeatures(state, matrices, vertexConsumers, light);
        matrices.popPose();
    }

    private void renderWheels(PoseStack matrices, MultiBufferSource renderTypeBuffer, int light, ItemStack left, float leftSpin, ItemStack right, float rightSpin, Level world, int seed) {
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(0.4, -0.5, 0.0);
        matrices.pushPose();
        matrices.scale(1.0f, 1.0f, 1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(10.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(-rightSpin));
        this.renderItem.renderStatic(right, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
        matrices.pushPose();
        matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
        matrices.translate(-0.4, -0.5, 0.0);
        matrices.pushPose();
        matrices.scale(1.0f, 1.0f, 1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(-10.0f));
        matrices.mulPose(Axis.ZP.rotationDegrees(-leftSpin));
        this.renderItem.renderStatic(left, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, matrices, renderTypeBuffer, world, seed);
        matrices.popPose();
        matrices.popPose();
    }

    public static ModelResourceLocation seatModel(Item chairIn) {
        ResourceLocation registry = BuiltInRegistries.ITEM.getKey((Object)chairIn);
        return new ModelResourceLocation(registry, "");
    }

    public static ModelResourceLocation upgradeModel(ResourceLocation upgrade) {
        return new ModelResourceLocation(Reference.ModInfo.prefix("upgrade_" + upgrade.getPath()), "");
    }
}

