/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity;

import com.google.common.collect.Lists;
import com.lying.client.renderer.entity.feature.EntityFeatureRenderer;
import com.lying.client.renderer.entity.state.WheelchairsRideableEntityRenderState;
import com.lying.entity.WheelchairsRideable;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;

public abstract class WheelchairsRideableEntityRenderer<T extends WheelchairsRideable, S extends WheelchairsRideableEntityRenderState>
extends EntityRenderer<T, S> {
    protected static final Minecraft mc = Minecraft.getInstance();
    private final List<EntityFeatureRenderer<S>> featureRenderers = Lists.newArrayList();
    protected final ItemRenderer renderItem = Minecraft.getInstance().getItemRenderer();
    protected final BlockRenderDispatcher blockRenderManager;

    public WheelchairsRideableEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.blockRenderManager = context.getBlockRenderDispatcher();
    }

    protected final void addFeature(EntityFeatureRenderer<S> featureIn) {
        this.featureRenderers.add(featureIn);
    }

    protected final void renderFeatures(S state, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        this.featureRenderers.stream().filter(f -> f.shouldRender(state)).forEach(feature -> feature.render(matrices, vertexConsumers, light, state, state.partialTick));
    }

    public void updateRenderState(T entity, S state, float tickDelta) {
        super.extractRenderState(entity, state, tickDelta);
        ((WheelchairsRideableEntityRenderState)((Object)state)).partialTick = tickDelta;
        ((WheelchairsRideableEntityRenderState)((Object)state)).world = entity.getCommandSenderWorld();
        ((WheelchairsRideableEntityRenderState)((Object)state)).entityId = entity.getId();
        float f = Mth.rotLerp((float)tickDelta, (float)((WheelchairsRideable)((Object)entity)).yHeadRotO, (float)((WheelchairsRideable)((Object)entity)).yHeadRot);
        ((WheelchairsRideableEntityRenderState)((Object)state)).bodyRot = WheelchairsRideableEntityRenderer.clampBodyYaw(entity, f, tickDelta);
        ((WheelchairsRideableEntityRenderState)((Object)state)).yRot = Mth.wrapDegrees((float)(f - ((WheelchairsRideableEntityRenderState)((Object)state)).bodyRot));
        ((WheelchairsRideableEntityRenderState)((Object)state)).xRot = entity.getXRot(tickDelta);
        ((WheelchairsRideableEntityRenderState)((Object)state)).customName = entity.getCustomName();
        if (!entity.isPassenger() && entity.isAlive()) {
            ((WheelchairsRideableEntityRenderState)((Object)state)).walkAnimationPos = ((WheelchairsRideable)((Object)entity)).walkAnimation.position(tickDelta);
            ((WheelchairsRideableEntityRenderState)((Object)state)).walkAnimationSpeed = ((WheelchairsRideable)((Object)entity)).walkAnimation.speed(tickDelta);
        } else {
            ((WheelchairsRideableEntityRenderState)((Object)state)).walkAnimationPos = 0.0f;
            ((WheelchairsRideableEntityRenderState)((Object)state)).walkAnimationSpeed = 0.0f;
        }
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            ((WheelchairsRideableEntityRenderState)((Object)state)).wornHeadAnimationPos = livingentity.walkAnimation.position(tickDelta);
        } else {
            ((WheelchairsRideableEntityRenderState)((Object)state)).wornHeadAnimationPos = ((WheelchairsRideableEntityRenderState)((Object)state)).walkAnimationPos;
        }
        ((WheelchairsRideableEntityRenderState)((Object)state)).scale = entity.getScale();
        ((WheelchairsRideableEntityRenderState)((Object)state)).ageScale = entity.getAgeScale();
        ((WheelchairsRideableEntityRenderState)((Object)state)).pose = entity.getPose();
        ((WheelchairsRideableEntityRenderState)((Object)state)).bedOrientation = entity.getBedOrientation();
        if (((WheelchairsRideableEntityRenderState)((Object)state)).bedOrientation != null) {
            ((WheelchairsRideableEntityRenderState)((Object)state)).eyeHeight = entity.getEyeHeight(Pose.STANDING);
        }
        ((WheelchairsRideableEntityRenderState)((Object)state)).isFullyFrozen = entity.isFullyFrozen();
        ((WheelchairsRideableEntityRenderState)((Object)state)).isBaby = entity.isBaby();
        ((WheelchairsRideableEntityRenderState)((Object)state)).isInWater = entity.isInWater();
        ((WheelchairsRideableEntityRenderState)((Object)state)).isAutoSpinAttack = entity.isAutoSpinAttack();
        ((WheelchairsRideableEntityRenderState)((Object)state)).hasRedOverlay = ((WheelchairsRideable)((Object)entity)).hurtTime > 0 || ((WheelchairsRideable)((Object)entity)).deathTime > 0;
        ((WheelchairsRideableEntityRenderState)((Object)state)).wornHeadType = null;
        ((WheelchairsRideableEntityRenderState)((Object)state)).wornHeadProfile = null;
        ((WheelchairsRideableEntityRenderState)((Object)state)).headItem.clear();
        ((WheelchairsRideableEntityRenderState)((Object)state)).deathTime = ((WheelchairsRideable)((Object)entity)).deathTime > 0 ? (float)((WheelchairsRideable)((Object)entity)).deathTime + tickDelta : 0.0f;
        ((WheelchairsRideableEntityRenderState)((Object)state)).isInvisibleToPlayer = ((WheelchairsRideableEntityRenderState)((Object)state)).isInvisible && entity.isInvisibleTo((Player)WheelchairsRideableEntityRenderer.mc.player);
        ((WheelchairsRideableEntityRenderState)((Object)state)).appearsGlowing = mc.shouldEntityAppearGlowing(entity);
    }

    private static float clampBodyYaw(LivingEntity entity, float degrees, float tickDelta) {
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            float f = Mth.rotLerp((float)tickDelta, (float)livingEntity.yBodyRotO, (float)livingEntity.yBodyRot);
            float yawLimit = 85.0f;
            float h = Mth.clamp((float)Mth.wrapDegrees((float)(degrees - f)), (float)(-yawLimit), (float)yawLimit);
            f = degrees - h;
            if (Math.abs(h) > 50.0f) {
                f += h * 0.2f;
            }
            return f;
        }
        return Mth.rotLerp((float)tickDelta, (float)entity.yBodyRotO, (float)entity.yBodyRot);
    }
}

