/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity.feature;

import com.lying.entity.IServiceVestHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public class AbstractVestLayer<C extends LivingEntityRenderState, M extends EntityModel<C>>
extends RenderLayer<C, M> {
    private final ResourceLocation mainTexture;
    private final ResourceLocation overlayTexture;
    private final M model;

    public AbstractVestLayer(RenderLayerParent<C, M> context, M vestModel, ResourceLocation mainTexIn, ResourceLocation overlayTexIn) {
        super(context);
        this.model = vestModel;
        this.mainTexture = mainTexIn;
        this.overlayTexture = overlayTexIn;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, C state, float limbAngle, float limbDistance) {
        if (((LivingEntityRenderState)state).isInvisibleToPlayer) {
            return;
        }
        IServiceVestHolder extension = (IServiceVestHolder)state;
        if (!extension.hasVest()) {
            return;
        }
        ItemStack stack = extension.getVest();
        int color = DyedItemColor.getOrDefault((ItemStack)stack, (int)-6265536);
        this.model.setupAnim(state);
        AbstractVestLayer.renderColoredCutoutModel(this.model, (ResourceLocation)this.mainTexture, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, state, (int)color);
        AbstractVestLayer.renderColoredCutoutModel(this.model, (ResourceLocation)this.overlayTexture, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (int)light, state, (int)-1);
    }
}

