/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity.feature;

import com.lying.client.init.WHCModelParts;
import com.lying.client.renderer.entity.feature.EntityFeatureRenderer;
import com.lying.client.renderer.entity.model.WheelchairElytraModel;
import com.lying.client.renderer.entity.state.WheelchairEntityRenderState;
import com.lying.init.WHCChairUpgrades;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class WheelchairElytraFeatureRenderer<T extends WheelchairEntityRenderState>
extends EntityFeatureRenderer<T> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/equipment/wings/elytra.png");
    private final WheelchairElytraModel<T> model;

    public WheelchairElytraFeatureRenderer(EntityRendererProvider.Context ctx) {
        this.model = new WheelchairElytraModel(ctx.getModelSet().bakeLayer(WHCModelParts.UPGRADE_ELYTRA));
    }

    @Override
    public boolean shouldRender(T state) {
        return ((WheelchairEntityRenderState)((Object)state)).upgrades.contains(WHCChairUpgrades.GLIDING.get());
    }

    @Override
    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T state, float tickDelta) {
        matrices.pushPose();
        matrices.translate(0.0f, ((WheelchairEntityRenderState)((Object)state)).isFlying ? 1.5f : 1.3f, 0.125f + (((WheelchairEntityRenderState)((Object)state)).isFlying ? 0.0f : 0.1f));
        float scale = ((WheelchairEntityRenderState)((Object)state)).isFlying ? 1.75f : 0.8f;
        matrices.scale(scale, -scale, scale);
        this.model.setAngles(state, 0.0f, 0.0f, ((WheelchairEntityRenderState)((Object)state)).ageInTicks, ((WheelchairEntityRenderState)((Object)state)).yRot, ((WheelchairEntityRenderState)((Object)state)).xRot);
        VertexConsumer vertexConsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)vertexConsumers, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)this.getTexture(state)), (boolean)false);
        this.model.renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        matrices.popPose();
    }

    public ResourceLocation getTexture(T state) {
        if (((WheelchairEntityRenderState)((Object)state)).rider.isPresent()) {
            AbstractClientPlayer playerEntity;
            PlayerSkin skinTextures;
            LivingEntity livingEntity = ((WheelchairEntityRenderState)((Object)state)).rider.get();
            return livingEntity instanceof AbstractClientPlayer ? ((skinTextures = (playerEntity = (AbstractClientPlayer)livingEntity).getSkin()).elytraTexture() != null ? skinTextures.elytraTexture() : (skinTextures.capeTexture() != null && playerEntity.isModelPartShown(PlayerModelPart.CAPE) ? skinTextures.capeTexture() : TEXTURE)) : TEXTURE;
        }
        return TEXTURE;
    }
}

