/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.renderer.entity.model;

import com.lying.client.renderer.entity.state.WheelchairEntityRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;

public class WheelchairElytraModel<T extends WheelchairEntityRenderState>
extends Model.Simple {
    private static final String PIVOT_PART = "pivot";
    private static final float BASE_TILT = (float)Math.toRadians(15.0);
    private final ModelPart pivot;
    private final ModelPart wingRight;
    private final ModelPart wingLeft;

    public WheelchairElytraModel(ModelPart root) {
        super(root, RenderType::entityCutoutNoCull);
        this.pivot = root.getChild(PIVOT_PART);
        this.wingRight = this.pivot.getChild("right_wing");
        this.wingLeft = this.pivot.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition pivot = partdefinition.addOrReplaceChild(PIVOT_PART, CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)5.0f, (float)0.0f));
        pivot.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-2.0f, -1.0f, -1.0f, 10.0f, 20.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)BASE_TILT, (float)0.0f, (float)BASE_TILT));
        pivot.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(22, 0).addBox(-8.0f, -1.0f, -1.0f, 10.0f, 20.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)BASE_TILT, (float)0.0f, (float)(-BASE_TILT)));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setAngles(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        float wingPitch = BASE_TILT;
        float wingRoll = -BASE_TILT;
        float wingYaw = 0.0f;
        if (((WheelchairEntityRenderState)((Object)state)).isGliding) {
            float o = 1.0f;
            Vec3 vec3d = ((WheelchairEntityRenderState)((Object)state)).velocity;
            if (vec3d.y < 0.0) {
                Vec3 vec3d2 = vec3d.normalize();
                o = 1.0f - (float)Math.pow(-vec3d2.y, 1.5);
            }
            wingPitch = o * 0.34906584f + (1.0f - o) * wingPitch;
            wingPitch += (float)Math.toRadians(90.0);
            wingRoll = o * -1.5707964f + (1.0f - o) * wingRoll;
        } else if (((WheelchairEntityRenderState)((Object)state)).isDiscrete) {
            wingPitch = (float)Math.toRadians(40.0);
            wingRoll = -((float)Math.toRadians(45.0));
            wingYaw = (float)Math.toRadians(5.0);
        }
        this.pivot.xRot = wingPitch;
        this.wingLeft.yRot = wingYaw;
        this.wingRight.zRot = -this.wingLeft.zRot;
        this.wingLeft.zRot = wingRoll;
        this.wingRight.yRot = -this.wingLeft.yRot;
    }

    public ModelPart getPart() {
        return this.pivot;
    }
}

