/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.lying.client.utility.AACLibrary;
import com.lying.network.AACMessagePacket;
import com.lying.reference.Reference;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AACScreen
extends Screen {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final ResourceLocation TEXTURE = Reference.ModInfo.prefix("textures/gui/speech_tablet.png");
    private static AACLibrary.PhraseSet[] SETS = AACLibrary.ALL_SETS;
    private static final int BUTTON_HEIGHT = 30;
    private static final int BUTTON_WIDTH = 80;
    private static final int SPACING = 5;
    private static final int ROW_COUNT = 5;
    private static final int COL_COUNT = 5;
    private Mode messageMode = Mode.SINGLE;
    private MutableComponent messageToSend = null;
    private int currentSet = 0;
    private Button[] setButtons = new Button[SETS.length];
    private AACButton[] phraseButtons = new AACButton[25];
    private Button sendButton;

    public AACScreen(Component title) {
        super(title);
    }

    public void init() {
        super.init();
        int gridWidth = 420;
        int left = (this.width - gridWidth) / 2;
        int right = (this.width + gridWidth) / 2;
        this.generateSetButtons();
        this.generatePhraseButtonGrid();
        this.addRenderableWidget((GuiEventListener)new ModeButtonWidget(this, left, 220, button -> this.setMode(this.messageMode == Mode.SINGLE ? Mode.COMPOUND : Mode.SINGLE), this));
        this.sendButton = Button.builder((Component)Reference.ModInfo.translate("gui", "send_aac_message"), button -> this.send(this.messageToSend)).bounds(right - 35, 220, 35, 20).build();
        this.addRenderableWidget((GuiEventListener)this.sendButton);
        this.setMode(Mode.SINGLE);
        this.setPhraseSet(0);
    }

    private void generateSetButtons() {
        int gridWidth = 420;
        int setShift = 85;
        int left = (this.width - gridWidth) / 2;
        for (int i = 0; i < SETS.length; ++i) {
            int index = i;
            AACLibrary.PhraseSet set = SETS[i];
            this.setButtons[i] = Button.builder((Component)set.displayName(), button -> this.setPhraseSet(index)).bounds(left + setShift * i, 25, 80, 20).build();
            this.addRenderableWidget((GuiEventListener)this.setButtons[i]);
        }
    }

    private void generatePhraseButtonGrid() {
        int gridWidth = 420;
        int left = (this.width - gridWidth) / 2;
        int shiftX = 85;
        int shiftY = 35;
        for (int i = 0; i < this.phraseButtons.length; ++i) {
            int col = i % 5;
            int row = Math.floorDiv(i, 5);
            this.phraseButtons[i] = new AACButton(this, left + shiftX * col, 48 + shiftY * row, this);
            this.addRenderableWidget((GuiEventListener)this.phraseButtons[i]);
        }
    }

    private void setPhraseSet(int index) {
        this.currentSet = Math.abs(index) % SETS.length;
        this.updateButtons();
    }

    private void updateButtons() {
        this.sendButton.visible = this.messageMode == Mode.COMPOUND;
        this.sendButton.active = this.messageToSend != null;
        for (int i = 0; i < this.setButtons.length; ++i) {
            this.setButtons[i].active = i != this.currentSet;
        }
        AACLibrary.PhraseSet set = SETS[this.currentSet];
        for (int i = 0; i < this.phraseButtons.length; ++i) {
            AACButton phrase = this.phraseButtons[i];
            boolean bl = phrase.active = i < set.size();
            if (i >= set.size()) {
                phrase.clear();
                continue;
            }
            Tuple<Component, Supplier<MutableComponent>> entry = set.get(i);
            phrase.setPhrase((Component)entry.getA(), (Supplier)entry.getB());
        }
        this.setFocused(null);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void setMode(Mode modeIn) {
        if (this.messageMode == modeIn) {
            return;
        }
        this.messageToSend = null;
        this.messageMode = modeIn;
        this.updateButtons();
    }

    public void append(MutableComponent text) {
        switch (this.messageMode.ordinal()) {
            case 0: {
                this.send(text);
                break;
            }
            case 1: {
                if (this.messageToSend == null) {
                    this.messageToSend = text;
                    break;
                }
                this.messageToSend.append(" ").append((Component)text);
            }
        }
        this.sendButton.active = this.messageToSend != null;
    }

    public void send(@Nullable MutableComponent message) {
        if (message != null) {
            AACMessagePacket.sendToServer((Component)message, (Player)AACScreen.mc.player);
        }
        this.onClose();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderForeground(context, mouseX, mouseY, delta);
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
        int i = (this.width - 430) / 2;
        context.blit(RenderType::guiTextured, TEXTURE, i, 10, 0.0f, 0.0f, 0, 430, 235, 512, 512);
    }

    private void renderForeground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.drawString(this.font, this.title, (this.width - this.font.width((FormattedText)this.title)) / 2, 15, 0x404040, false);
        if (this.messageToSend != null) {
            MutableComponent message = Component.translatable((String)"aac.wheelchairs.message", (Object[])new Object[]{AACScreen.mc.player.getDisplayName(), this.messageToSend});
            context.drawString(this.font, (Component)message, (this.width - this.font.width((FormattedText)message)) / 2, 226, 0xFFFFFF, false);
        }
    }

    private static enum Mode {
        SINGLE,
        COMPOUND;


        public Component translate() {
            return Reference.ModInfo.translate("aac_mode", this.name().toLowerCase());
        }
    }

    private class AACButton
    extends Button {
        private final AACScreen parentScreen;
        private Supplier<MutableComponent> message = () -> null;

        protected AACButton(AACScreen aACScreen, int x, int y, AACScreen parent) {
            super(x, y, 80, 30, (Component)Component.empty(), button -> {
                if (!(button instanceof AACButton)) {
                    return;
                }
                AACButton phrase = (AACButton)button;
                MutableComponent message = phrase.message.get();
                if (message != null) {
                    phrase.parentScreen.append(message);
                }
                phrase.parentScreen.setFocused(null);
            }, Button.DEFAULT_NARRATION);
            this.parentScreen = parent;
        }

        public void setPhrase(Component title, Supplier<MutableComponent> messageIn) {
            this.setMessage(title);
            this.message = messageIn;
        }

        public void clear() {
            this.setMessage((Component)Component.empty());
            this.message = () -> null;
        }
    }

    private class ModeButtonWidget
    extends Button {
        private final AACScreen parentScreen;

        public ModeButtonWidget(AACScreen aACScreen, int x, int y, Button.OnPress onPress, AACScreen parent) {
            super(x, y, 20, 20, CommonComponents.EMPTY, onPress, DEFAULT_NARRATION);
            this.parentScreen = parent;
            this.setTooltip(Tooltip.create((Component)this.parentScreen.messageMode.translate()));
        }

        public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.blit(RenderType::guiTextured, TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, 235 + (this.isHovered() ? 20 : 0), 20, 20, 512, 512);
            context.blit(RenderType::guiTextured, TEXTURE, this.getX(), this.getY(), 0.0f, 20.0f, 235 + this.parentScreen.messageMode.ordinal() * 20, 20, 20, 512, 512);
        }

        public void onPress() {
            super.onPress();
            this.setTooltip(Tooltip.create((Component)this.parentScreen.messageMode.translate()));
        }
    }
}

