/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.screen;

import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.network.ForceUnparentPacket;
import com.lying.reference.Reference;
import com.lying.screen.ChairInventoryScreenHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ChairInventoryScreen
extends AbstractContainerScreen<ChairInventoryScreenHandler> {
    private static final Minecraft mc = Minecraft.getInstance();
    public static final ResourceLocation TEXTURE = Reference.ModInfo.prefix("textures/gui/chair_inventory.png");
    private Button unbindButton;

    public ChairInventoryScreen(ChairInventoryScreenHandler screenHandler, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)screenHandler, playerInventory, text);
        this.inventoryLabelY = this.imageHeight - 92;
    }

    protected void init() {
        super.init();
        this.unbindButton = Button.builder((Component)Component.translatable((String)"gui.wheelchairs.unparent_chair"), button -> ForceUnparentPacket.send()).bounds(this.width / 2 - 80, this.height / 2 - 50, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.unbindButton);
        this.unbindButton.active = false;
        this.unbindButton.visible = false;
    }

    public void containerTick() {
        super.containerTick();
        if (!ChairInventoryScreenHandler.isValidForUse((Player)ChairInventoryScreen.mc.player)) {
            this.onClose();
            return;
        }
        WheelchairEntity chair = (WheelchairEntity)ChairInventoryScreen.mc.player.getVehicle();
        this.unbindButton.visible = chair.hasUpgrade(WHCChairUpgrades.HANDLES.get());
        this.unbindButton.active = chair.hasParent() && chair.rebindCooldown() <= 0;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int i = (this.width - 174) / 2;
        int j = (this.height - 164) / 2;
        context.blit(RenderType::guiTextured, TEXTURE, i, j, 0.0f, 0.0f, 174, 164, 256, 256);
        if (((ChairInventoryScreenHandler)this.getMenu()).hasStorage) {
            context.blit(RenderType::guiTextured, TEXTURE, this.width / 2 - 45, this.height / 2 - 66, 0.0f, 164.0f, 90, 54, 256, 256);
        }
        if (((ChairInventoryScreenHandler)this.getMenu()).hasPlacer) {
            context.blit(RenderType::guiTextured, TEXTURE, this.width / 2 + 54, this.height / 2 - 48, 0.0f, 218.0f, 18, 18, 256, 256);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2, this.titleLabelY, 0x404040, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }
}

