/*
 * Decompiled with CFR 0.152.
 */
package com.lying.client.utility;

import com.lying.Wheelchairs;
import com.lying.client.WheelchairsClient;
import com.lying.reference.Reference;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;

public class AACLibrary {
    private static final Minecraft mc = Minecraft.getInstance();
    public static PhraseSet BASIC;
    public static PhraseSet FEELINGS;
    public static PhraseSet PLACES;
    public static PhraseSet ACTIONS;
    public static PhraseSet THINGS;
    public static PhraseSet[] ALL_SETS;

    public static void init() {
        BASIC = new PhraseSet("basic", List.of(AACLibrary.entrySimple("hello"), AACLibrary.entrySimple("goodbye"), AACLibrary.entrySimple("yes"), AACLibrary.entrySimple("no"), AACLibrary.entrySimple("okay"), AACLibrary.entryDynamic((Component)AACLibrary.translate("my_coords_title"), () -> AACLibrary.translate("my_coords", AACLibrary.mc.player.blockPosition().toShortString())), AACLibrary.entryDynamic((Component)AACLibrary.translate("my_health_title"), () -> AACLibrary.translate("my_health", String.valueOf((int)AACLibrary.mc.player.getHealth()))), AACLibrary.entryDynamic((Component)AACLibrary.translate("held_item_title"), () -> AACLibrary.translate("held_item", AACLibrary.mc.player.getOffhandItem().getHoverName())), AACLibrary.entrySimple("come_here"), AACLibrary.entrySimple("stay_away"), AACLibrary.entrySimple("on_my_way"), AACLibrary.entrySimple("how_are_you"), AACLibrary.entrySimple("you"), AACLibrary.entrySimple("me"), AACLibrary.entrySimple("need"), AACLibrary.entrySimple("have"), AACLibrary.entrySimple("please"), AACLibrary.entrySimple("thank_you"), AACLibrary.entrySimple("more"), AACLibrary.entrySimple("less")));
        FEELINGS = new PhraseSet("feelings", List.of(AACLibrary.entrySimple("good"), AACLibrary.entrySimple("bad"), AACLibrary.entrySimple("scared"), AACLibrary.entrySimple("happy"), AACLibrary.entrySimple("fun"), AACLibrary.entrySimple("excited"), AACLibrary.entrySimple("bored"), AACLibrary.entrySimple("sad"), AACLibrary.entrySimple("alone"), AACLibrary.entrySimple("tired"), AACLibrary.entrySimple("nervous"), AACLibrary.entrySimple("confused"), AACLibrary.entrySimple("understand"), AACLibrary.entrySimple("hurt"), AACLibrary.entrySimple("hungry"), AACLibrary.entrySimple("danger"), AACLibrary.entrySimple("safe")));
        PLACES = new PhraseSet("places", List.of(AACLibrary.entrySimple("here"), AACLibrary.entrySimple("there"), AACLibrary.entrySimple("world_spawn"), AACLibrary.entrySimple("base"), AACLibrary.entrySimple("overworld"), AACLibrary.entrySimple("the_end"), AACLibrary.entrySimple("the_nether"), AACLibrary.entrySimple("stronghold"), AACLibrary.entrySimple("dungeon"), AACLibrary.entrySimple("ocean"), AACLibrary.entrySimple("desert"), AACLibrary.entrySimple("forest"), AACLibrary.entrySimple("field"), AACLibrary.entrySimple("quarry"), AACLibrary.entrySimple("caves"), AACLibrary.entrySimple("ravine"), AACLibrary.entrySimple("village"), AACLibrary.entrySimple("farm"), AACLibrary.entrySimple("spawner")));
        ACTIONS = new PhraseSet("actions", List.of(AACLibrary.entrySimple("explore"), AACLibrary.entrySimple("dig"), AACLibrary.entrySimple("craft"), AACLibrary.entrySimple("build"), AACLibrary.entrySimple("cook"), AACLibrary.entrySimple("enchant"), AACLibrary.entrySimple("look"), AACLibrary.entrySimple("going"), AACLibrary.entrySimple("help"), AACLibrary.entrySimple("eat"), AACLibrary.entrySimple("find"), AACLibrary.entrySimple("fight"), AACLibrary.entrySimple("swim"), AACLibrary.entrySimple("sail"), AACLibrary.entrySimple("fly"), AACLibrary.entrySimple("sleep"), AACLibrary.entrySimple("follow"), AACLibrary.entrySimple("stay"), AACLibrary.entrySimple("defeat"), AACLibrary.entrySimple("lost")));
        THINGS = new PhraseSet("things", List.of(AACLibrary.entrySimple("food"), AACLibrary.entrySimple("potion"), AACLibrary.entrySimple("fish"), AACLibrary.entrySimple("water"), AACLibrary.entrySimple("lava"), AACLibrary.entrySimple("bucket"), AACLibrary.entrySimple("pickaxe"), AACLibrary.entrySimple("axe"), AACLibrary.entrySimple("shovel"), AACLibrary.entrySimple("sword"), AACLibrary.entrySimple("leather"), AACLibrary.entrySimple("iron"), AACLibrary.entrySimple("gold"), AACLibrary.entrySimple("diamond"), AACLibrary.entrySimple("armor"), AACLibrary.entrySimple("helmet"), AACLibrary.entrySimple("chestplate"), AACLibrary.entrySimple("leggings"), AACLibrary.entrySimple("boots"), AACLibrary.entrySimple("monster"), AACLibrary.entrySimple("animal"), AACLibrary.entrySimple("trader"), AACLibrary.entrySimple("pet"), AACLibrary.entrySimple("boss"), AACLibrary.entrySimple("dragon")));
        ALL_SETS = new PhraseSet[]{BASIC, FEELINGS, PLACES, ACTIONS, THINGS};
        int total = 0;
        for (PhraseSet set : ALL_SETS) {
            total += set.size();
        }
        Wheelchairs.LOGGER.info("Initialised AAC library with " + total + " phrases across " + ALL_SETS.length + " sets");
        Wheelchairs.LOGGER.info("AAC narration setting: " + WheelchairsClient.config.shouldNarrateAAC());
    }

    private static MutableComponent translate(String name) {
        return Reference.ModInfo.translate("aac", name.toLowerCase()).copy();
    }

    private static MutableComponent translate(String name, Object ... args) {
        return Reference.ModInfo.translate("aac", name.toLowerCase(), args).copy();
    }

    private static Tuple<Component, Supplier<MutableComponent>> entrySimple(String name) {
        return AACLibrary.entrySimple(() -> AACLibrary.translate(name.toLowerCase()));
    }

    private static Tuple<Component, Supplier<MutableComponent>> entrySimple(Supplier<MutableComponent> name) {
        return AACLibrary.entryDynamic((Component)name.get(), name);
    }

    private static Tuple<Component, Supplier<MutableComponent>> entryDynamic(Component name, Supplier<MutableComponent> supplier) {
        return new Tuple((Object)name, supplier);
    }

    public static class PhraseSet {
        public final String setName;
        private final Component displayName;
        private final List<Tuple<Component, Supplier<MutableComponent>>> phrases;

        public PhraseSet(String setNameIn, List<Tuple<Component, Supplier<MutableComponent>>> phrasesIn) {
            this(setNameIn, (Component)AACLibrary.translate("set_" + setNameIn), phrasesIn);
        }

        public PhraseSet(String setNameIn, Component name, List<Tuple<Component, Supplier<MutableComponent>>> phrasesIn) {
            this.setName = setNameIn;
            this.displayName = name;
            this.phrases = phrasesIn;
            if (this.phrases.size() > 25) {
                Wheelchairs.LOGGER.warn("# AAC phrase set [{}] has more phrases than the AAC screen can display! {}", (Object)this.setName, (Object)this.phrases.size());
            }
        }

        public Component displayName() {
            return this.displayName;
        }

        public int size() {
            return this.phrases.size();
        }

        public Tuple<Component, Supplier<MutableComponent>> get(int index) {
            return this.phrases.get(index);
        }
    }
}

