/*
 * Decompiled with CFR 0.152.
 */
package com.lying.component;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public abstract class VestData {
    protected final LivingEntity owner;
    private ItemStack vest = ItemStack.EMPTY;

    public VestData(LivingEntity ownerIn) {
        this.owner = ownerIn;
    }

    public void readFromNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        this.vest = ItemStack.EMPTY;
        if (tag.contains("Vest", 10)) {
            this.vest = ItemStack.parse((HolderLookup.Provider)lookup, (Tag)tag.getCompound("Vest")).orElse(ItemStack.EMPTY);
        }
    }

    public void writeToNbt(CompoundTag tag, HolderLookup.Provider lookup) {
        if (!this.vest.isEmpty()) {
            tag.put("Vest", this.vest.save(lookup));
        }
    }

    public boolean hasVest() {
        return !this.vest.isEmpty();
    }

    public ItemStack get() {
        return this.vest;
    }

    public void setVest(ItemStack stack) {
        this.vest = stack.copy();
    }

    public void tick() {
        if (!this.hasVest() || !(this.owner instanceof LivingEntity)) {
            return;
        }
        if (this.owner.getHealth() < this.owner.getMaxHealth() && this.owner.tickCount % 1200 == 0) {
            this.owner.heal(1.0f);
        }
    }
}

