/*
 * Decompiled with CFR 0.152.
 */
package com.lying.component.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record SwordComponent(ItemStack item) implements TooltipProvider
{
    public static final Codec<SwordComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.optionalFieldOf("contents").forGetter(SwordComponent::contents)).apply((Applicative)instance, stack -> new SwordComponent(stack.orElse(ItemStack.EMPTY))));
    public static final StreamCodec<RegistryFriendlyByteBuf, SwordComponent> PACKET_CODEC = ItemStack.STREAM_CODEC.map(SwordComponent::new, SwordComponent::item);

    public Optional<ItemStack> contents() {
        return this.item == null || this.item.isEmpty() ? Optional.empty() : Optional.of(this.item);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        this.contents().ifPresent(item -> tooltip.accept((Component)Component.translatable((String)"gui.wheelchairs.cane.sword", (Object[])new Object[]{item.getHoverName()})));
    }

    public static SwordComponent empty() {
        return new SwordComponent(ItemStack.EMPTY);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SwordComponent)) return false;
        SwordComponent comp = (SwordComponent)obj;
        if (!comp.item.equals(this.item)) return false;
        return true;
    }
}

