/*
 * Decompiled with CFR 0.152.
 */
package com.lying.component.type;

import com.lying.entity.ChairUpgrade;
import com.lying.init.WHCChairUpgrades;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record UpgradesComponent(List<ResourceLocation> upgrades) implements TooltipProvider
{
    public static final Codec<UpgradesComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.listOf().fieldOf("contents").forGetter(UpgradesComponent::upgrades)).apply((Applicative)instance, UpgradesComponent::new));
    public static final StreamCodec<ByteBuf, UpgradesComponent> PACKET_CODEC = ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).map(UpgradesComponent::new, UpgradesComponent::upgrades);

    public List<ChairUpgrade> asList() {
        return this.upgrades().stream().map(WHCChairUpgrades::get).toList();
    }

    public static UpgradesComponent fromList(List<ChairUpgrade> upgrades) {
        return new UpgradesComponent(upgrades.stream().map(ChairUpgrade::registryName).toList());
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        if (!this.upgrades.isEmpty()) {
            tooltip.accept(Reference.ModInfo.translate("gui", "upgrades"));
        }
        this.upgrades.forEach(upgrade -> {
            ChairUpgrade obj = WHCChairUpgrades.get(upgrade);
            if (obj != null) {
                tooltip.accept((Component)Component.literal((String)" * ").append(obj.translate()));
            }
        });
    }

    public static UpgradesComponent blank() {
        return new UpgradesComponent(List.of());
    }
}

