/*
 * Decompiled with CFR 0.152.
 */
package com.lying.component.type;

import com.lying.init.WHCItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.jetbrains.annotations.NotNull;

public class WheelComponent
implements TooltipProvider {
    public static final Supplier<ItemStack> DEFAULT_WHEEL = () -> new ItemStack(WHCItems.WHEEL_OAK);
    public static final Codec<WheelComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.optionalFieldOf("contents").forGetter(c -> Optional.of(c.item)), (App)HumanoidArm.CODEC.fieldOf("side").forGetter(WheelComponent::side)).apply((Applicative)instance, (stack, side) -> stack.isPresent() ? new WheelComponent((ItemStack)stack.get(), (HumanoidArm)side) : new WheelComponent((HumanoidArm)side)));
    public static final StreamCodec<RegistryFriendlyByteBuf, WheelComponent> PACKET_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, WheelComponent::item, (StreamCodec)ByteBufCodecs.BOOL, WheelComponent::isRight, (stack, side) -> new WheelComponent((ItemStack)stack, side != false ? HumanoidArm.RIGHT : HumanoidArm.LEFT));
    private final HumanoidArm side;
    private ItemStack item = DEFAULT_WHEEL.get();

    protected WheelComponent(@NotNull ItemStack item, HumanoidArm side) {
        this(side);
        this.with(item);
    }

    protected WheelComponent(HumanoidArm side) {
        this.side = side;
    }

    public final HumanoidArm side() {
        return this.side;
    }

    public final boolean isRight() {
        return this.side == HumanoidArm.RIGHT;
    }

    public ItemStack item() {
        return this.item;
    }

    public WheelComponent with(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return this;
        }
        this.item = stack.copy();
        return this;
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
        tooltip.accept((Component)Component.translatable((String)("gui.wheelchairs.wheelchair.wheel_" + this.side.name().toLowerCase()), (Object[])new Object[]{this.item.getHoverName()}));
    }

    public static WheelComponent empty(HumanoidArm side) {
        return new WheelComponent(side);
    }

    public int hashCode() {
        return Objects.hash(this.item, this.side);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WheelComponent)) return false;
        WheelComponent comp = (WheelComponent)obj;
        if (!comp.side.equals((Object)this.side)) return false;
        if (!comp.item.equals(this.item)) return false;
        return true;
    }
}

