/*
 * Decompiled with CFR 0.152.
 */
package com.lying.config;

import com.lying.config.Config;
import com.lying.data.WHCTags;
import com.lying.init.WHCEnchantmentComponentTypes;
import java.io.FileWriter;
import java.util.Properties;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class ServerConfig
extends Config {
    private static final Properties DEFAULT_SETTINGS = new Properties();
    private SwordCaneFilter swordCanes = SwordCaneFilter.ENCHANT;
    private boolean handsyWalkers = false;

    public ServerConfig(String fileIn) {
        super(fileIn);
    }

    @Override
    protected Properties getDefaults() {
        return DEFAULT_SETTINGS;
    }

    public SwordCaneFilter swordCaneFilter() {
        return this.swordCanes;
    }

    public boolean handsyWalkers() {
        return this.handsyWalkers;
    }

    @Override
    protected void readValues(Properties valuesIn) {
        this.swordCanes = SwordCaneFilter.get(ServerConfig.parseStringOr(valuesIn.getProperty("SwordCaneFilter"), null));
        this.handsyWalkers = ServerConfig.parseBoolOr(valuesIn.getProperty("HandsyWalkers"), false);
    }

    @Override
    protected void writeValues(FileWriter writer) {
        ServerConfig.writeString(writer, "SwordCaneFilter", this.swordCanes.getSerializedName());
        ServerConfig.writeBool(writer, "HandsyWalkers", this.handsyWalkers);
    }

    static {
        DEFAULT_SETTINGS.put("SwordCaneFilter", SwordCaneFilter.ENCHANT.getSerializedName());
        DEFAULT_SETTINGS.put("HandsyWalkers", "FALSE");
    }

    public static enum SwordCaneFilter implements StringRepresentable
    {
        ENCHANT(stack -> EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)WHCEnchantmentComponentTypes.CANE_STOREABLE.get()))),
        ALLOW_LIST(stack -> stack.is(WHCTags.FILTER_SWORD_CANE)),
        DENY_LIST(stack -> !ALLOW_LIST.test((ItemStack)stack));

        private final Predicate<ItemStack> condition;

        private SwordCaneFilter(Predicate<ItemStack> conditionIn) {
            this.condition = conditionIn;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public final boolean test(ItemStack stack) {
            return !stack.isEmpty() && this.condition.test(stack);
        }

        public static SwordCaneFilter get(String name) {
            if (name != null) {
                for (SwordCaneFilter value : SwordCaneFilter.values()) {
                    if (!value.getSerializedName().equalsIgnoreCase(name)) continue;
                    return value;
                }
            }
            return ENCHANT;
        }
    }
}

