/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.data.recipe.RecipeHandle;
import com.lying.init.WHCSpecialRecipes;
import com.lying.item.CaneItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RecipeCane
implements CraftingRecipe {
    public static final ResourceLocation ID = Reference.ModInfo.prefix("cane");
    private final ItemStack result;
    private final Ingredient staff;
    private static final Ingredient STICK = Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK});
    private Level currentWorld;
    private PlacementInfo placement;

    public RecipeCane(ItemStack result, Ingredient staff) {
        this.result = result;
        this.staff = staff;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public PlacementInfo placementInfo() {
        if (this.placement == null) {
            this.placement = PlacementInfo.createFromOptionals(List.of(Optional.of(this.staff), Optional.of(STICK)));
        }
        return this.placement;
    }

    public boolean fits(int width, int height) {
        return width >= 1 && height >= 3;
    }

    public boolean matches(CraftingInput inv, Level world) {
        this.currentWorld = world;
        RecipeHandle handle = null;
        ItemStack staff = ItemStack.EMPTY;
        ItemStack stick = ItemStack.EMPTY;
        for (int y = 0; y < inv.height() - 2; ++y) {
            for (int x = 0; x < inv.width(); ++x) {
                ItemStack handleMat = inv.getItem(RecipeCane.coordsToIndex(x, y, inv.width()));
                Optional<RecipeHolder<RecipeHandle>> handleRecipe = this.handleFromItem(handleMat, world);
                if (handleRecipe.isEmpty()) continue;
                handle = (RecipeHandle)handleRecipe.get().value();
                ItemStack staffMat = inv.getItem(RecipeCane.coordsToIndex(x, y + 1, inv.width()));
                if (!this.staff.test(staffMat)) continue;
                staff = staffMat.copy();
                ItemStack stickMat = inv.getItem(RecipeCane.coordsToIndex(x, y + 2, inv.width()));
                if (!STICK.test(stickMat)) continue;
                stick = stickMat.copy();
            }
        }
        return handle != null && !staff.isEmpty() && !stick.isEmpty();
    }

    public ItemStack getResult(RegistryAccess var2) {
        return this.result.copy();
    }

    public ItemStack craft(CraftingInput inv, HolderLookup.Provider var2) {
        ItemStack handle = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            Optional<RecipeHolder<RecipeHandle>> handleRecipe = this.handleFromItem(inv.getItem(i), this.currentWorld);
            if (!handleRecipe.isPresent()) continue;
            handle = ((RecipeHandle)handleRecipe.get().value()).getResult();
            break;
        }
        if (!handle.isEmpty()) {
            ItemStack stack = this.result.copy();
            CaneItem.setHandle(stack, handle);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public Optional<RecipeHolder<RecipeHandle>> handleFromItem(ItemStack stack, Level world) {
        RecipeManager recipeManager = world.getServer().getRecipeManager();
        return recipeManager.getRecipeFor((RecipeType)WHCSpecialRecipes.HANDLE_TYPE.get(), (RecipeInput)new SingleRecipeInput(stack.copy()), world);
    }

    private static int coordsToIndex(int x, int y, int width) {
        return x + y * width;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return (RecipeSerializer)WHCSpecialRecipes.CANE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeCane> {
        private static final MapCodec<RecipeCane> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC.fieldOf("staff").forGetter(r -> r.staff)).apply((Applicative)instance, RecipeCane::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeCane> PACKET_CODEC = StreamCodec.ofMember((r, buf) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)r.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.staff);
        }, buf -> new RecipeCane((ItemStack)ItemStack.STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf)));

        public MapCodec<RecipeCane> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeCane> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

