/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.data.recipe.RecipeCane;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class RecipeCaneJsonBuilder {
    private final RecipeCategory category;
    private final ItemStack result;
    private final Ingredient backing;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public RecipeCaneJsonBuilder(ItemStack result, Ingredient backing, RecipeCategory category) {
        this.category = category;
        this.backing = backing;
        this.result = result;
    }

    public RecipeCaneJsonBuilder criterion(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void offerTo(RecipeOutput exporter, ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
        ResourceKey id = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
        Advancement.Builder builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)id)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        RecipeCane recipe = new RecipeCane(this.result, this.backing);
        exporter.accept(id, (Recipe)recipe, builder.build(recipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

