/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.Wheelchairs;
import com.lying.init.WHCEnchantmentComponentTypes;
import com.lying.init.WHCItems;
import com.lying.init.WHCSpecialRecipes;
import com.lying.item.CaneItem;
import com.lying.reference.Reference;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class RecipeCaneSword
extends CustomRecipe {
    public static final ResourceLocation ID = Reference.ModInfo.prefix("cane_sword");
    private static final Predicate<ItemStack> IS_HOLLOW_CANE = stack -> stack.getItem() instanceof CaneItem && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)((DataComponentType)WHCEnchantmentComponentTypes.CANE_INVENTORY.get())) && CaneItem.getSword(stack).isEmpty();

    public RecipeCaneSword() {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput inv, Level world) {
        ItemStack cane = ItemStack.EMPTY;
        ItemStack sword = ItemStack.EMPTY;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stackInSlot = inv.getItem(slot);
            if (stackInSlot.isEmpty()) continue;
            if (IS_HOLLOW_CANE.test(stackInSlot)) {
                if (cane.isEmpty()) {
                    cane = stackInSlot.copy();
                    continue;
                }
                return false;
            }
            if (RecipeCaneSword.isAppropriateSword(stackInSlot)) {
                if (sword.isEmpty()) {
                    sword = stackInSlot.copy();
                    continue;
                }
                return false;
            }
            return false;
        }
        return !cane.isEmpty() && !sword.isEmpty();
    }

    public ItemStack craft(CraftingInput inv, HolderLookup.Provider var2) {
        ItemStack cane = ItemStack.EMPTY;
        ItemStack sword = ItemStack.EMPTY;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack stackInSlot = inv.getItem(slot);
            if (stackInSlot.isEmpty()) continue;
            if (IS_HOLLOW_CANE.test(stackInSlot)) {
                if (cane.isEmpty()) {
                    cane = stackInSlot.copy();
                    continue;
                }
                return ItemStack.EMPTY;
            }
            if (RecipeCaneSword.isAppropriateSword(stackInSlot)) {
                if (sword.isEmpty()) {
                    sword = stackInSlot.copy();
                    continue;
                }
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        if (!cane.isEmpty() && !sword.isEmpty()) {
            return CaneItem.setSword(cane, sword);
        }
        return ItemStack.EMPTY;
    }

    public boolean fits(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getResult(RegistryAccess var1) {
        return ((Item)WHCItems.CANE_OAK.get()).getDefaultInstance();
    }

    public static boolean isAppropriateSword(ItemStack stack) {
        return Wheelchairs.config.swordCaneFilter().test(stack);
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)WHCSpecialRecipes.CANE_SWORD_SERIALIZER.get();
    }
}

