/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.init.WHCItems;
import com.lying.init.WHCSpecialRecipes;
import com.lying.item.CaneItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RecipeHandle
implements Recipe<RecipeInput> {
    public static final ResourceLocation ID = Reference.ModInfo.prefix("handle");
    private final ItemStack result;
    private final Ingredient material;

    public RecipeHandle(ItemStack result, Ingredient staff) {
        this.result = result;
        this.material = staff;
    }

    public RecipeType<RecipeHandle> getType() {
        return (RecipeType)WHCSpecialRecipes.HANDLE_TYPE.get();
    }

    public RecipeBookCategory recipeBookCategory() {
        return RecipeBookCategories.CRAFTING_MISC;
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean fits(int width, int height) {
        return width >= 1 && height >= 1;
    }

    public boolean matches(RecipeInput inv, Level var2) {
        ItemStack mat = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (!this.material.test(stackInSlot)) continue;
            if (mat.isEmpty()) {
                mat = stackInSlot.copy();
                continue;
            }
            return false;
        }
        return !mat.isEmpty();
    }

    public ItemStack getResult(RegistryAccess var2) {
        return CaneItem.withHandle((Item)WHCItems.CANE_OAK.get(), this.result.getItem());
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider var2) {
        ItemStack mat = ItemStack.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (!this.material.test(stackInSlot)) continue;
            if (mat.isEmpty()) {
                mat = stackInSlot.copy();
                continue;
            }
            return ItemStack.EMPTY;
        }
        return !mat.isEmpty() ? this.result.copy() : ItemStack.EMPTY;
    }

    public RecipeSerializer<? extends Recipe<RecipeInput>> getSerializer() {
        return (RecipeSerializer)WHCSpecialRecipes.HANDLE_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeHandle> {
        private static final MapCodec<RecipeHandle> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC.fieldOf("material").forGetter(r -> r.material)).apply((Applicative)instance, RecipeHandle::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeHandle> PACKET_CODEC = StreamCodec.ofMember((r, buf) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)r.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.material);
        }, buf -> new RecipeHandle((ItemStack)ItemStack.STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf)));

        public MapCodec<RecipeHandle> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeHandle> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

