/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.init.WHCSpecialRecipes;
import com.lying.item.WalkerItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class RecipeWalker
implements CraftingRecipe {
    public static final ResourceLocation ID = Reference.ModInfo.prefix("walker");
    private final ItemStack result;
    private final Ingredient strut;
    private final Ingredient platform;
    private final Ingredient handle;
    private final Ingredient wheelLeft;
    private final Ingredient wheelRight;
    private final Map<Vector2i, Ingredient> recipeGrid = new HashMap<Vector2i, Ingredient>();
    private PlacementInfo placement = null;

    public RecipeWalker(ItemStack result, Ingredient strut, Ingredient platform, Ingredient handle, Ingredient wheelL, Ingredient wheelR) {
        this.result = result;
        this.strut = strut;
        this.platform = platform;
        this.handle = handle;
        this.wheelLeft = wheelL;
        this.wheelRight = wheelR;
        this.recipeGrid.put(new Vector2i(0, 0), handle);
        this.recipeGrid.put(new Vector2i(2, 0), handle);
        this.recipeGrid.put(new Vector2i(0, 1), strut);
        this.recipeGrid.put(new Vector2i(1, 1), platform);
        this.recipeGrid.put(new Vector2i(2, 1), strut);
        this.recipeGrid.put(new Vector2i(0, 2), wheelL);
        this.recipeGrid.put(new Vector2i(2, 2), wheelR);
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public PlacementInfo placementInfo() {
        if (this.placement == null) {
            this.placement = PlacementInfo.createFromOptionals(List.of(Optional.of(this.handle), Optional.empty(), Optional.of(this.handle), Optional.of(this.strut), Optional.of(this.platform), Optional.of(this.strut), Optional.of(this.wheelLeft), Optional.empty(), Optional.of(this.wheelRight)));
        }
        return this.placement;
    }

    public boolean fits(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean matches(CraftingInput inv, Level var2) {
        for (int x = 0; x < inv.width() - 2; ++x) {
            for (int y = 0; y < inv.height() - 2; ++y) {
                if (!this.checkFrom(inv, x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getResult(RegistryAccess var2) {
        return this.result.copy();
    }

    public ItemStack craft(CraftingInput inv, HolderLookup.Provider registries) {
        for (int x = 0; x < inv.width() - 2; ++x) {
            for (int y = 0; y < inv.height() - 2; ++y) {
                NonNullList<ItemStack> components;
                if (!this.checkFrom(inv, x, y) || (components = this.getDataComps(inv, x, y)) == null) continue;
                ItemStack walker = this.result.copy();
                WalkerItem.setWheels(walker, (ItemStack)components.get(0), (ItemStack)components.get(1));
                return walker;
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean checkFrom(CraftingInput inv, int x, int y) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack stackInSlot = inv.getItem(this.coordsToIndex(i + x, j + y, inv.width()));
                Vector2i gridSlot = new Vector2i(i, j);
                if (!(this.recipeGrid.containsKey(gridSlot) ? !this.recipeGrid.get(gridSlot).test(stackInSlot) : !stackInSlot.isEmpty())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    private NonNullList<ItemStack> getDataComps(CraftingInput inv, int x, int y) {
        NonNullList wheels = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        int leftWheelSlot = this.coordsToIndex(0 + x, 2 + y, inv.width());
        int rightWheelSlot = this.coordsToIndex(2 + x, 2 + y, inv.width());
        if (inv.getItem(leftWheelSlot).isEmpty() || !this.wheelLeft.test(inv.getItem(leftWheelSlot))) {
            return null;
        }
        wheels.set(0, (Object)inv.getItem(leftWheelSlot));
        if (inv.getItem(rightWheelSlot).isEmpty() || !this.wheelLeft.test(inv.getItem(rightWheelSlot))) {
            return null;
        }
        wheels.set(1, (Object)inv.getItem(rightWheelSlot));
        return wheels;
    }

    private int coordsToIndex(int x, int y, int width) {
        return x + y * width;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return (RecipeSerializer)WHCSpecialRecipes.WALKER_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<RecipeWalker> {
        private static final MapCodec<RecipeWalker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC.fieldOf("strut").forGetter(r -> r.strut), (App)Ingredient.CODEC.fieldOf("platform").forGetter(r -> r.platform), (App)Ingredient.CODEC.fieldOf("handle").forGetter(r -> r.handle), (App)Ingredient.CODEC.fieldOf("left_wheel").forGetter(r -> r.wheelLeft), (App)Ingredient.CODEC.fieldOf("right_wheel").forGetter(r -> r.wheelRight)).apply((Applicative)instance, RecipeWalker::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, RecipeWalker> PACKET_CODEC = StreamCodec.ofMember((r, buf) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)r.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.strut);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.platform);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.handle);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.wheelLeft);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.wheelRight);
        }, buf -> new RecipeWalker((ItemStack)ItemStack.STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf)));

        public MapCodec<RecipeWalker> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeWalker> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

