/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.data.WHCTags;
import com.lying.data.recipe.RecipeWalker;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class RecipeWalkerJsonBuilder {
    private final RecipeCategory category;
    private final ItemStack result;
    private final Ingredient strut;
    private final Ingredient platform;
    private final Ingredient wheelL;
    private final Ingredient wheelR;
    private final Ingredient handle;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public RecipeWalkerJsonBuilder(ItemStack result, Ingredient strut, Ingredient platform, RecipeCategory category) {
        this(result, strut, platform, Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK}), Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(WHCTags.WHEEL)), Ingredient.of((HolderSet)BuiltInRegistries.ITEM.getOrThrow(WHCTags.WHEEL)), category);
    }

    public RecipeWalkerJsonBuilder(ItemStack result, Ingredient strut, Ingredient platform, Ingredient handle, Ingredient wheelL, Ingredient wheelR, RecipeCategory category) {
        this.category = category;
        this.strut = strut;
        this.platform = platform;
        this.handle = handle;
        this.wheelL = wheelL;
        this.wheelR = wheelR;
        this.result = result;
    }

    public RecipeWalkerJsonBuilder criterion(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public void offerTo(RecipeOutput exporter, ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
        ResourceKey id = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)recipeId);
        Advancement.Builder builder = exporter.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceKey)id)).rewards(AdvancementRewards.Builder.recipe((ResourceKey)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        RecipeWalker recipe = new RecipeWalker(this.result, this.strut, this.platform, this.handle, this.wheelL, this.wheelR);
        exporter.accept(id, (Recipe)recipe, builder.build(recipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

