/*
 * Decompiled with CFR 0.152.
 */
package com.lying.data.recipe;

import com.lying.init.WHCSpecialRecipes;
import com.lying.item.WheelchairItem;
import com.lying.reference.Reference;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RecipeWheelchair
implements CraftingRecipe {
    public static final ResourceLocation ID = Reference.ModInfo.prefix("wheelchair");
    private final ItemStack result;
    private final Ingredient backing;
    private final Ingredient cushion;
    private final Ingredient wheelLeft;
    private final Ingredient wheelRight;
    private PlacementInfo placement = null;

    public RecipeWheelchair(ItemStack result, Ingredient backing, Ingredient cushion, Optional<Ingredient> wheelL, Optional<Ingredient> wheelR) {
        this.result = result;
        this.backing = backing;
        this.cushion = cushion;
        this.wheelLeft = wheelL.get();
        this.wheelRight = wheelR.get();
    }

    public RecipeWheelchair(ItemStack result, Ingredient backing, Ingredient cushion, Ingredient wheelL, Ingredient wheelR) {
        this.result = result;
        this.backing = backing;
        this.cushion = cushion;
        this.wheelLeft = wheelL;
        this.wheelRight = wheelR;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public PlacementInfo placementInfo() {
        if (this.placement == null) {
            this.placement = PlacementInfo.createFromOptionals(List.of(Optional.empty(), Optional.of(this.backing), Optional.empty(), Optional.of(this.wheelLeft), Optional.of(this.cushion), Optional.of(this.wheelRight)));
        }
        return this.placement;
    }

    public boolean fits(int width, int height) {
        return width >= 3 && height >= 2;
    }

    public boolean matches(CraftingInput inv, Level var2) {
        for (int x = 0; x < inv.width() - 2; ++x) {
            for (int y = 0; y < inv.height() - 1; ++y) {
                if (this.checkFrom(inv, x, y) == null) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack getResult(RegistryAccess var2) {
        return this.result.copy();
    }

    public ItemStack craft(CraftingInput inv, HolderLookup.Provider var2) {
        for (int x = 0; x < inv.width() - 2; ++x) {
            for (int y = 0; y < inv.height() - 1; ++y) {
                NonNullList<ItemStack> contents = this.checkFrom(inv, x, y);
                if (contents == null) continue;
                ItemStack chair = this.result.copy();
                WheelchairItem.setWheels(chair, (ItemStack)contents.get(2), (ItemStack)contents.get(3));
                ItemStack dye = (ItemStack)contents.get(1);
                int colour = 0xF9FFFE;
                if (dye.getItem() instanceof BlockItem) {
                    colour = ((BlockItem)dye.getItem()).getBlock().defaultMapColor().col;
                } else if (dye.getItem() instanceof DyeItem) {
                    colour = ((DyeItem)dye.getItem()).getDyeColor().getMapColor().col;
                } else if (dye.has(DataComponents.DYED_COLOR)) {
                    colour = ((DyedItemColor)dye.get(DataComponents.DYED_COLOR)).rgb();
                }
                chair.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(colour, true));
                return chair;
            }
        }
        return ItemStack.EMPTY;
    }

    @Nullable
    private NonNullList<ItemStack> checkFrom(CraftingInput inv, int x, int y) {
        NonNullList entries = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        int emptyA = this.coordsToIndex(x, y, inv.width());
        int emptyB = this.coordsToIndex(x + 2, y, inv.width());
        if (!inv.getItem(emptyA).isEmpty() || !inv.getItem(emptyB).isEmpty()) {
            return null;
        }
        int backing = this.coordsToIndex(x + 1, y, inv.width());
        if (!this.backing.test(inv.getItem(backing))) {
            return null;
        }
        entries.set(0, (Object)inv.getItem(backing));
        int cushion = this.coordsToIndex(x + 1, y + 1, inv.width());
        if (!this.cushion.test(inv.getItem(cushion))) {
            return null;
        }
        entries.set(1, (Object)inv.getItem(cushion));
        int leftWheel = this.coordsToIndex(x, y + 1, inv.width());
        if (!this.wheelLeft.test(inv.getItem(leftWheel))) {
            return null;
        }
        entries.set(2, (Object)inv.getItem(leftWheel));
        int rightWheel = this.coordsToIndex(x + 2, y + 1, inv.width());
        if (!this.wheelRight.test(inv.getItem(rightWheel))) {
            return null;
        }
        entries.set(3, (Object)inv.getItem(rightWheel));
        List<Integer> usedIndices = List.of(Integer.valueOf(emptyA), Integer.valueOf(backing), Integer.valueOf(emptyB), Integer.valueOf(leftWheel), Integer.valueOf(cushion), Integer.valueOf(rightWheel));
        for (int i = 0; i < inv.size(); ++i) {
            if (usedIndices.contains(i) || inv.getItem(i).isEmpty()) continue;
            return null;
        }
        return entries.stream().anyMatch(ItemStack::isEmpty) ? null : entries;
    }

    private int coordsToIndex(int x, int y, int width) {
        return x + y * width;
    }

    public RecipeSerializer<? extends CraftingRecipe> getSerializer() {
        return (RecipeSerializer)WHCSpecialRecipes.WHEELCHAIR_SERIALIZER.get();
    }

    public static int componentsToColor(float[] comp) {
        int r = (int)(comp[0] * 255.0f);
        int g = (int)(comp[1] * 255.0f);
        int b = (int)(comp[2] * 255.0f);
        int col = r;
        col = (col << 8) + g;
        col = (col << 8) + b;
        return col;
    }

    public static class Serializer
    implements RecipeSerializer<RecipeWheelchair> {
        private static final MapCodec<RecipeWheelchair> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Ingredient.CODEC.fieldOf("backing").forGetter(r -> r.backing), (App)Ingredient.CODEC.fieldOf("cushion").forGetter(r -> r.cushion), (App)Ingredient.CODEC.optionalFieldOf("left_wheel").forGetter(r -> Optional.of(r.wheelLeft)), (App)Ingredient.CODEC.optionalFieldOf("right_wheel").forGetter(r -> Optional.of(r.wheelRight))).apply((Applicative)instance, RecipeWheelchair::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, RecipeWheelchair> PACKET_CODEC = StreamCodec.ofMember((r, buf) -> {
            ItemStack.STREAM_CODEC.encode(buf, (Object)r.result);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.backing);
            Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)r.cushion);
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode(buf, Optional.of(r.wheelLeft));
            Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.encode(buf, Optional.of(r.wheelRight));
        }, buf -> new RecipeWheelchair((ItemStack)ItemStack.STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf), (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode(buf), (Optional)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC.decode(buf)));

        public MapCodec<RecipeWheelchair> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, RecipeWheelchair> streamCodec() {
            return PACKET_CODEC;
        }
    }
}

