/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.lying.Wheelchairs;
import com.lying.entity.WheelchairEntity;
import com.lying.init.WHCChairUpgrades;
import com.lying.reference.Reference;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.function.Consumers;
import org.slf4j.Logger;

public class ChairUpgrade {
    public static final Codec<ChairUpgrade> CODEC = Codec.of(ChairUpgrade::encodeToOps, ChairUpgrade::decodeFromOps);
    public static final StreamCodec<RegistryFriendlyByteBuf, ChairUpgrade> PACKET_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ChairUpgrade::registryName, WHCChairUpgrades::get);
    private final ResourceLocation name;
    private final Predicate<ItemStack> isKeyItem;
    private final Item dropItem;
    private final boolean hasModel;
    private final boolean enablesScreen;
    private final Consumer<WheelchairEntity> onApplied;
    private final Consumer<WheelchairEntity> onRemoved;
    private final Map<Holder<Attribute>, AttributeModifier> attributeModifiers = Maps.newHashMap();
    private final Predicate<WheelchairEntity> isValid;
    private final Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith;

    private static <T> DataResult<T> encodeToOps(ChairUpgrade upg, DynamicOps<T> ops, T prefix) {
        return DataResult.success((Object)ops.createString(upg.registryName().toString()));
    }

    private static <T> DataResult<Pair<ChairUpgrade, T>> decodeFromOps(DynamicOps<T> ops, T input) {
        ChairUpgrade condition = WHCChairUpgrades.get(ResourceLocation.parse((String)((String)ops.getStringValue(input).getOrThrow())));
        return condition == null ? DataResult.error(() -> "Error reading wheelchair upgrade from data") : DataResult.success((Object)Pair.of((Object)condition, input));
    }

    protected ChairUpgrade(ResourceLocation nameIn, boolean modelled, boolean screenEnabler, Predicate<ItemStack> keyItem, Item dropItem, Predicate<WheelchairEntity> valid, Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith, Consumer<WheelchairEntity> applied, Consumer<WheelchairEntity> removed, Map<Holder<Attribute>, AttributeModifier> modifiers) {
        this.name = nameIn;
        this.hasModel = modelled;
        this.enablesScreen = screenEnabler;
        this.isKeyItem = keyItem;
        this.dropItem = dropItem;
        this.isValid = valid;
        this.incompatibleWith = incompatibleWith;
        this.onApplied = applied;
        this.onRemoved = removed;
        modifiers.entrySet().forEach(entry -> this.attributeModifiers.put((Holder<Attribute>)((Holder)entry.getKey()), (AttributeModifier)entry.getValue()));
    }

    public final ResourceLocation registryName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof ChairUpgrade && ((ChairUpgrade)obj).registryName().equals((Object)this.name);
    }

    public <T> T encode(DynamicOps<T> ops) {
        return CODEC.encodeStart(ops, (Object)this).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> ChairUpgrade decode(DynamicOps<T> ops, T input) {
        return (ChairUpgrade)CODEC.parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> T encodeList(DynamicOps<T> ops, List<ChairUpgrade> list) {
        return CODEC.listOf().encodeStart(ops, list).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public static <T> List<ChairUpgrade> decodeList(DynamicOps<T> ops, T input) {
        return (List)CODEC.listOf().parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Wheelchairs.LOGGER).error(arg_0)).orElseThrow();
    }

    public Component translate() {
        return Component.translatable((String)("upgrade." + this.name.getNamespace() + "." + this.name.getPath()));
    }

    public Item dropItem() {
        return this.dropItem;
    }

    public boolean matches(ItemStack stack) {
        return this.isKeyItem.apply((Object)stack);
    }

    public boolean canApplyTo(WheelchairEntity chair) {
        return !chair.hasUpgrade(this) && this.isValid.apply((Object)chair);
    }

    public final boolean compatibleWith(ChairUpgrade upgrade) {
        return this.incompatibleWith.get().isEmpty() ? true : this.incompatibleWith.get().stream().noneMatch(upg -> upg == upgrade);
    }

    public static boolean canCombineWith(ChairUpgrade upgradeA, ChairUpgrade upgradeB) {
        return upgradeA.compatibleWith(upgradeB) && upgradeB.compatibleWith(upgradeA);
    }

    public void applyTo(WheelchairEntity chair) {
        this.onApplied.accept(chair);
    }

    public void removeFrom(WheelchairEntity chair) {
        this.onRemoved.accept(chair);
    }

    public void onStartRiding(LivingEntity rider) {
        if (!this.attributeModifiers.isEmpty()) {
            this.attributeModifiers.entrySet().forEach(entry -> {
                AttributeInstance instance = rider.getAttributes().getInstance((Holder)entry.getKey());
                if (instance == null || instance.hasModifier(((AttributeModifier)entry.getValue()).id())) {
                    return;
                }
                instance.addTransientModifier((AttributeModifier)entry.getValue());
            });
        }
    }

    public void onStopRiding(LivingEntity rider) {
        if (!this.attributeModifiers.isEmpty()) {
            this.attributeModifiers.entrySet().forEach(entry -> {
                AttributeInstance instance = rider.getAttributes().getInstance((Holder)entry.getKey());
                if (instance != null) {
                    instance.removeModifier((AttributeModifier)entry.getValue());
                }
            });
        }
    }

    public boolean hasModel() {
        return this.hasModel;
    }

    public boolean enablesScreen() {
        return this.enablesScreen;
    }

    public static class Builder {
        private final ResourceLocation name;
        private Predicate<ItemStack> isKeyItem = Predicates.alwaysFalse();
        private Item dropItem = Items.STICK;
        private Predicate<WheelchairEntity> isValid = Predicates.alwaysTrue();
        private Supplier<List<Supplier<ChairUpgrade>>> incompatibleWith = () -> Lists.newArrayList();
        private boolean hasModel = false;
        private Consumer<WheelchairEntity> onApplied = Consumers.nop();
        private Consumer<WheelchairEntity> onRemoved = Consumers.nop();
        private final Map<Holder<Attribute>, AttributeModifier> attributeModifiers = new HashMap<Holder<Attribute>, AttributeModifier>();
        private boolean enablesScreen = false;

        protected Builder(ResourceLocation nameIn) {
            this.name = nameIn;
        }

        public static Builder of(String nameIn) {
            return new Builder(Reference.ModInfo.prefix(nameIn));
        }

        public final Builder keyItem(Item itemIn) {
            this.dropItem = itemIn;
            this.keyItem((Predicate<ItemStack>)((Predicate)stack -> stack.getItem() == itemIn));
            return this;
        }

        public final Builder keyItem(Predicate<ItemStack> itemIn) {
            this.isKeyItem = itemIn;
            return this;
        }

        public final Builder dropItem(Item itemIn) {
            this.dropItem = itemIn;
            return this;
        }

        public final Builder isValid(Predicate<WheelchairEntity> validIn) {
            this.isValid = validIn;
            return this;
        }

        public final Builder incompatible(Supplier<List<Supplier<ChairUpgrade>>> upgrades) {
            this.incompatibleWith = upgrades;
            return this;
        }

        public final Builder applied(Consumer<WheelchairEntity> func) {
            this.onApplied = func;
            return this;
        }

        public final Builder removed(Consumer<WheelchairEntity> func) {
            this.onRemoved = func;
            return this;
        }

        public final Builder attribute(Holder<Attribute> attribute, String uuid, double amount, AttributeModifier.Operation operation) {
            this.attributeModifiers.put(attribute, new AttributeModifier(this.name, amount, operation));
            return this;
        }

        public final Builder modelled() {
            this.hasModel = true;
            return this;
        }

        public final Builder enablesScreen() {
            this.enablesScreen = true;
            return this;
        }

        public ChairUpgrade build() {
            return new ChairUpgrade(this.name, this.hasModel, this.enablesScreen, this.isKeyItem, this.dropItem, this.isValid, this.incompatibleWith, this.onApplied, this.onRemoved, this.attributeModifiers);
        }
    }
}

