/*
 * Decompiled with CFR 0.152.
 */
package com.lying.entity;

import com.google.common.collect.Lists;
import com.lying.Wheelchairs;
import com.lying.init.WHCSoundEvents;
import com.lying.utility.ServerEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IParentedEntity {
    public static final double SEARCH_RANGE = 8.0;

    public static Predicate<Entity> isChildOf(LivingEntity entity) {
        return ent -> ent.isAlive() && ent instanceof IParentedEntity && ((IParentedEntity)ent).isParent((Entity)entity);
    }

    public boolean hasParent();

    public boolean isParent(Entity var1);

    @Nullable
    public LivingEntity getParent();

    public void parentTo(@Nullable LivingEntity var1);

    default public void clearParent() {
        this.parentTo(null);
    }

    default public Vec3 getParentOffset(LivingEntity parent, float yaw, float pitch) {
        return Vec3.ZERO;
    }

    default public void tickParented(@NotNull LivingEntity parent, float yaw, float pitch) {
    }

    @Nullable
    default public <T extends LivingEntity> LivingEntity tryGetParent() {
        return this instanceof LivingEntity ? IParentedEntity.getParentOf((LivingEntity)this) : null;
    }

    @Nullable
    public static <T extends LivingEntity> LivingEntity getParentOf(T entity) {
        Optional bestGuess = entity.level().getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(8.0), ent -> ent.isAlive() && ((IParentedEntity)entity).isParent((Entity)ent)).stream().findFirst();
        return bestGuess.orElseGet(() -> null);
    }

    public static <T extends LivingEntity> List<T> getParentedEntitiesOf(LivingEntity ent) {
        ArrayList list = Lists.newArrayList();
        for (LivingEntity living : ent.level().getEntitiesOfClass(LivingEntity.class, ent.getBoundingBox().inflate(8.0), wal -> wal instanceof IParentedEntity && ((IParentedEntity)wal).isParent((Entity)ent))) {
            list.add(living);
        }
        return list;
    }

    public static boolean hasParentedEntities(LivingEntity ent) {
        return IParentedEntity.getParentedEntitiesOf(ent).isEmpty();
    }

    public static Vec3 getRotationVector(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = Mth.cos((float)g);
        float i = Mth.sin((float)g);
        float j = Mth.cos((float)f);
        float k = Mth.sin((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    default public <T extends LivingEntity> boolean canParentToChild(LivingEntity parent, T child) {
        return !parent.isPassenger() && (double)parent.distanceTo(child) < 5.0 && (!Wheelchairs.config.handsyWalkers() || child.getMainHandItem().isEmpty() || child.getOffhandItem().isEmpty());
    }

    public static <T extends LivingEntity> void updateParentingBond(T child, LivingEntity parent, Entity.MoveFunction positionUpdater) {
        if (child == null || parent == null || parent == child || !((IParentedEntity)child).isParent((Entity)parent)) {
            return;
        }
        child.setDeltaMovement(Vec3.ZERO);
        child.tick();
        float yaw = parent.yBodyRot;
        float pitch = parent.getXRot();
        ((IParentedEntity)child).tickParented(parent, yaw, pitch);
        if (!((IParentedEntity)child).hasParent()) {
            return;
        }
        Vec3 dest = parent.position().add(((IParentedEntity)child).getParentOffset(parent, yaw, pitch));
        positionUpdater.accept(child, dest.x, dest.y, dest.z);
    }

    public static Vec3 rotateOffset(Vec3 offset, float parentYaw) {
        return offset.yRot(-parentYaw * ((float)Math.PI / 180));
    }

    public static <T extends LivingEntity> boolean bindToPlayer(Player player, T walker) {
        if (walker.level().isClientSide()) {
            return false;
        }
        if (((IParentedEntity)walker).isParent((Entity)player)) {
            ((IParentedEntity)walker).parentTo(null);
            walker.playSound((SoundEvent)WHCSoundEvents.SEATBELT_OFF.get(), 1.0f, 1.0f);
            return true;
        }
        if ((!((IParentedEntity)walker).hasParent() || player.isCreative()) && ((IParentedEntity)walker).canParentToChild((LivingEntity)player, walker)) {
            ((IParentedEntity)walker).parentTo((LivingEntity)player);
            walker.playSound((SoundEvent)WHCSoundEvents.SEATBELT_ON.get(), 1.0f, 1.0f);
            ((ServerEvents.WalkerBindEvent)ServerEvents.ON_ENTITY_PARENT.invoker()).onParentToEntity((LivingEntity)player, walker);
            return true;
        }
        return false;
    }

    public static void clearParentedEntities(LivingEntity parent, @Nullable LivingEntity ignore) {
        parent.level().getEntitiesOfClass(LivingEntity.class, parent.getBoundingBox().inflate(8.0), IParentedEntity.isChildOf(parent).and(entity -> entity != ignore)).forEach(ent -> ((IParentedEntity)ent).clearParent());
    }
}

